#!/bin/sh
#OUTFILENAME defines the name prefix for the output files generated by the evaluation scheme in the OUTDIRNAME
OUTFILENAME=unlv_tables_eval
#OUTDIRNAME is the directory where the evaluation images for different level of abstraction are shown and the results for evaluation are dumped to a text file.
OUTDIRNAME=sample/evaluation
#GTDIR is the directory which contains the ground truth images generated by paint_segments
GTDIR=sample/evaluation/gt
#RESULTDIR is the directory which contains the result images obtained by a table recognition algorithm and results painted by paint_segments
RESULTDIR=sample/evaluation/result
FILESUFFIX=.png
#A log of evaluation in the output dir 
LOGFILE=$OUTDIRNAME/eval.log

JAVA_OPTS="-Xms128m -Xmx512m -Dde.dfki.trecs.evaluation.segmentevaluation.outdir=$OUTDIRNAME -Dde.dfki.trecs.evaluation.segmentevaluation.outfile=$OUTFILENAME"
CLASSPATH="jar/gtgui.jar:jar/tablerecognizer.jar:jar/jiu.jar"
for f in $GTDIR/*$FILESUFFIX; do
IMGFILENAME=`basename $f`
 if [ -a $RESULTDIR/$IMGFILENAME ]; then
   echo Processing $IMGFILENAME>>$LOGFILE
   java $JAVA_OPTS -cp $CLASSPATH de.dfki.trecs.evaluation.SegmentEvaluation $GTDIR/$IMGFILENAME $RESULTDIR/$IMGFILENAME>>$LOGFILE
 else
   echo Result file doesnt exist for $IMGFILENAME
 fi
done
#if [ $# != "2" ]; then
#  echo "Usage: ./segment_evaluation.sh ground_truth_image segmented_image"
#else
# java $JAVA_OPTS -cp $CLASSPATH de.dfki.trecs.evaluation.SegmentEvaluation $1 $2
#fi


