/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.trecs.groundtruth.image;

import de.dfki.tablerecognizer.block.BoundingBox;
import de.dfki.tablerecognizer.util.XMLManager;
import de.dfki.trecs.groundtruth.color.ColorEnumerator;
import de.dfki.trecs.groundtruth.color.ColorModel16Bit;
import de.dfki.trecs.groundtruth.data.GTCell;
import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Logger;
import net.sourceforge.jiu.codecs.PNGCodec;
import net.sourceforge.jiu.color.promotion.PromotionRGB48;
import net.sourceforge.jiu.data.MemoryRGB48Image;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.data.RGB48Image;
import net.sourceforge.jiu.gui.awt.ToolkitLoader;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GroundTruthImage {
    public static int FOREGROUND_CHANNEL_BBOX = 15;

    private static Logger log() {
        return Logger.getLogger(GroundTruthImage.class.getName());
    }

    public static void main(String[] args) {
        GroundTruthImage.produceGroundTruthImage(args[0], args[1], args[2], args[3]);
        System.out.println("Successfully painted the image : output in " + args[1]);
    }

    public static void produceGroundTruthImage(String src, String target, String gtXml, String wordXmlfile) {
        XMLManager manager = new XMLManager();
        Document xmlDoc = manager.parse(gtXml);
        PixelImage image = ToolkitLoader.loadViaToolkitOrCodecs((String)src);
        MemoryRGB48Image rgb48Image = null;
        GroundTruthImage.log().info("promoting image to RGB48");
        PromotionRGB48 imgOperation = new PromotionRGB48();
        imgOperation.setInputImage(image);
        try {
            imgOperation.process();
        }
        catch (Exception ex) {
            System.out.println("Error transforming image to 48bit");
        }
        rgb48Image = (MemoryRGB48Image)imgOperation.getOutputImage();
        MemoryRGB48Image rgb48WordImage = null;
        rgb48WordImage = (MemoryRGB48Image)rgb48Image.createCopy();
        if (rgb48Image != null) {
            GroundTruthImage.log().info("Image promoted, Reading words from xml file and painting them on image.");
            ArrayList<BoundingBox> words = GroundTruthImage.readWordsFromXMLFile(wordXmlfile);
            Color wordColor = new Color(FOREGROUND_CHANNEL_BBOX, FOREGROUND_CHANNEL_BBOX, FOREGROUND_CHANNEL_BBOX);
            for (BoundingBox word : words) {
                GroundTruthImage.colorImageForeground(rgb48WordImage, word, wordColor);
            }
            GroundTruthImage.log().info("Image painted with word boxes, Now painting tables.");
            NodeList tableList = manager.getElementsByTagName(xmlDoc, "Table");
            int i = 0;
            while (i < tableList.getLength()) {
                Node tableNode = tableList.item(i);
                NodeList cellsList = tableNode.getChildNodes();
                int j = 0;
                while (j < cellsList.getLength()) {
                    Node cellNode = cellsList.item(j);
                    if (cellNode.getNodeName().equals("Cell")) {
                        int x0 = Integer.parseInt(cellNode.getAttributes().getNamedItem("x0").getTextContent());
                        int y0 = Integer.parseInt(cellNode.getAttributes().getNamedItem("y0").getTextContent());
                        int x1 = Integer.parseInt(cellNode.getAttributes().getNamedItem("x1").getTextContent());
                        int y1 = Integer.parseInt(cellNode.getAttributes().getNamedItem("y1").getTextContent());
                        boolean dontCare = false;
                        try {
                            dontCare = Boolean.parseBoolean(cellNode.getAttributes().getNamedItem("dontCare").getTextContent());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (!dontCare) {
                            String colorString = cellNode.getTextContent();
                            ColorModel16Bit color = ColorModel16Bit.parseColor(colorString.trim());
                            GTCell cell = new GTCell(x0, y0, x1, y1);
                            cell.setColor(color);
                            GroundTruthImage.colorImageForeground(rgb48Image, rgb48WordImage, cell);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        PNGCodec codec = new PNGCodec();
        try {
            codec.setOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(new File(target))));
            codec.setImage((PixelImage)rgb48Image);
            codec.process();
            codec.close();
        }
        catch (Exception e) {
            System.out.println("Error saving the ground truth image file");
            return;
        }
    }

    private static ArrayList<BoundingBox> readWordsFromXMLFile(String xmlfile) {
        ArrayList<BoundingBox> words = new ArrayList<BoundingBox>();
        XMLManager manager = new XMLManager(xmlfile, true);
        int docWidth = 0;
        int docHeight = 0;
        int docDPI = 0;
        NodeList nodelist = manager.getElementsByTagName(manager.getDocument(), "docinfo");
        if (nodelist.getLength() == 1) {
            Node node = nodelist.item(0);
            NamedNodeMap nnm = node.getAttributes();
            docWidth = Integer.parseInt(nnm.getNamedItem("width").getNodeValue());
            docHeight = Integer.parseInt(nnm.getNamedItem("height").getNodeValue());
            docDPI = Integer.parseInt(nnm.getNamedItem("dpix").getNodeValue());
        }
        nodelist = manager.getElementsByTagName(manager.getDocument(), "word");
        int i = 0;
        while (i < nodelist.getLength()) {
            int y1;
            Object content = null;
            Node node = nodelist.item(i);
            NamedNodeMap nnm = node.getAttributes();
            int x0 = Integer.parseInt(nnm.getNamedItem("left").getNodeValue());
            int y0 = Integer.parseInt(nnm.getNamedItem("bottom").getNodeValue());
            int x1 = Integer.parseInt(nnm.getNamedItem("right").getNodeValue());
            int temp = y1 = Integer.parseInt(nnm.getNamedItem("top").getNodeValue());
            y1 = Math.abs(docHeight - y0);
            y0 = Math.abs(docHeight - temp);
            BoundingBox box = new BoundingBox(x0, y0, x1, y1);
            words.add(box);
            ++i;
        }
        return words;
    }

    private static void colorImageForeground(MemoryRGB48Image image, BoundingBox cell, Color color) {
        int[] R = new int[cell.getWidth() * cell.getHeight()];
        int[] G = new int[cell.getWidth() * cell.getHeight()];
        int[] B = new int[cell.getWidth() * cell.getHeight()];
        image.getSamples(0, cell.getX0(), cell.getY0(), cell.getWidth(), cell.getHeight(), R, 0);
        image.getSamples(1, cell.getX0(), cell.getY0(), cell.getWidth(), cell.getHeight(), G, 0);
        image.getSamples(2, cell.getX0(), cell.getY0(), cell.getWidth(), cell.getHeight(), B, 0);
        int r = 0;
        while (r < R.length) {
            if (R[r] != 65535) {
                R[r] = 0;
            }
            if (G[r] != 65535) {
                G[r] = 65535;
            }
            if (B[r] != 65535) {
                B[r] = 0;
            }
            ++r;
        }
        image.putSamples(0, cell.getX0(), cell.getY0(), cell.getWidth(), cell.getHeight(), R, 0);
        image.putSamples(1, cell.getX0(), cell.getY0(), cell.getWidth(), cell.getHeight(), G, 0);
        image.putSamples(2, cell.getX0(), cell.getY0(), cell.getWidth(), cell.getHeight(), B, 0);
    }

    public static RGB48Image recolorImage(RGB48Image img) {
        RGB48Image out_img = (RGB48Image)img.createCopy();
        ColorEnumerator enumerator = ColorEnumerator.enumerateColorsInImage(out_img, 0);
        short[] imglabels = enumerator.getNormalizedImage();
        int j = 0;
        while (j < out_img.getHeight()) {
            int i = 0;
            while (i < out_img.getWidth()) {
                int index = j * out_img.getWidth() + i;
                short label = imglabels[index];
                if (label > 2) {
                    ColorModel16Bit color = GroundTruthImage.interestingColors(label);
                    out_img.putSample(0, i, j, color.getR());
                    out_img.putSample(1, i, j, color.getG());
                    out_img.putSample(2, i, j, color.getB());
                }
                ++i;
            }
            ++j;
        }
        return out_img;
    }

    private static ColorModel16Bit interestingColors(int x) {
        int r = 0;
        int g = 0;
        int b = 0;
        int i = 0;
        while (i < 8) {
            r = r << 1 | x & 1;
            g = g << 1 | (x >>= 1) & 1;
            b = b << 1 | (x >>= 1) & 1;
            x >>= 1;
            ++i;
        }
        return ColorModel16Bit.ColorModel8Bit(r, g, b);
    }

    private static void colorImageForeground(MemoryRGB48Image image, MemoryRGB48Image rgb48WordImage, GTCell cell) {
        int[] R = new int[cell.getWidth() * cell.getHeight()];
        int[] G = new int[cell.getWidth() * cell.getHeight()];
        int[] B = new int[cell.getWidth() * cell.getHeight()];
        image.getSamples(0, cell.getX0(), cell.getY0(), cell.getWidth(), cell.getHeight(), R, 0);
        image.getSamples(1, cell.getX0(), cell.getY0(), cell.getWidth(), cell.getHeight(), G, 0);
        image.getSamples(2, cell.getX0(), cell.getY0(), cell.getWidth(), cell.getHeight(), B, 0);
        int[] Rw = new int[cell.getWidth() * cell.getHeight()];
        int[] Gw = new int[cell.getWidth() * cell.getHeight()];
        int[] Bw = new int[cell.getWidth() * cell.getHeight()];
        rgb48WordImage.getSamples(0, cell.getX0(), cell.getY0(), cell.getWidth(), cell.getHeight(), Rw, 0);
        rgb48WordImage.getSamples(1, cell.getX0(), cell.getY0(), cell.getWidth(), cell.getHeight(), Gw, 0);
        rgb48WordImage.getSamples(2, cell.getX0(), cell.getY0(), cell.getWidth(), cell.getHeight(), Bw, 0);
        int r = 0;
        while (r < R.length) {
            if (Gw[r] == 65535) {
                if (R[r] != 65535) {
                    R[r] = cell.getColor().getR();
                }
                if (G[r] != 65535) {
                    G[r] = cell.getColor().getG();
                }
                if (B[r] != 65535) {
                    B[r] = cell.getColor().getB();
                }
            }
            ++r;
        }
        image.putSamples(0, cell.getX0(), cell.getY0(), cell.getWidth(), cell.getHeight(), R, 0);
        image.putSamples(1, cell.getX0(), cell.getY0(), cell.getWidth(), cell.getHeight(), G, 0);
        image.putSamples(2, cell.getX0(), cell.getY0(), cell.getWidth(), cell.getHeight(), B, 0);
    }
}

