/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.trecs.groundtruth.gui;

import de.dfki.trecs.groundtruth.gui.CanvasState;
import de.dfki.trecs.groundtruth.gui.GTGui;
import de.dfki.trecs.groundtruth.gui.OperationProcessor;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.gui.awt.ToolkitLoader;

public class GTOperationProcessor
extends OperationProcessor {
    private GTGui frame;

    public GTOperationProcessor(GTGui frame, CanvasState state) {
        super(state);
        this.frame = frame;
    }

    @Override
    public void fileClose() {
        this.frame.close();
    }

    @Override
    public void assignColors() {
        this.state.evaluateTableCells();
        this.frame.getCanvas().repaint();
    }

    @Override
    public void saveGroundTruthFile() {
        File file = null;
        FileDialog fd = new FileDialog((Frame)this.frame, "Save Ground Truth File", 1);
        String dir = this.state.getCurrentDirectory();
        if (dir != null) {
            fd.setDirectory(dir);
        }
        fd.setVisible(true);
        String dn = fd.getDirectory();
        String fn = fd.getFile();
        if (fn == null || dn == null) {
            return;
        }
        file = new File(dn, fn);
        this.state.saveGroundTruthFile(file);
        this.frame.endTimeLog();
    }

    @Override
    public void fileOpen(String uri) {
        this.frame.close();
        File file = null;
        if (uri == null) {
            FileDialog fd = new FileDialog((Frame)this.frame, "Open Image File", 0);
            String dir = this.state.getCurrentDirectory();
            if (dir != null) {
                fd.setDirectory(dir);
            }
            fd.setVisible(true);
            fd.setMode(0);
            String fn = fd.getFile();
            String dn = fd.getDirectory();
            if (fn == null || dn == null) {
                return;
            }
            this.state.setCurrentDirectory(dn);
            file = new File(dn, fn);
            this.state.setFileName(file.getAbsolutePath());
        } else {
            file = new File(uri);
        }
        if (this.state.isAutoLoadGT()) {
            String fn = file.getName();
            String dn = file.getParent();
            String gtFileName = fn.substring(0, fn.indexOf("."));
            File gtFile = new File(dn, gtFileName = String.valueOf(gtFileName) + ".xml");
            if (gtFile.exists()) {
                this.openGroundTruthFile(gtFile.getAbsolutePath());
            }
        }
        this.frame.startTimeLog();
        PixelImage image = ToolkitLoader.loadViaToolkitOrCodecs((String)file.getAbsolutePath());
        this.state.setImage(image, false);
        this.frame.updateImage();
    }

    @Override
    public void openGroundTruthFile(String uri) {
        File gtfile = null;
        if (uri == null) {
            if (this.state.getFileName() == null) {
                this.frame.showWarningBox("No Image loaded, load image first");
                return;
            }
            FileDialog fd = new FileDialog((Frame)this.frame, "Open Ground Truth File", 0);
            String dir = this.state.getCurrentDirectory();
            if (dir != null) {
                fd.setDirectory(dir);
            }
            fd.setVisible(true);
            fd.setMode(0);
            String fn = fd.getFile();
            String dn = fd.getDirectory();
            if (fn == null || dn == null) {
                return;
            }
            gtfile = new File(dn, fn);
        } else {
            gtfile = new File(uri);
        }
        if (gtfile.exists() && gtfile.getAbsolutePath().endsWith("xml")) {
            this.state.loadGroundTruthFile(gtfile);
            this.state.setGroundTruthFile(gtfile.getAbsolutePath());
            this.state.setInitialCellsMarked(true);
            this.frame.getCanvas().repaint();
            this.frame.updateTitle();
        } else {
            this.frame.showWarningBox("Can't load the ground truth file: " + gtfile.getAbsolutePath());
        }
    }

    @Override
    public void exit() {
        this.fileClose();
        this.frame.finishLog();
        System.exit(0);
    }

    @Override
    public void redo() {
        this.state.redo();
        this.frame.getCanvas().repaint();
    }

    @Override
    public void undo() {
        this.state.undo();
        this.frame.getCanvas().repaint();
    }

    @Override
    public void fileSaveAs() {
        if (this.state.getRgb48Image() == null) {
            return;
        }
        File file = null;
        FileDialog fd = new FileDialog((Frame)this.frame, "Save Ground Truth Image File", 1);
        String dir = this.state.getCurrentDirectory();
        if (dir != null) {
            fd.setDirectory(dir);
        }
        fd.setVisible(true);
        String dn = fd.getDirectory();
        String fn = fd.getFile();
        if (fn == null || dn == null) {
            return;
        }
        file = new File(dn, fn);
        this.state.saveGTImage(file);
    }

    @Override
    public void markRowColSpan() {
        this.frame.markRowColSpan();
    }

    @Override
    public void zoomIn() {
        this.frame.zoomIn();
    }

    @Override
    public void zoomOut() {
        this.frame.zoomOut();
    }

    @Override
    public void zoomToFit() {
        this.frame.zoomOriginal();
    }

    @Override
    public void markTable() {
        this.frame.markTable();
    }

    @Override
    public void markRowColumns() {
        this.frame.markRowColumns();
    }
}

