/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.trecs.groundtruth.gui;

import de.dfki.trecs.groundtruth.gui.MenuIndexConstants;
import de.dfki.trecs.groundtruth.gui.OperationProcessor;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GTMenuWrapper
implements MenuIndexConstants {
    private ActionListener listener;
    private MenuItem[] items;
    private MenuBar menuBar = new MenuBar();
    private String[] menuLabels;

    private static Logger log() {
        return Logger.getLogger(GTMenuWrapper.class.getName());
    }

    public GTMenuWrapper(ActionListener listener) {
        this.setListener(listener);
        this.items = new MenuItem[19];
        this.menuLabels = new String[19];
        this.loadMenuLabels();
        this.initItems();
        this.createMenu();
    }

    public void updateEnabled(OperationProcessor processor) {
    }

    public int findIndex(Object o) {
        if (o != null && this.items != null) {
            int i = 0;
            while (i < this.items.length) {
                if (o == this.items[i]) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    private void initItems() {
        int i = 0;
        while (i < this.items.length) {
            MenuItem item;
            String label = this.menuLabels[i];
            this.items[i] = item = new MenuItem(label);
            ++i;
        }
    }

    private void loadMenuLabels() {
        try {
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream("menu.txt");
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            String line = null;
            int index = 0;
            while ((line = reader.readLine()) != null) {
                this.menuLabels[index] = line.trim();
                if (++index > this.menuLabels.length) break;
            }
            reader.close();
        }
        catch (IOException ex) {
            GTMenuWrapper.log().log(Level.SEVERE, "Error loading menu entries from resources/menu.txt", ex.getCause());
            System.exit(-1);
        }
    }

    private void createMenu() {
        Menu fileMenu = new Menu(this.menuLabels[0]);
        this.items[0] = fileMenu;
        fileMenu.add(this.items[1]);
        fileMenu.add(this.items[18]);
        fileMenu.add(this.items[17]);
        fileMenu.add(this.items[4]);
        fileMenu.add(this.items[5]);
        this.menuBar.add(fileMenu);
        Menu editMenu = new Menu(this.menuLabels[13]);
        this.items[13] = editMenu;
        editMenu.add(this.items[6]);
        editMenu.add(this.items[7]);
        editMenu.add(this.items[8]);
        editMenu.add(this.items[9]);
        editMenu.add(this.items[14]);
        editMenu.add(this.items[15]);
        Menu viewMenu = new Menu(this.menuLabels[16]);
        viewMenu.add(this.items[11]);
        viewMenu.add(this.items[10]);
        viewMenu.add(this.items[12]);
        this.menuBar.add(editMenu);
        this.menuBar.add(viewMenu);
        this.addShortcutAndListener();
    }

    private MenuShortcut createMenuShortcut(int menuIndex) {
        switch (menuIndex) {
            case 1: {
                return new MenuShortcut(79);
            }
            case 14: {
                return new MenuShortcut(90);
            }
            case 15: {
                return new MenuShortcut(89);
            }
            case 11: {
                return new MenuShortcut(49);
            }
            case 10: {
                return new MenuShortcut(50);
            }
            case 12: {
                return new MenuShortcut(48);
            }
            case 6: {
                return new MenuShortcut(84);
            }
            case 7: {
                return new MenuShortcut(82);
            }
            case 8: {
                return new MenuShortcut(77);
            }
            case 17: {
                return new MenuShortcut(83);
            }
            case 18: {
                return new MenuShortcut(76);
            }
        }
        return null;
    }

    private void addShortcutAndListener() {
        int i = 0;
        while (i < this.items.length) {
            if (this.items[i] != null) {
                MenuShortcut shortcut = this.createMenuShortcut(i);
                if (shortcut != null) {
                    this.items[i].setShortcut(shortcut);
                }
                this.items[i].addActionListener(this.listener);
            }
            ++i;
        }
    }

    public ActionListener getListener() {
        return this.listener;
    }

    public MenuItem[] getItems() {
        return this.items;
    }

    public MenuBar getMenuBar() {
        return this.menuBar;
    }

    public void setListener(ActionListener listener) {
        this.listener = listener;
    }

    public void setItems(MenuItem[] items) {
        this.items = items;
    }

    public void setMenuBar(MenuBar menuBar) {
        this.menuBar = menuBar;
    }
}

