/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.trecs.groundtruth.gui;

import de.dfki.trecs.groundtruth.gui.CanvasState;
import de.dfki.trecs.groundtruth.gui.GTCanvas;
import de.dfki.trecs.groundtruth.gui.GTMenuWrapper;
import de.dfki.trecs.groundtruth.gui.GTOperationProcessor;
import de.dfki.trecs.groundtruth.util.ImageInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Label;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.util.Date;
import javax.swing.JOptionPane;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.gui.awt.ImageCreator;

public class GTGui
extends Frame
implements ActionListener,
ComponentListener,
KeyListener {
    private GTMenuWrapper menuWrapper;
    private GTCanvas canvas;
    private ScrollPane scrollPane;
    private CanvasState state;
    private GTOperationProcessor processor;
    public static String APP_NAME = "Trecs Ground Truth GUI";
    private long startTime = 0L;
    private long endTime = 0L;
    public static final String LOG_USER = "de.dfki.trecs.groundtruth.gui.loguser";
    public static final String LOG_FILE = "de.dfki.trecs.groundtruth.gui.logfile";
    private PrintWriter logWriter = null;
    private boolean logUser = false;
    private Label statusBar;
    private Label infoBar;
    private boolean previewMode = false;
    private String workDir = null;
    private int currentFileIndex = -1;
    private String[] files = null;

    public void startTimeLog() {
        if (this.isLogUser()) {
            this.startTime = System.currentTimeMillis();
            this.logWriter.println("Start groundtruth for: " + this.state.getFileName() + ":: Time: " + new Date(this.startTime));
        }
    }

    public void endTimeLog() {
        if (this.isLogUser()) {
            this.endTime = System.currentTimeMillis();
            this.logWriter.println("End groundtruth for: " + this.state.getFileName() + ":: Time: " + new Date(this.endTime));
            this.logWriter.println("Time Elapsed(ms): " + (this.endTime - this.startTime));
            this.logWriter.flush();
        }
    }

    public void finishLog() {
        if (this.isLogUser()) {
            this.logWriter.close();
        }
    }

    public void previewMode() {
        File imgDir;
        if (this.workDir != null && (imgDir = new File(this.workDir)).isDirectory()) {
            this.files = imgDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith("png");
                }
            });
            this.setPreviewMode(true);
        }
    }

    public GTGui(CanvasState state) {
        super(APP_NAME);
        this.setLayout(new BorderLayout());
        this.menuWrapper = new GTMenuWrapper(this);
        this.addComponentListener(this);
        this.addKeyListener(this);
        this.scrollPane = new ScrollPane(0);
        this.state = state;
        this.canvas = new GTCanvas(this.scrollPane, state);
        this.canvas.setMainGui(this);
        this.processor = new GTOperationProcessor(this, state);
        this.statusBar = new Label("Loaded ");
        this.infoBar = new Label("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                GTGui.this.processor.exit();
            }
        });
        this.setMenuBar(this.menuWrapper.getMenuBar());
        this.add((Component)this.statusBar, "South");
        this.add((Component)this.infoBar, "North");
        this.logUser = Boolean.parseBoolean(System.getProperty(LOG_USER, "false"));
        if (this.isLogUser()) {
            String logfile = System.getProperty(LOG_FILE, null);
            if (logfile == null) {
                this.setLogUser(false);
            } else {
                try {
                    this.logWriter = new PrintWriter(new FileWriter(new File(logfile)));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter logWriter) {
        this.logWriter = logWriter;
    }

    public boolean isLogUser() {
        return this.logUser;
    }

    public void setLogUser(boolean logUser) {
        this.logUser = logUser;
    }

    public void markRowColSpan() {
        this.state.markRowColSpan();
        this.canvas.repaint();
        this.updateStatusBar();
    }

    private int showGroundTruthConfirmationDialog() {
        return JOptionPane.showConfirmDialog(this, "Ground Truth has been modified, do you want to save it?", "Ground Truth Save Confirmation Dialog", 0, 2);
    }

    public void showWarningBox(String message) {
        JOptionPane.showMessageDialog(this, message);
    }

    public void updateInfoBar(int x, int y, String info) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        sb.append(x);
        sb.append(",");
        sb.append(y);
        sb.append(")");
        sb.append(info);
        this.infoBar.setText(sb.toString());
    }

    public void maximize() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit == null) {
            return;
        }
        Dimension screenSize = toolkit.getScreenSize();
        if (screenSize == null) {
            return;
        }
        int w = screenSize.width;
        int h = screenSize.height;
        int x = 20;
        int y = 80;
        this.setLocation(x / 2, y / 2);
        this.setSize((w - x) / 2, h - y);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        int index = this.menuWrapper.findIndex(o);
        if (index != -1) {
            this.processor.process(index);
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    public void updateCanvas() {
        if (this.canvas != null) {
            this.canvas.setInterpolation(this.state.getInterpolation());
            this.canvas.repaint();
        }
    }

    public void updateImage() {
        PixelImage image = this.state.getImage();
        if (this.scrollPane != null) {
            this.remove(this.scrollPane);
        }
        if (image != null) {
            Image awtImage = ImageCreator.convertToAwtImage((PixelImage)image, (int)-16777216);
            this.scrollPane = new ScrollPane(0);
            this.canvas = new GTCanvas(this.scrollPane, this.state);
            this.canvas.setMainGui(this);
            this.canvas.setInterpolation(this.state.getInterpolation());
            this.canvas.setZoomToFit(this.state.getZoomToFit());
            this.canvas.setImage(awtImage);
            this.canvas.setZoomFactors(this.state.getZoomFactorX(), this.state.getZoomFactorY());
            this.canvas.computeZoomToFitSize();
            this.scrollPane.add(this.canvas);
            this.add(this.scrollPane);
        }
        this.updateStatusBar();
        this.updateTitle();
        this.validate();
        this.infoBar.setText("");
        this.menuWrapper.updateEnabled(this.processor);
    }

    public void close() {
        if (this.state.isModified()) {
            int answer = this.showGroundTruthConfirmationDialog();
            switch (answer) {
                case 0: {
                    this.processor.saveGroundTruthFile();
                    break;
                }
            }
        }
        this.state.clear();
        this.canvas.clear();
        this.updateImage();
    }

    public void updateStatusBar() {
        PixelImage image = this.state.getImage();
        String statusBarText = image == null ? "" : ImageInfo.getImageInfo(image);
        switch (this.state.getMarkType()) {
            case 0: {
                statusBarText = String.valueOf(statusBarText) + ", Marking Tables ";
                break;
            }
            case 2: {
                statusBarText = String.valueOf(statusBarText) + ", Marking Rows/Columns ";
                break;
            }
            case 1: {
                statusBarText = String.valueOf(statusBarText) + ", Marking Rows/Columns Span ";
            }
        }
        if (this.isPreviewMode()) {
            statusBarText = String.valueOf(statusBarText) + ", PREVIEW MODE (Use 'n' for next, 'p' for previous image)";
        } else if (this.state.isAutoLoadGT()) {
            statusBarText = String.valueOf(statusBarText) + ", Loading ground truth automatically";
        }
        this.setStatusBar(statusBarText);
    }

    public void setStatusBar(String text) {
        this.statusBar.setText(text);
    }

    public void updateTitle() {
        StringBuffer sb = new StringBuffer(APP_NAME);
        String fileName = this.state.getFileName();
        if (fileName != null && fileName.length() > 0) {
            sb.append(" [");
            sb.append(fileName);
            if (this.state.getModified()) {
                sb.append('*');
            }
            sb.append(']');
        }
        if (this.state.getImage() != null) {
            double zoom = this.state.getZoomFactorX();
            int percent = (int)(zoom * 100.0);
            sb.append(' ');
            sb.append(Integer.toString(percent));
            sb.append('%');
        }
        if (this.state.getGroundTruthFile() != null) {
            sb.append(" [");
            sb.append(this.state.getGroundTruthFile());
            sb.append("]");
        }
        if (this.isPreviewMode() && this.files != null) {
            sb.append(" [");
            sb.append("Showing " + (this.currentFileIndex + 1) + " of " + this.files.length + " images");
            sb.append(" ]");
        }
        this.setTitle(sb.toString());
    }

    public void zoomIn() {
        if (this.canvas != null && !this.state.isMaximumZoom()) {
            this.state.zoomIn();
            this.canvas.setZoomFactors(this.state.getZoomFactorX(), this.state.getZoomFactorY());
            this.updateTitle();
            this.menuWrapper.updateEnabled(this.processor);
        }
    }

    public void zoomOut() {
        if (this.canvas != null && !this.state.isMinimumZoom()) {
            this.state.zoomOut();
            this.canvas.setZoomFactors(this.state.getZoomFactorX(), this.state.getZoomFactorY());
            this.updateTitle();
            this.menuWrapper.updateEnabled(this.processor);
        }
    }

    public void zoomOriginal() {
        if (this.canvas != null) {
            this.state.zoomSetOriginalSize();
            this.canvas.setZoomFactors(this.state.getZoomFactorX(), this.state.getZoomFactorY());
            this.updateTitle();
            this.menuWrapper.updateEnabled(this.processor);
        }
    }

    public void markTable() {
        this.state.markTable();
        this.setCrosshairCursor();
        this.updateStatusBar();
        this.canvas.repaint();
    }

    public void nextImagePreview() {
        if (this.files != null) {
            if (this.currentFileIndex < this.files.length - 1) {
                ++this.currentFileIndex;
                String imgFile = this.files[this.currentFileIndex];
                this.processor.fileOpen(new File(this.state.getCurrentDirectory(), imgFile).getAbsolutePath());
            } else {
                this.showWarningBox("Last Image");
            }
        }
    }

    private void previousImagePreview() {
        if (this.files != null) {
            if (this.currentFileIndex >= 1) {
                --this.currentFileIndex;
                String imgFile = this.files[this.currentFileIndex];
                this.processor.fileOpen(new File(this.state.getCurrentDirectory(), imgFile).getAbsolutePath());
            } else {
                this.showWarningBox("First Image");
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.previewMode) {
            switch (e.getKeyChar()) {
                case 'N': 
                case 'n': {
                    this.nextImagePreview();
                    break;
                }
                case 'P': 
                case 'p': {
                    this.previousImagePreview();
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public boolean isPreviewMode() {
        return this.previewMode;
    }

    public void setPreviewMode(boolean previewMode) {
        this.previewMode = previewMode;
    }

    public String getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(String workDir) {
        this.workDir = workDir;
    }

    public void markRowColumns() {
        this.state.markRowColumns();
        this.setCrosshairCursor();
        this.updateStatusBar();
    }

    private void setDefaultCursor() {
        Cursor cursor = new Cursor(0);
        this.setCursor(cursor);
    }

    private void setCrosshairCursor() {
        Cursor cursor = new Cursor(1);
        this.setCursor(cursor);
    }

    public static void main(String[] args) {
        CanvasState state = new CanvasState();
        GTGui gui = new GTGui(state);
        if (args.length == 1) {
            if (args[0].equalsIgnoreCase("auto")) {
                state.setAutoLoadGT(true);
            }
        } else if (args.length == 2 && args[0].equalsIgnoreCase("preview")) {
            gui.setWorkDir(args[1]);
            state.setCurrentDirectory(args[1]);
            state.setAutoLoadGT(true);
            gui.previewMode();
            gui.nextImagePreview();
        }
        gui.maximize();
        gui.repaint();
        gui.setVisible(true);
    }

    public GTCanvas getCanvas() {
        return this.canvas;
    }

    public void setCanvas(GTCanvas canvas) {
        this.canvas = canvas;
    }
}

