/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.trecs.groundtruth.gui;

import de.dfki.trecs.groundtruth.data.GTCell;
import de.dfki.trecs.groundtruth.data.GTCol;
import de.dfki.trecs.groundtruth.data.GTRow;
import de.dfki.trecs.groundtruth.data.GTTable;
import de.dfki.trecs.groundtruth.gui.CanvasState;
import de.dfki.trecs.groundtruth.gui.GTGui;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.ScrollPane;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import net.sourceforge.jiu.data.MemoryShortChannelImage;
import net.sourceforge.jiu.data.RGB48Image;

public class GTCanvas
extends Canvas
implements MouseMotionListener,
MouseListener,
KeyListener {
    private Image image;
    private int width;
    private int height;
    private int scaledWidth;
    private int scaledHeight;
    private GTGui mainGui;
    private double zoomFactorX = 1.0;
    private double zoomFactorY = 1.0;
    private boolean zoomToFit;
    private ScrollPane myScrollPane;
    private Object interpolation;
    private CanvasState state;
    private int previousX;
    private int previousY;
    private int x0 = -1;
    private int y0 = -1;
    private int x2 = -1;
    private int y2 = -1;
    private int imageX = 0;
    private int imageY = 0;

    public int getImageX() {
        return this.imageX;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.mainGui.keyPressed(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public int getImageY() {
        return this.imageY;
    }

    public void clear() {
        this.image = null;
        this.clearInteractiveDrawingLoc();
        this.repaint();
    }

    public void setImageX(int imageX) {
        this.imageX = imageX;
    }

    public void setImageY(int imageY) {
        this.imageY = imageY;
    }

    public GTCanvas(ScrollPane scrollPane, CanvasState state) {
        this.myScrollPane = scrollPane;
        this.interpolation = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
        this.state = state;
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void drawLine(int x0, int y0, int x1, int y1) {
        this.getGraphics().setColor(Color.black);
        this.getGraphics().drawLine(x0, y0, x1, y1);
    }

    public void computeZoomToFitSize() {
        if (!this.zoomToFit || this.myScrollPane == null) {
            return;
        }
        Dimension scrollPaneSize = this.myScrollPane.getSize();
        int maxWidth = scrollPaneSize.width;
        int maxHeight = scrollPaneSize.height;
        double paneRatio = (double)maxWidth / (double)maxHeight;
        double imageRatio = (double)this.width / (double)this.height;
        if (paneRatio < imageRatio) {
            this.scaledWidth = maxWidth;
            this.scaledHeight = (int)((double)this.scaledWidth * imageRatio);
        } else {
            this.scaledHeight = maxHeight;
            this.scaledWidth = (int)((double)this.scaledHeight * imageRatio);
        }
        --this.scaledHeight;
        --this.scaledWidth;
        this.zoomFactorY = this.zoomFactorX = (double)this.scaledWidth / (double)this.width;
    }

    public int getZoomPercentageX() {
        return (int)(this.zoomFactorX * 100.0);
    }

    public int getZoomPercentageY() {
        return (int)(this.zoomFactorY * 100.0);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.scaledWidth, this.scaledHeight);
    }

    @Override
    public void paint(Graphics g) {
        if (this.image == null) {
            super.paint(g);
        } else {
            Rectangle rect = this.getBounds();
            int canvasWidth = rect.width;
            int canvasHeight = rect.height;
            int x1 = 0;
            int y1 = 0;
            if (canvasWidth > this.scaledWidth) {
                x1 = (canvasWidth - this.scaledWidth) / 2;
            }
            if (canvasHeight > this.scaledHeight) {
                y1 = (canvasHeight - this.scaledHeight) / 2;
            }
            if (canvasHeight > canvasWidth || canvasHeight > this.scaledHeight) {
                super.paint(g);
            }
            if (g instanceof Graphics2D) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.interpolation);
            }
            this.imageX = x1;
            this.imageY = y1;
            g.drawImage(this.image, x1, y1, this.scaledWidth, this.scaledHeight, this);
            g.setColor(Color.blue);
            g.drawRect(x1, y1, this.scaledWidth, this.scaledHeight);
            this.drawGTStateElements(g);
            if (this.state.isDrawing()) {
                switch (this.state.getMarkType()) {
                    case 0: {
                        g.setColor(this.state.getCurrentElement().getForegroundColor());
                        this.paintRectangleBoundary(this.x0, this.y0, this.x2, this.y2, g);
                        break;
                    }
                    case 1: {
                        GTTable table = this.state.getCurrentTable();
                        if (table == null) break;
                        Point p1 = this.translateToScreenPoint(new Point(table.getX0(), table.getY0()));
                        Point p2 = this.translateToScreenPoint(new Point(table.getX1(), table.getY1()));
                        if (p1 == null || p2 == null) break;
                        if (this.x2 > p2.x) {
                            this.x2 = p2.x;
                        }
                        if (this.y2 > p2.y) {
                            this.y2 = p2.y;
                        }
                        g.setColor(Color.BLACK);
                        g.drawLine(this.x0, this.y0, this.x2, this.y2);
                    }
                }
            }
        }
    }

    public void drawGTStateElements(Graphics g) {
        Color color;
        ArrayList<GTTable> tableList = this.state.getList();
        for (GTTable table : tableList) {
            GTCell[][] cells;
            this.drawTable(table, g);
            if (table.getGtCells() == null) {
                ArrayList<GTRow> rows = table.getGtRows();
                for (GTRow row : rows) {
                    g.setColor(row.getForegroundColor());
                    Point p = this.translateToScreenPoint(new Point(row.getX0(), row.getY0()));
                    Point p2 = this.translateToScreenPoint(new Point(row.getX1(), row.getY1()));
                    g.drawLine(p.x, p.y, p2.x, p2.y);
                }
                ArrayList<GTCol> cols = table.getGtCols();
                for (GTCol col : cols) {
                    g.setColor(col.getForegroundColor());
                    Point p = this.translateToScreenPoint(new Point(col.getX0(), col.getY0()));
                    Point p2 = this.translateToScreenPoint(new Point(col.getX1(), col.getY1()));
                    g.drawLine(p.x, p.y, p2.x, p2.y);
                }
            }
            if ((cells = table.getGtCells()) == null) continue;
            color = new Color(255, 0, 0, 60);
            Color multiColor = new Color(0, 128, 128, 60);
            Color rowSpanColor = new Color(0, 255, 0, 100);
            Color colSpanColor = new Color(0, 0, 255, 100);
            for (GTCell cell : table.getCells()) {
                if (cell.isDontCare()) continue;
                Point p = this.translateToScreenPoint(new Point(cell.getX0(), cell.getY0()));
                Point p2 = this.translateToScreenPoint(new Point(cell.getX1(), cell.getY1()));
                g.setColor(Color.BLACK);
                g.drawRect(p.x, p.y, p2.x - p.x, p2.y - p.y);
                if (cell.getEndCol() > cell.getStartCol() && cell.getEndRow() > cell.getStartRow()) {
                    g.setColor(multiColor);
                } else if (cell.getEndRow() > cell.getStartRow()) {
                    g.setColor(rowSpanColor);
                } else if (cell.getEndCol() > cell.getStartCol()) {
                    g.setColor(colSpanColor);
                } else {
                    g.setColor(color);
                }
                g.fillRect(p.x, p.y, p2.x - p.x, p2.y - p.y);
            }
        }
        if (this.state.getCurrentTable() != null) {
            GTTable table;
            table = this.state.getCurrentTable();
            Point p = this.translateToScreenPoint(new Point(table.getX0(), table.getY0()));
            Point p2 = this.translateToScreenPoint(new Point(table.getX1(), table.getY1()));
            color = table.getForegroundColor();
            Color tmpColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), 70);
            g.setColor(tmpColor);
            g.fillRect(p.x, p.y, p2.x - p.x, p2.y - p.y);
        }
    }

    private void drawTable(GTTable table, Graphics g) {
        g.setColor(table.getForegroundColor());
        Point p1 = this.translateToScreenPoint(new Point(table.getX0(), table.getY0()));
        Point p2 = this.translateToScreenPoint(new Point(table.getX1(), table.getY1()));
        this.paintRectangleBoundary(p1.x, p1.y, p2.x, p2.y, g);
    }

    private void drawRow(GTRow row, Graphics g) {
    }

    private void drawCol(GTCol col, Graphics g) {
    }

    public void setImage(Image newImage) {
        this.image = newImage;
        this.width = this.image.getWidth(this);
        this.height = this.image.getHeight(this);
        this.scaledWidth = (int)((double)this.width * this.zoomFactorX);
        this.scaledHeight = (int)((double)this.height * this.zoomFactorY);
        this.setSize(this.scaledWidth, this.scaledHeight);
        this.validate();
    }

    public void setOriginalSize() {
        this.setZoomFactor(1.0);
    }

    public double getZoomFactorX() {
        return this.zoomFactorX;
    }

    public double getZoomFactorY() {
        return this.zoomFactorY;
    }

    public void setInterpolation(int newType) {
        switch (newType) {
            case 2: {
                this.interpolation = RenderingHints.VALUE_INTERPOLATION_BICUBIC;
                break;
            }
            case 1: {
                this.interpolation = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
                break;
            }
            case 0: {
                this.interpolation = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
            }
        }
    }

    public void setZoomFactor(double newZoomFactor) {
        this.setZoomFactors(newZoomFactor, newZoomFactor);
    }

    public void setZoomFactors(double newZoomFactorX, double newZoomFactorY) {
        if (newZoomFactorX <= 0.0 || newZoomFactorY <= 0.0) {
            throw new IllegalArgumentException("Zoom factors must be larger than 0.0.");
        }
        this.zoomFactorX = newZoomFactorX;
        this.zoomFactorY = newZoomFactorY;
        this.scaledWidth = (int)((double)this.width * this.zoomFactorX);
        this.scaledHeight = (int)((double)this.height * this.zoomFactorY);
        this.setSize(this.scaledWidth, this.scaledHeight);
        this.myScrollPane.validate();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    public static void reportMousePosition(MouseEvent e) {
        System.out.println("Mouse at: (" + e.getX() + "," + e.getY() + ")");
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Graphics g = this.getGraphics();
        switch (this.state.getMarkType()) {
            case 0: {
                this.x2 = e.getX();
                this.y2 = e.getY();
                this.drawInteractiveRectangle();
                break;
            }
            case 2: {
                this.x2 = e.getX();
                this.y2 = this.y0;
                break;
            }
            case 1: {
                if (this.x2 == this.x0) {
                    this.y2 = e.getY();
                } else if (this.y2 == this.y0) {
                    this.x2 = e.getX();
                }
                this.drawInteractiveLine(false);
                break;
            }
            case -1: {
                return;
            }
        }
    }

    private void drawInteractiveLine(boolean row) {
        if (this.previousX != this.x2 || this.previousY != this.y2) {
            this.repaint(this.x0, this.y0, Math.abs(this.previousX - this.x0) + 4, 1);
            this.repaint(this.x0, this.y0, 1, Math.abs(this.previousY - this.y0) + 4);
            this.previousX = this.x2;
            this.previousY = this.y2;
            this.repaint(this.x0, this.y0, Math.abs(this.x2 - this.x0), 1);
            this.repaint(this.x0, this.y0, 1, Math.abs(this.y2 - this.y0));
        }
    }

    private void drawInteractiveRectangle() {
        if (this.previousX != this.x2 || this.previousY != this.y2) {
            this.repaint(this.x0, this.y0, 1, Math.abs(this.previousY - this.y0));
            this.repaint(this.x0, this.y0, Math.abs(this.previousX - this.x0), 1);
            this.repaint(this.previousX, this.previousY, 1, Math.abs(this.previousY - this.y0));
            this.repaint(this.previousX, this.previousY, Math.abs(this.previousX - this.x0), 1);
            this.previousX = this.x2;
            this.previousY = this.y2;
            this.repaint(this.x0, this.y0, 1, Math.abs(this.previousY - this.y0));
            this.repaint(this.x0, this.y0, Math.abs(this.previousX - this.x0), 1);
            this.repaint(this.previousX, this.previousY, 1, Math.abs(this.previousY - this.y0));
            this.repaint(this.previousX, this.previousY, Math.abs(this.previousX - this.x0), 1);
        }
    }

    private void paintRectangleBoundary(int x0, int y0, int x2, int y2, Graphics g) {
        if (x0 > this.imageX && y0 > this.imageY && x2 > x0 && y2 > y0) {
            if (x2 > this.imageX + this.scaledWidth) {
                x2 = this.imageX + this.scaledWidth;
            }
            if (y2 > this.imageY + this.scaledHeight) {
                y2 = this.imageY + this.scaledHeight;
            }
            g.drawLine(x0, y0, x0, y2);
            g.drawLine(x0, y0, x2, y0);
            g.drawLine(x2, y2, x2, y0);
            g.drawLine(x2, y2, x0, y2);
        }
    }

    public Point translateToScreenPoint(Point p) {
        Point pScreen = new Point();
        pScreen.x = (int)((double)p.x * this.zoomFactorX + (double)this.imageX);
        pScreen.y = (int)((double)p.y * this.zoomFactorY + (double)this.imageY);
        return pScreen;
    }

    public Point translateToImagePoint(Point p) {
        Point pImage = new Point();
        pImage.x = (int)((double)(p.x - this.imageX) / this.zoomFactorX);
        pImage.y = (int)((double)(p.y - this.imageY) / this.zoomFactorY);
        return pImage;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int b;
        int a = e.getX();
        if (this.isImagePoint(a, b = e.getY())) {
            Point p = this.translateToImagePoint(new Point(a, b));
            String info = "";
            if (this.state.getImage() != null && this.state.getImage() instanceof RGB48Image) {
                MemoryShortChannelImage img = (MemoryShortChannelImage)this.state.getImage();
                short R = img.getShortSample(0, p.x, p.y);
                short G = img.getShortSample(1, p.x, p.y);
                short B = img.getShortSample(2, p.x, p.y);
                int MSBMASK = 65280;
                int LSBMASK = 255;
                info = "R(MSB,LSB)G(MSB,LSB)B(MSB,LSB): ((" + ((R & MSBMASK) >> 8) + "," + (R & LSBMASK) + "),((" + ((G & MSBMASK) >> 8) + "," + (G & LSBMASK) + "),((" + ((B & MSBMASK) >> 8) + "," + (B & LSBMASK) + "))";
            }
            this.mainGui.updateInfoBar(p.x, p.y, info);
        }
        this.state.getMarkType();
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1 || e.getButton() == 3) {
            switch (this.state.getMarkType()) {
                case 0: {
                    if (!this.isImagePoint(e.getX(), e.getY())) break;
                    this.x0 = e.getX();
                    this.y0 = e.getY();
                    this.state.setDrawing(true);
                    break;
                }
                case 2: {
                    if (this.state.getCurrentTable() == null) {
                        Point p = this.translateToImagePoint(new Point(e.getX(), e.getY()));
                        GTTable table = this.state.getTable(p.x, p.y);
                        if (table == null) break;
                        this.state.setCurrentTable(table);
                        this.repaint();
                        break;
                    }
                    Point p = this.translateToImagePoint(new Point(e.getX(), e.getY()));
                    GTTable table = this.state.getTable(p.x, p.y);
                    if (table == this.state.getCurrentTable()) {
                        if (e.getButton() == 1) {
                            GTRow row = new GTRow(table.getX0(), p.y, table.getX1());
                            this.state.addGTRow(row);
                        } else if (e.getButton() == 3) {
                            GTCol col = new GTCol(p.x, table.getY0(), table.getY1());
                            this.state.addGTCol(col);
                        }
                        this.repaint();
                        break;
                    }
                    if (table == null) break;
                    this.state.setCurrentTable(table);
                    this.repaint();
                    break;
                }
                case 1: {
                    if (this.state.getCurrentTable() == null) {
                        Point p = this.translateToImagePoint(new Point(e.getX(), e.getY()));
                        GTTable table = this.state.getTable(p.x, p.y);
                        if (table == null) break;
                        this.state.setCurrentTable(table);
                        this.repaint();
                        break;
                    }
                    GTTable table = this.state.getCurrentTable();
                    Point p1 = this.translateToScreenPoint(new Point(table.getX0(), table.getY0()));
                    Point p2 = this.translateToScreenPoint(new Point(table.getX1(), table.getY1()));
                    if (e.getX() < p1.x || e.getX() >= p2.x || e.getY() < p1.y || e.getY() >= p2.y) break;
                    this.x0 = e.getX();
                    this.y0 = e.getY();
                    this.x2 = 0;
                    this.y2 = 0;
                    this.state.setDrawing(true);
                    if (e.getButton() == 1) {
                        this.x2 = this.x0;
                        break;
                    }
                    if (e.getButton() != 3) break;
                    this.y2 = this.y0;
                }
            }
        }
    }

    private boolean isImagePoint(int a, int b) {
        return a >= this.imageX && a <= this.imageX + this.scaledWidth && b >= this.imageY && b <= this.imageY + this.scaledHeight;
    }

    private void clearInteractiveDrawingLoc() {
        this.x0 = -1;
        this.y0 = -1;
        this.x2 = -1;
        this.y2 = -1;
        this.previousX = -1;
        this.previousY = -1;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if ((e.getButton() == 1 || e.getButton() == 3) && this.state.isDrawing()) {
            switch (this.state.getMarkType()) {
                case 0: {
                    this.state.setDrawing(false);
                    if (this.x2 <= this.x0 || this.y2 <= this.y0) break;
                    this.x2 = e.getX();
                    this.y2 = e.getY();
                    if (this.x2 > this.imageX + this.scaledWidth) {
                        this.x2 = this.imageX + this.scaledWidth;
                    }
                    if (this.y2 > this.imageY + this.scaledHeight) {
                        this.y2 = this.imageY + this.scaledHeight;
                    }
                    Point p1 = this.translateToImagePoint(new Point(this.x0, this.y0));
                    Point p2 = this.translateToImagePoint(new Point(this.x2, this.y2));
                    this.clearInteractiveDrawingLoc();
                    GTTable table = new GTTable(p1.x, p1.y, p2.x, p2.y);
                    this.state.addGTTable(table);
                    break;
                }
                case 1: {
                    if (this.state.getCurrentTable() == null) {
                        return;
                    }
                    Point p1 = this.translateToImagePoint(new Point(this.x0, this.y0));
                    Point p2 = this.translateToImagePoint(new Point(this.x2, this.y2));
                    if (p1 == null || p2 == null) {
                        return;
                    }
                    if (this.x0 == this.x2) {
                        this.state.getCurrentTable().addColSpan(p1, p2);
                    } else if (this.y0 == this.y2) {
                        this.state.getCurrentTable().addRowSpan(p1, p2);
                    }
                    Point p = this.translateToScreenPoint(new Point(this.state.getCurrentTable().getX0(), this.state.getCurrentTable().getY0()));
                    this.repaint(p.x, p.y, this.state.getCurrentTable().getWidth(), this.state.getCurrentTable().getHeight());
                }
            }
        }
        this.previousX = 0;
        this.previousY = 0;
    }

    public void setZoomToFit(boolean newValue) {
        this.zoomToFit = newValue;
        this.validate();
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    public int getScaledWidth() {
        return this.scaledWidth;
    }

    public void setScaledWidth(int scaledWidth) {
        this.scaledWidth = scaledWidth;
    }

    public int getScaledHeight() {
        return this.scaledHeight;
    }

    public void setScaledHeight(int scaledHeight) {
        this.scaledHeight = scaledHeight;
    }

    public boolean isZoomToFit() {
        return this.zoomToFit;
    }

    public void setZoomFactorX(double zoomFactorX) {
        this.zoomFactorX = zoomFactorX;
    }

    public void setZoomFactorY(double zoomFactorY) {
        this.zoomFactorY = zoomFactorY;
    }

    public GTGui getMainGui() {
        return this.mainGui;
    }

    public void setMainGui(GTGui mainGui) {
        this.mainGui = mainGui;
    }
}

