/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.trecs.groundtruth.gui;

import de.dfki.tablerecognizer.block.BoundingBox;
import de.dfki.tablerecognizer.util.XMLManager;
import de.dfki.trecs.groundtruth.color.ColorModel16Bit;
import de.dfki.trecs.groundtruth.data.GTCell;
import de.dfki.trecs.groundtruth.data.GTCol;
import de.dfki.trecs.groundtruth.data.GTElement;
import de.dfki.trecs.groundtruth.data.GTRow;
import de.dfki.trecs.groundtruth.data.GTTable;
import de.dfki.trecs.groundtruth.gui.MenuIndexConstants;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Stack;
import net.sourceforge.jiu.codecs.PNGCodec;
import net.sourceforge.jiu.color.promotion.PromotionRGB48;
import net.sourceforge.jiu.data.MemoryRGB48Image;
import net.sourceforge.jiu.data.PixelImage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CanvasState
implements MenuIndexConstants {
    public static final int MARK_TABLE = 0;
    public static final int MARK_ROW_COL_SPAN = 1;
    public static final int MARK_ROW_COL = 2;
    public static final int MARK_NONE = -1;
    public static final int DEFAULT_MAX_UNDO_IMAGES = 2;
    public static final int DEFAULT_MAX_REDO_IMAGES = 2;
    public static final int[] ZOOM_LEVELS = new int[]{5, 7, 10, 15, 20, 30, 50, 70, 100, 150, 200, 300, 500, 700, 1000, 2000, 3000, 5000};
    public static final int ORIGINAL_SIZE_ZOOM_INDEX = 8;
    public static final int INTERPOLATION_NEAREST_NEIGHBOR = 0;
    public static final int INTERPOLATION_BILINEAR = 1;
    public static final int INTERPOLATION_BICUBIC = 2;
    public static final int DEFAULT_INTERPOLATION = 0;
    private String currentDirectory;
    private String fileName;
    private PixelImage currentImage;
    private MemoryRGB48Image rgb48Image = null;
    private int interpolation = 0;
    private Locale locale;
    private int maxRedoImages = 2;
    private int maxUndoImages = 2;
    private boolean modified;
    private boolean drawing;
    private GTTable currentTable = null;
    private boolean initialCellsMarked = false;
    private int markType = -1;
    private Stack<GTElement> undoStack = new Stack();
    private Stack<GTElement> redoStack = new Stack();
    private ArrayList<GTTable> list = new ArrayList();
    private GTElement currentElement = null;
    private int zoomIndex = 8;
    private double zoomFactorX = 1.0;
    private double zoomFactorY = 1.0;
    private boolean zoomToFit = false;
    private boolean autoLoadGT = false;
    private String groundTruthFile;

    public void setZoomToFit(boolean zoomToFit) {
        this.zoomToFit = zoomToFit;
    }

    public CanvasState() {
        this.locale = Locale.getDefault();
    }

    public void clear() {
        if (this.currentImage != null) {
            this.currentImage = null;
        }
        this.clearList();
        this.clearData();
    }

    private void clearList() {
        this.undoStack.clear();
        this.redoStack.clear();
        this.list.clear();
        this.currentTable = null;
        this.currentElement = null;
        this.setGroundTruthFile(null);
        this.modified = false;
    }

    private void clearData() {
        this.zoomToFit = false;
        this.setZoomFactors(1.0, 1.0);
        this.interpolation = 0;
        this.fileName = null;
        this.drawing = false;
        this.rgb48Image = null;
        this.markType = -1;
        this.initialCellsMarked = false;
    }

    private void addGroundTruthCoordinates(XMLManager xmlManager, Node node, BoundingBox box) {
        xmlManager.addAttribue((Element)node, "x0", "" + box.getX0());
        xmlManager.addAttribue((Element)node, "y0", "" + box.getY0());
        xmlManager.addAttribue((Element)node, "x1", "" + box.getX1());
        xmlManager.addAttribue((Element)node, "y1", "" + box.getY1());
    }

    public void updateModifiedFlag() {
        if (this.undoStack.size() > 0) {
            this.modified = true;
        } else if (this.undoStack.size() == 0) {
            this.modified = false;
        }
    }

    public void addGTCol(GTCol col) {
        this.currentTable.addCols(col);
        col.setTable(this.currentTable);
        this.addUndoElement(col);
    }

    public void addGTRow(GTRow row) {
        this.currentTable.addRow(row);
        row.setTable(this.currentTable);
        this.addUndoElement(row);
    }

    public void addGTTable(GTTable table) {
        this.list.add(table);
        this.addUndoElement(table);
    }

    public void addRedoElement(GTElement e) {
        this.redoStack.add(e);
        this.updateModifiedFlag();
    }

    public void addUndoElement(GTElement e) {
        this.undoStack.push(e);
        this.updateModifiedFlag();
    }

    public String getCurrentDirectory() {
        return this.currentDirectory;
    }

    public GTElement getCurrentElement() {
        return this.currentElement;
    }

    public GTTable getCurrentTable() {
        return this.currentTable;
    }

    public String getFileName() {
        return this.fileName;
    }

    public PixelImage getImage() {
        return this.currentImage;
    }

    public int getInterpolation() {
        return this.interpolation;
    }

    public ArrayList<GTTable> getList() {
        return this.list;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public int getMarkType() {
        return this.markType;
    }

    public boolean getModified() {
        return this.modified;
    }

    public Stack<GTElement> getRedoStack() {
        return this.redoStack;
    }

    public GTTable getTable(int x0, int y0) {
        for (GTTable table : this.list) {
            if (x0 < table.getX0() || y0 < table.getY0() || x0 > table.getX1() || y0 > table.getY1()) continue;
            return table;
        }
        return null;
    }

    public Stack<GTElement> getUndoStack() {
        return this.undoStack;
    }

    public double getZoomFactorX() {
        return this.zoomFactorX;
    }

    public double getZoomFactorY() {
        return this.zoomFactorY;
    }

    public boolean getZoomToFit() {
        return this.zoomToFit;
    }

    public boolean hasImage() {
        return this.currentImage != null;
    }

    public boolean isDrawing() {
        return this.drawing;
    }

    public boolean isMaximumZoom() {
        return this.zoomIndex == ZOOM_LEVELS.length - 1;
    }

    public boolean isAutoLoadGT() {
        return this.autoLoadGT;
    }

    public void setAutoLoadGT(boolean autoLoadGT) {
        this.autoLoadGT = autoLoadGT;
    }

    public String getGroundTruthFile() {
        return this.groundTruthFile;
    }

    public void setGroundTruthFile(String groundTruthFile) {
        this.groundTruthFile = groundTruthFile;
    }

    public boolean isMinimumZoom() {
        return this.zoomIndex == 0;
    }

    public boolean isZoomOriginalSize() {
        return this.zoomIndex == 8;
    }

    public void promoteImage() {
        if (this.currentImage != null && this.rgb48Image == null) {
            PromotionRGB48 imgOperation = new PromotionRGB48();
            imgOperation.setInputImage(this.currentImage);
            try {
                imgOperation.process();
            }
            catch (Exception ex) {
                System.out.println("Error transforming image to 48bit");
            }
            this.rgb48Image = (MemoryRGB48Image)imgOperation.getOutputImage();
        }
    }

    public void evaluateTableCells() {
        int index = 0;
        for (GTTable table : this.list) {
            table.setIndex(index);
            table.evaluateInitialCells();
            this.setInitialCellsMarked(true);
            ++index;
        }
        this.undoStack.clear();
        this.redoStack.clear();
    }

    private void colorImageForeground(MemoryRGB48Image image, GTTable table) {
        GTCell[][] cells = table.getGtCells();
        int i = 0;
        while (i < cells.length) {
            int j = 0;
            while (j < cells[i].length) {
                GTCell cell = cells[i][j];
                int[] R = new int[cell.getWidth() * cell.getHeight()];
                int[] G = new int[cell.getWidth() * cell.getHeight()];
                int[] B = new int[cell.getWidth() * cell.getHeight()];
                image.getSamples(0, cell.getX0(), cell.getY0(), cell.getWidth(), cell.getHeight(), R, 0);
                image.getSamples(1, cell.getX0(), cell.getY0(), cell.getWidth(), cell.getHeight(), G, 0);
                image.getSamples(2, cell.getX0(), cell.getY0(), cell.getWidth(), cell.getHeight(), B, 0);
                int r = 0;
                while (r < R.length) {
                    if (R[r] != 65535) {
                        R[r] = cell.getColor().getR();
                    }
                    if (G[r] != 65535) {
                        G[r] = cell.getColor().getG();
                    }
                    if (B[r] != 65535) {
                        B[r] = cell.getColor().getB();
                    }
                    ++r;
                }
                image.putSamples(0, cell.getX0(), cell.getY0(), cell.getWidth(), cell.getHeight(), R, 0);
                image.putSamples(1, cell.getX0(), cell.getY0(), cell.getWidth(), cell.getHeight(), G, 0);
                image.putSamples(2, cell.getX0(), cell.getY0(), cell.getWidth(), cell.getHeight(), B, 0);
                ++j;
            }
            ++i;
        }
    }

    public void loadGroundTruthFile(File f) {
        this.clearList();
        XMLManager xmlManager = new XMLManager(f.getAbsolutePath(), true);
        NodeList tablesList = xmlManager.getElementsByTagName(xmlManager.getDocument(), "Table");
        int i = 0;
        while (i < tablesList.getLength()) {
            Node tableNode = tablesList.item(i);
            GTTable table = new GTTable();
            this.loadGTElementFromNode(table, tableNode);
            NodeList children = tableNode.getChildNodes();
            int j = 0;
            while (j < children.getLength()) {
                Node childNode = children.item(j);
                if (childNode.getNodeName().equals("Row")) {
                    GTRow row = new GTRow();
                    this.loadGTElementFromNode(row, childNode);
                    table.addRow(row);
                } else if (childNode.getNodeName().equals("Column")) {
                    GTCol col = new GTCol();
                    this.loadGTElementFromNode(col, childNode);
                    table.addCols(col);
                } else if (childNode.getNodeName().equals("Cell")) {
                    GTCell cell = new GTCell();
                    this.loadGTElementFromNode(cell, childNode);
                    cell.setColor(ColorModel16Bit.parseColor(childNode.getTextContent().trim()));
                    NamedNodeMap nmmap = childNode.getAttributes();
                    cell.setStartRow(Integer.parseInt(nmmap.getNamedItem("startRow").getTextContent()));
                    cell.setEndRow(Integer.parseInt(nmmap.getNamedItem("endRow").getTextContent()));
                    cell.setStartCol(Integer.parseInt(nmmap.getNamedItem("startCol").getTextContent()));
                    cell.setEndCol(Integer.parseInt(nmmap.getNamedItem("endCol").getTextContent()));
                    cell.setDontCare(Boolean.parseBoolean(nmmap.getNamedItem("dontCare").getTextContent()));
                    table.getCells().add(cell);
                }
                ++j;
            }
            table.populateCellMatrix();
            this.list.add(table);
            ++i;
        }
    }

    private void loadGTElementFromNode(BoundingBox box, Node node) {
        NamedNodeMap nmmap = node.getAttributes();
        box.setX0(Integer.parseInt(nmmap.getNamedItem("x0").getTextContent().trim()));
        box.setY0(Integer.parseInt(nmmap.getNamedItem("y0").getTextContent().trim()));
        box.setX1(Integer.parseInt(nmmap.getNamedItem("x1").getTextContent().trim()));
        box.setY1(Integer.parseInt(nmmap.getNamedItem("y1").getTextContent().trim()));
    }

    public void markRowColSpan() {
        if (this.isInitialCellsMarked()) {
            this.markType = 1;
            this.currentTable = null;
        }
    }

    public void markRowColumns() {
        this.markType = 2;
        this.currentElement = new GTRow();
        this.currentTable = null;
    }

    public void markTable() {
        this.markType = 0;
        this.currentTable = null;
        this.currentElement = new GTTable();
    }

    public void redo() {
        if (!this.redoStack.isEmpty()) {
            GTElement e = this.redoStack.pop();
            if (e instanceof GTTable) {
                this.list.add((GTTable)e);
            } else if (e instanceof GTRow) {
                GTTable table = ((GTRow)e).getTable();
                table.addRow((GTRow)e);
            } else if (e instanceof GTCol) {
                GTTable table = ((GTCol)e).getTable();
                table.addCols((GTCol)e);
            }
            this.addUndoElement(e);
        }
    }

    public void resetZoomFactors() {
        this.setZoomFactors(1.0, 1.0);
    }

    public void saveGroundTruthFile(File f) {
        XMLManager xmlManager = new XMLManager("GroundTruth", false);
        xmlManager.getDocument().getDocumentElement().setAttribute("InputFile", this.fileName);
        Node tablesNode = xmlManager.createElement(xmlManager.getDocument(), "Tables");
        xmlManager.getDocument().getDocumentElement().appendChild(tablesNode);
        for (GTTable table : this.list) {
            Node tableNode = xmlManager.createElement(xmlManager.getDocument(), "Table");
            this.addGroundTruthCoordinates(xmlManager, tableNode, table);
            tablesNode.appendChild(tableNode);
            ArrayList<GTRow> rows = table.getGtRows();
            for (GTRow row : rows) {
                Node rowNode = xmlManager.createElement(xmlManager.getDocument(), "Row");
                this.addGroundTruthCoordinates(xmlManager, rowNode, row);
                tableNode.appendChild(rowNode);
            }
            ArrayList<GTCol> cols = table.getGtCols();
            for (GTCol col : cols) {
                Node colNode = xmlManager.createElement(xmlManager.getDocument(), "Column");
                this.addGroundTruthCoordinates(xmlManager, colNode, col);
                tableNode.appendChild(colNode);
            }
            GTCell[][] cells = table.getGtCells();
            if (cells == null) continue;
            int i = 0;
            while (i < cells.length) {
                int j = 0;
                while (j < cells[i].length) {
                    GTCell cell = cells[i][j];
                    Node cellNode = xmlManager.createElement(xmlManager.getDocument(), "Cell");
                    this.addGroundTruthCoordinates(xmlManager, cellNode, cell);
                    xmlManager.addAttribue((Element)cellNode, "startRow", "" + cell.getStartRow());
                    xmlManager.addAttribue((Element)cellNode, "endRow", "" + cell.getEndRow());
                    xmlManager.addAttribue((Element)cellNode, "startCol", "" + cell.getStartCol());
                    xmlManager.addAttribue((Element)cellNode, "endCol", "" + cell.getEndCol());
                    xmlManager.addAttribue((Element)cellNode, "dontCare", cell.isDontCare() ? "true" : "false");
                    cellNode.setTextContent(cell.getColor().toString());
                    tableNode.appendChild(cellNode);
                    ++j;
                }
                ++i;
            }
        }
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8")));
            XMLManager.serializeXmlDom((Document)xmlManager.getDocument(), (PrintWriter)out);
            out.close();
            this.undoStack.clear();
            this.redoStack.clear();
            this.updateModifiedFlag();
        }
        catch (Exception ex) {
            System.out.println("Error saving groundtruth");
        }
    }

    public void setCurrentDirectory(String newCurrentDirectory) {
        this.currentDirectory = newCurrentDirectory;
    }

    public void setCurrentElement(GTElement currentElement) {
        this.currentElement = currentElement;
    }

    public void setCurrentTable(GTTable currentTable) {
        this.currentTable = currentTable;
    }

    public void setDrawing(boolean drawing) {
        this.drawing = drawing;
    }

    public void setFileName(String newFileName) {
        this.fileName = newFileName;
    }

    public void setImage(PixelImage image, boolean flag) {
        this.currentImage = image;
        this.modified = flag;
    }

    public void setInterpolation(int newInterpolation) {
        if (newInterpolation == 0 || newInterpolation == 1 || newInterpolation == 2) {
            this.interpolation = newInterpolation;
        }
    }

    public void close() {
        this.isModified();
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setList(ArrayList<GTTable> list) {
        this.list = list;
    }

    public void setMarkType(int markType) {
        this.markType = markType;
    }

    public void setRedoStack(Stack<GTElement> redoStack) {
        this.redoStack = redoStack;
    }

    public void setUndoStack(Stack<GTElement> undoStack) {
        this.undoStack = undoStack;
    }

    public void setZoomFactors(double zoomX, double zoomY) {
        this.zoomFactorX = zoomX;
        this.zoomFactorY = zoomY;
    }

    public void undo() {
        if (!this.undoStack.isEmpty()) {
            GTElement e = this.undoStack.pop();
            if (e instanceof GTTable) {
                this.list.remove(e);
                if ((GTTable)e == this.currentTable) {
                    this.currentTable = null;
                }
            } else if (e instanceof GTRow) {
                GTTable table = ((GTRow)e).getTable();
                table.remove((GTRow)e);
            } else if (e instanceof GTCol) {
                GTTable table = ((GTCol)e).getTable();
                table.remove((GTCol)e);
            }
            this.addRedoElement(e);
        }
    }

    public void saveGTImage(File file) {
        PNGCodec codec = new PNGCodec();
        try {
            codec.setOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(file)));
            codec.setImage((PixelImage)this.rgb48Image);
            codec.process();
            codec.close();
        }
        catch (Exception e) {
            System.out.println("Error saving the ground truth image file");
            return;
        }
    }

    public void zoomIn() {
        if (this.zoomIndex + 1 == ZOOM_LEVELS.length) {
            return;
        }
        ++this.zoomIndex;
        this.zoomFactorY = this.zoomFactorX = 1.0 * (double)ZOOM_LEVELS[this.zoomIndex] / 100.0;
    }

    public void zoomOut() {
        if (this.zoomIndex == 0) {
            return;
        }
        --this.zoomIndex;
        this.zoomFactorY = this.zoomFactorX = 1.0 * (double)ZOOM_LEVELS[this.zoomIndex] / 100.0;
    }

    public void zoomSetOriginalSize() {
        this.zoomIndex = 8;
        this.zoomFactorX = 1.0;
        this.zoomFactorY = 1.0;
    }

    public MemoryRGB48Image getRgb48Image() {
        return this.rgb48Image;
    }

    public void setRgb48Image(MemoryRGB48Image rgb48Image) {
        this.rgb48Image = rgb48Image;
    }

    public boolean isInitialCellsMarked() {
        return this.initialCellsMarked;
    }

    public void setInitialCellsMarked(boolean initialCellsMarked) {
        this.initialCellsMarked = initialCellsMarked;
    }
}

