/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.trecs.groundtruth.data;

import de.dfki.tablerecognizer.block.BoundingBox;
import de.dfki.trecs.groundtruth.data.GTCell;
import de.dfki.trecs.groundtruth.data.GTCol;
import de.dfki.trecs.groundtruth.data.GTElement;
import de.dfki.trecs.groundtruth.data.GTRow;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class GTTable
extends BoundingBox
implements GTElement {
    private ArrayList<GTRow> gtRows = new ArrayList();
    private ArrayList<GTCol> gtCols = new ArrayList();
    private ArrayList<GTCell> cells = new ArrayList();
    private GTCell[][] gtCells = null;
    private int index;
    private Color foregroundColor = Color.RED;

    public ArrayList<GTCell> getCells() {
        return this.cells;
    }

    public GTTable() {
    }

    public GTTable(int x0, int y0, int x1, int y1) {
        super(x0, y0, x1, y1);
    }

    public void addRow(GTRow row) {
        this.gtRows.add(row);
    }

    public void addCols(GTCol col) {
        this.gtCols.add(col);
    }

    public void remove(GTRow row) {
        this.gtRows.remove(row);
    }

    public void remove(GTCol col) {
        this.gtCols.remove(col);
    }

    public void assignColors() {
        int num_colors = (this.gtRows.size() + 1) * (this.gtCols.size() + 1);
        if (this.gtCells == null) {
            return;
        }
        int j = 0;
        int k = 0;
        int i = 0;
        while (i < 360) {
            int hue = i;
            double saturation = 90.0 + Math.random() * 10.0;
            double lightness = 50.0 + Math.random() * 10.0;
            if (k > this.gtCols.size()) {
                ++j;
                k = 0;
            }
            this.gtCells[j][k++].setForegroundColor(new Color(Color.HSBtoRGB(hue, (float)saturation, (float)lightness)));
            i += 360 / num_colors;
        }
    }

    public GTCell getCellAtPoint(Point p) {
        if (this.gtCells == null) {
            return null;
        }
        int i = 0;
        while (i < this.gtCells.length) {
            int j = 0;
            while (j < this.gtCells[i].length) {
                GTCell cell = this.gtCells[i][j];
                if (p.x >= cell.getX0() && p.x <= cell.getX1() && p.y >= cell.getY0() && p.y <= cell.getY1()) {
                    return cell;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public void addRowSpan(Point p1, Point p2) {
        GTCell startCell = this.getCellAtPoint(p1);
        GTCell endCell = this.getCellAtPoint(p2);
        if (startCell == null || endCell == null || startCell.getStartRow() != endCell.getStartRow()) {
            System.out.println("Cant add Row Span: for " + p1 + " ,and " + p2);
            return;
        }
        startCell.setEndCol(endCell.getEndCol());
        int i = startCell.getStartCol() + 1;
        while (i <= endCell.getEndCol()) {
            GTCell temp = this.gtCells[startCell.getStartRow()][i];
            temp.setDontCare(true);
            startCell.setX1(temp.getX1());
            if (temp.getY1() > startCell.getY1()) {
                startCell.setX1(temp.getY1());
            }
            int j = startCell.getStartRow() + 1;
            while (j <= startCell.getEndRow()) {
                this.gtCells[j][i].setDontCare(true);
                ++j;
            }
            ++i;
        }
        startCell.assumeColor();
    }

    public void populateCellMatrix() {
        int numRows = this.gtRows.size() + 1;
        int numCols = this.gtCols.size() + 1;
        this.gtCells = new GTCell[numRows][numCols];
        Collections.sort(this.cells);
        if (this.cells.size() != numRows * numCols) {
            System.out.println("Arrays don't match for cells");
            return;
        }
        Iterator<GTCell> iterator = this.cells.iterator();
        int i = 0;
        while (i < numRows) {
            int j = 0;
            while (j < numCols) {
                this.gtCells[i][j] = iterator.next();
                ++j;
            }
            ++i;
        }
    }

    public void addColSpan(Point p1, Point p2) {
        GTCell startCell = this.getCellAtPoint(p1);
        GTCell endCell = this.getCellAtPoint(p2);
        if (startCell == null || endCell == null || startCell.getStartCol() != endCell.getStartCol()) {
            System.out.println("Cant add Col Span: for " + p1 + " ,and " + p2);
            return;
        }
        startCell.setEndRow(endCell.getEndRow());
        int i = startCell.getStartRow() + 1;
        while (i <= endCell.getEndRow()) {
            GTCell temp = this.gtCells[i][startCell.getStartCol()];
            temp.setDontCare(true);
            startCell.setY1(temp.getY1());
            if (temp.getX1() > startCell.getX1()) {
                startCell.setX1(temp.getX1());
            }
            int j = startCell.getStartCol() + 1;
            while (j <= startCell.getEndCol()) {
                this.gtCells[i][j].setDontCare(true);
                ++j;
            }
            ++i;
        }
        startCell.assumeColor();
    }

    public void reevaluateCells() {
        int i = 0;
        while (i < this.cells.size()) {
            ++i;
        }
    }

    public void evaluateInitialCells() {
        Collections.sort(this.gtRows);
        Collections.sort(this.gtCols);
        int numRows = this.gtRows.size() + 1;
        int numCols = this.gtCols.size() + 1;
        this.gtCells = new GTCell[numRows][numCols];
        this.cells.clear();
        boolean rows = false;
        boolean cols = false;
        int l = this.getX0();
        int t = this.getY0();
        int i = 0;
        while (i < numRows) {
            int b = i < this.gtRows.size() ? this.gtRows.get(i).getY0() : this.getY1();
            int j = 0;
            while (j < numCols) {
                GTCell cell;
                int r = j < this.gtCols.size() ? this.gtCols.get(j).getX0() : this.getX1();
                this.gtCells[i][j] = cell = new GTCell(l, t, r, b, i, j, this.index);
                this.cells.add(cell);
                l = r;
                ++j;
            }
            l = this.getX0();
            t = b;
            ++i;
        }
    }

    @Override
    public void initializePosition(int x, int y) {
        this.setX0(x);
        this.setY0(y);
    }

    @Override
    public void updatePosition(int x, int y) {
        this.setX1(x);
        this.setY1(y);
    }

    @Override
    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public ArrayList<GTRow> getGtRows() {
        return this.gtRows;
    }

    public void setGtRows(ArrayList<GTRow> gtRows) {
        this.gtRows = gtRows;
    }

    public ArrayList<GTCol> getGtCols() {
        return this.gtCols;
    }

    public void setGtCols(ArrayList<GTCol> gtCols) {
        this.gtCols = gtCols;
    }

    public GTCell[][] getGtCells() {
        return this.gtCells;
    }

    public void setGtCells(GTCell[][] gtCells) {
        this.gtCells = gtCells;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }
}

