/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.trecs.groundtruth.data;

import de.dfki.tablerecognizer.block.BoundingBox;
import de.dfki.trecs.groundtruth.color.ColorModel16Bit;
import de.dfki.trecs.groundtruth.data.GTElement;
import java.awt.Color;

public class GTCell
extends BoundingBox
implements GTElement,
Comparable {
    private ColorModel16Bit color = null;
    private Color foregroundColor;
    private int startRow = -1;
    private int endRow = -1;
    private int startCol = -1;
    private int endCol = -1;
    private int tableIndex = -1;
    private boolean dontCare = false;

    public int compareTo(Object o) {
        GTCell cell = (GTCell)o;
        if (this.getY0() == cell.getY0()) {
            if (this.getX0() < cell.getX0()) {
                return -1;
            }
            if (this.getX0() == cell.getX0()) {
                return 0;
            }
            return 1;
        }
        if (this.getY0() < cell.getY0()) {
            return -1;
        }
        if (this.getX0() < cell.getX0()) {
            return -1;
        }
        return 1;
    }

    public GTCell() {
    }

    @Override
    public Color getForegroundColor() {
        return Color.black;
    }

    public void setForegroundColor(Color color) {
        this.foregroundColor = color;
    }

    public GTCell(int x0, int y0, int x1, int y1, int startRow, int startCol, int tableIndex) {
        this(x0, y0, x1, y1);
        this.setStartRow(startRow);
        this.setStartCol(startCol);
        this.setEndRow(startRow);
        this.setEndCol(startCol);
        this.setTableIndex(tableIndex);
        this.assumeColor();
    }

    public void assumeColor() {
        ColorModel16Bit color = new ColorModel16Bit(this.tableIndex + 1, this.startRow + 1, this.endRow + 1, this.startCol + 1, this.endCol + 1);
        this.setColor(color);
    }

    public GTCell(int x0, int y0, int x1, int y1, ColorModel16Bit color) {
        this(x0, y0, x1, y1);
        this.setColor(color);
    }

    public GTCell(int x0, int y0, int x1, int y1) {
        super(x0, y0, x1, y1);
    }

    @Override
    public void initializePosition(int x, int y) {
        this.setX0(x);
        this.setY0(y);
    }

    @Override
    public void updatePosition(int x, int y) {
        this.setX1(x);
        this.setY1(y);
    }

    public ColorModel16Bit getColor() {
        return this.color;
    }

    public void setColor(ColorModel16Bit color) {
        this.color = color;
    }

    public int getStartRow() {
        return this.startRow;
    }

    public void setStartRow(int startRow) {
        this.startRow = startRow;
    }

    public int getEndRow() {
        return this.endRow;
    }

    public void setEndRow(int endRow) {
        this.endRow = endRow;
    }

    public int getStartCol() {
        return this.startCol;
    }

    public void setStartCol(int startCol) {
        this.startCol = startCol;
    }

    public int getEndCol() {
        return this.endCol;
    }

    public void setEndCol(int endCol) {
        this.endCol = endCol;
    }

    public void assumeDontCare() {
        if (this.startRow == -1 || this.startCol == -1) {
            this.setDontCare(true);
        } else {
            this.setDontCare(false);
        }
    }

    public boolean isDontCare() {
        return this.dontCare;
    }

    public void setDontCare(boolean dontCare) {
        this.dontCare = dontCare;
    }

    public int getTableIndex() {
        return this.tableIndex;
    }

    public void setTableIndex(int tableIndex) {
        this.tableIndex = tableIndex;
    }
}

