/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.trecs.groundtruth.color;

public class ColorModel16Bit
implements Comparable<ColorModel16Bit> {
    private int R;
    private int G;
    private int B;
    public static final int CHANNEL_R = 0;
    public static final int CHANNEL_G = 1;
    public static final int CHANNEL_B = 2;
    public static final int CHANNEL_NONE = 3;
    public static final int CHANNEL_GG = 4;
    public static final int CHANNEL_BB = 5;
    public static final int CHANNEL_GB = 6;
    private int dominantChannel = 3;

    public ColorModel16Bit(int R, int G, int B) {
        this.setR(0xFD00 | R);
        this.setG(G << 8);
        this.setB(B << 8);
    }

    public static ColorModel16Bit ColorModel8Bit(int r, int g, int b) {
        ColorModel16Bit t = new ColorModel16Bit();
        t.setR(r << 8);
        t.setG(g << 8);
        t.setB(b << 8);
        return t;
    }

    public ColorModel16Bit(int table, int startRow, int endRow, int startCol, int endCol) {
        this.setR(0xFD00 | table);
        this.setG(startRow << 8 | endRow);
        this.setB(startCol << 8 | endCol);
    }

    private ColorModel16Bit() {
    }

    public static ColorModel16Bit getColorModel(int R, int G, int B) {
        ColorModel16Bit model = new ColorModel16Bit();
        model.setR(R);
        model.setG(G);
        model.setB(B);
        return model;
    }

    @Override
    public int compareTo(ColorModel16Bit o) {
        if (this.getG() > o.getG()) {
            return 1;
        }
        if (this.equals(o)) {
            return 0;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        ColorModel16Bit target = (ColorModel16Bit)obj;
        if (this.getR() == 0 && target.getR() == 0 || this.getR() == 65535 || target.getR() == 65535 || this.getR() == 255 || target.getR() == 255) {
            return this.getR() == target.getR() && this.getG() == target.getG() && this.getB() == target.getB();
        }
        switch (this.dominantChannel) {
            case 3: {
                return this.getR() == target.getR() && this.getG() == target.getG() && this.getB() == target.getB();
            }
            case 0: {
                return this.getR() == target.getR();
            }
            case 1: 
            case 4: {
                return this.getG() + this.getR() == target.getG() + target.getR();
            }
            case 2: 
            case 5: {
                return this.getB() + this.getR() == target.getB() + target.getR();
            }
            case 6: {
                return this.getG() + this.getR() == target.getG() + target.getR() || this.getB() + this.getR() == target.getB() + target.getR();
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.getR() == 0 || this.getR() == 65535 || this.getR() == 255) {
            return this.getR() + this.getG() + this.getB();
        }
        switch (this.dominantChannel) {
            case 3: {
                return this.getR() + this.getG() + this.getB();
            }
            case 0: {
                return this.getR();
            }
            case 1: 
            case 4: {
                return this.getR() + this.getG();
            }
            case 2: 
            case 5: {
                return this.getR() + this.getB();
            }
            case 6: {
                return this.getR() + this.getG() + this.getR() + this.getB();
            }
        }
        return 0;
    }

    public static ColorModel16Bit parseColor(String color) {
        ColorModel16Bit returnColor = new ColorModel16Bit(0, 0, 0);
        int commaIndex = color.indexOf(44, 0);
        String r = color.substring(color.indexOf(40) + 1, commaIndex);
        String g = color.substring(commaIndex + 1, color.indexOf(44, commaIndex + 1));
        commaIndex = color.indexOf(44, commaIndex + 1);
        String b = color.substring(commaIndex + 1, color.indexOf(41));
        returnColor.setR(Integer.parseInt(r));
        returnColor.setG(Integer.parseInt(g));
        returnColor.setB(Integer.parseInt(b));
        return returnColor;
    }

    public String toString() {
        return "(" + this.getR() + "," + this.getG() + "," + this.getB() + ")";
    }

    public int getR() {
        return this.R;
    }

    public void setR(int r) {
        this.R = r;
    }

    public int getG() {
        return this.G;
    }

    public void setG(int g) {
        this.G = g;
    }

    public int getB() {
        return this.B;
    }

    public void setB(int b) {
        this.B = b;
    }

    public int getDominantChannel() {
        return this.dominantChannel;
    }

    public void setDominantChannel(int dominantChannel) {
        this.dominantChannel = dominantChannel;
    }
}

