/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.trecs.groundtruth.color;

import de.dfki.trecs.groundtruth.color.ColorModel16Bit;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import net.sourceforge.jiu.color.promotion.PromotionRGB48;
import net.sourceforge.jiu.data.MemoryRGB24Image;
import net.sourceforge.jiu.data.MemoryShortChannelImage;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.data.RGB48Image;
import net.sourceforge.jiu.gui.awt.ToolkitLoader;

public class ColorEnumerator {
    public static final int CELL_ENUMERATOR = 0;
    public static final int ROW_ENUMERATOR = 1;
    public static final int COL_ENUMERATOR = 2;
    public static final int TABLE_ENUMERATOR = 3;
    public static final int ROW_SPAN_ENUMERATOR = 4;
    public static final int COL_SPAN_ENUMERATOR = 5;
    public static final int ROW_COL_SPAN_ENUMERATOR = 6;
    HashMap<ColorModel16Bit, Integer> colorMap = new HashMap();
    HashMap<ColorModel16Bit, Integer> labelMap = new HashMap();
    private int type = 0;
    short[] normalizedImage = null;
    private int labelIndex = 0;
    public static final ColorModel16Bit BLACK = ColorModel16Bit.getColorModel(0, 0, 0);
    public static final ColorModel16Bit WHITE = ColorModel16Bit.getColorModel(65535, 65535, 65535);
    public static final ColorModel16Bit DONTCARE = ColorModel16Bit.getColorModel(255, 255, 255);

    public ColorEnumerator() {
        this.labelMap.put(WHITE, 0);
        this.labelMap.put(BLACK, 1);
        this.labelMap.put(DONTCARE, 2);
        this.labelIndex = 3;
    }

    public ColorEnumerator(int width, int height) {
        this();
        this.normalizedImage = new short[width * height];
        Arrays.fill(this.normalizedImage, (short)0);
    }

    public void addColor(ColorModel16Bit color) {
        if (this.colorMap.containsKey(color)) {
            int freq = this.colorMap.get(color);
            this.colorMap.put(color, ++freq);
        } else {
            this.colorMap.put(color, 1);
            if (!(color.equals(BLACK) | color.equals(WHITE) | color.equals(DONTCARE))) {
                this.labelMap.put(color, this.labelIndex++);
            }
        }
    }

    public int getColorFrequency(ColorModel16Bit color) {
        if (this.colorMap.containsKey(color)) {
            return this.colorMap.get(color);
        }
        return 0;
    }

    public int getNumberOfColors() {
        return this.colorMap.size();
    }

    public int getColorLabel(ColorModel16Bit color) {
        if (this.labelMap.containsKey(color)) {
            return this.labelMap.get(color);
        }
        return -1;
    }

    public int getColorFrequency(int label) {
        for (ColorModel16Bit color : this.labelMap.keySet()) {
            if (this.labelMap.get(color) != label) continue;
            return this.getColorFrequency(color);
        }
        return 0;
    }

    public void setNormalizedImage(int x, ColorModel16Bit color) {
        this.normalizedImage[x] = (short)this.getColorLabel(color);
    }

    public static ColorEnumerator enumerateColorsInImage(RGB48Image image, int type) {
        ColorEnumerator enumerator = new ColorEnumerator(image.getWidth(), image.getHeight());
        enumerator.setType(type);
        int j = 0;
        while (j < image.getHeight()) {
            int i = 0;
            while (i < image.getWidth()) {
                int R = image.getSample(0, i, j);
                int G = image.getSample(1, i, j);
                int B = image.getSample(2, i, j);
                ColorModel16Bit color = ColorModel16Bit.getColorModel(R, G, B);
                switch (enumerator.getType()) {
                    case 0: {
                        color.setDominantChannel(3);
                        break;
                    }
                    case 1: {
                        color.setDominantChannel(1);
                        int g = color.getG();
                        int gLSB = g & 0xFF;
                        int gMSB = g >> 8 & 0xFF;
                        if (gLSB == gMSB) break;
                        color = DONTCARE;
                        break;
                    }
                    case 2: {
                        color.setDominantChannel(2);
                        int b = color.getB();
                        int bLSB = b & 0xFF;
                        int bMSB = b >> 8 & 0xFF;
                        if (bLSB == bMSB) break;
                        color = DONTCARE;
                        break;
                    }
                    case 3: {
                        color.setDominantChannel(0);
                        break;
                    }
                    case 4: {
                        color.setDominantChannel(4);
                        int g = color.getG();
                        int gLSB = g & 0xFF;
                        int gMSB = g >> 8 & 0xFF;
                        if (gLSB != gMSB) break;
                        color = DONTCARE;
                        break;
                    }
                    case 5: {
                        color.setDominantChannel(5);
                        int b = color.getB();
                        int bLSB = b & 0xFF;
                        int bMSB = b >> 8 & 0xFF;
                        if (bLSB != bMSB) break;
                        color = DONTCARE;
                        break;
                    }
                    case 6: {
                        int bMSB;
                        int bLSB;
                        int b;
                        color.setDominantChannel(6);
                        int g = color.getG();
                        int gLSB = g & 0xFF;
                        int gMSB = g >> 8 & 0xFF;
                        if (gLSB == gMSB) {
                            color = DONTCARE;
                        }
                        if ((bLSB = (b = color.getB()) & 0xFF) != (bMSB = b >> 8 & 0xFF)) break;
                        color = DONTCARE;
                    }
                }
                enumerator.addColor(color);
                enumerator.setNormalizedImage(j * image.getWidth() + i, color);
                ++i;
            }
            ++j;
        }
        return enumerator;
    }

    public int getNumberOfLabels() {
        return this.labelMap.size();
    }

    public Iterator<ColorModel16Bit> getColors() {
        return this.colorMap.keySet().iterator();
    }

    public short[] getNormalizedImage() {
        return this.normalizedImage;
    }

    public void setNormalizedImage(short[] normalizedImage) {
        this.normalizedImage = normalizedImage;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public static void main(String[] args) throws Exception {
        PixelImage image = ToolkitLoader.loadViaToolkitOrCodecs((String)"/home/shahab/tmp/0725_026-seg.png");
        Object test = null;
        if (image instanceof MemoryRGB24Image) {
            PromotionRGB48 promotion = new PromotionRGB48();
            promotion.setInputImage(image);
            promotion.process();
            image = promotion.getOutputImage();
            System.out.println("Promoted");
        }
        System.out.println(image.getImageType());
        if (image instanceof MemoryShortChannelImage) {
            ColorModel16Bit color;
            ColorEnumerator enumerator = ColorEnumerator.enumerateColorsInImage((RGB48Image)image, 0);
            Iterator<ColorModel16Bit> iterator = enumerator.getColors();
            System.out.println("Total Number of Colors: " + enumerator.getNumberOfColors());
            while (iterator.hasNext()) {
                color = iterator.next();
                System.out.println(String.valueOf(color.toString()) + ": " + enumerator.getColorFrequency(color) + ": label: " + enumerator.getColorLabel(color));
            }
            enumerator = ColorEnumerator.enumerateColorsInImage((RGB48Image)image, 1);
            iterator = enumerator.getColors();
            System.out.println("Total Number of Colors: " + enumerator.getNumberOfColors());
            while (iterator.hasNext()) {
                color = iterator.next();
                System.out.println(String.valueOf(color.toString()) + ": " + enumerator.getColorFrequency(color) + ": label: " + enumerator.getColorLabel(color));
            }
            enumerator = ColorEnumerator.enumerateColorsInImage((RGB48Image)image, 2);
            iterator = enumerator.getColors();
            System.out.println("Total Number of Colors: " + enumerator.getNumberOfColors());
            while (iterator.hasNext()) {
                color = iterator.next();
                System.out.println(String.valueOf(color.toString()) + ": " + enumerator.getColorFrequency(color) + ": label: " + enumerator.getColorLabel(color));
            }
        }
    }
}

