/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.trecs.evaluation;

import de.dfki.trecs.evaluation.SegmentEvaluationResult;
import de.dfki.trecs.groundtruth.color.ColorEnumerator;
import de.dfki.trecs.groundtruth.color.ColorModel16Bit;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Date;
import java.util.logging.Logger;
import net.sourceforge.jiu.codecs.PNGCodec;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.data.RGB48Image;
import net.sourceforge.jiu.gui.awt.ToolkitLoader;

public class SegmentEvaluation {
    private int[][] colorMatrix = null;
    private String modelImageName = null;
    private String resultImageName = null;
    private String rootOutDir = null;
    private static final String outDir = "de.dfki.trecs.evaluation.segmentevaluation.outdir";
    private static final String outFile = "de.dfki.trecs.evaluation.segmentevaluation.outfile";
    private RGB48Image modelImage = null;
    private RGB48Image resultImage = null;
    private ColorEnumerator modelEnumerator = null;
    private ColorEnumerator resultEnumerator = null;
    private SegmentEvaluationResult evalResult = null;
    private static ColorModel16Bit fineColor = ColorModel16Bit.ColorModel8Bit(0, 255, 0);
    private static ColorModel16Bit missColor = ColorModel16Bit.ColorModel8Bit(255, 0, 0);
    private static ColorModel16Bit falarmColor = ColorModel16Bit.ColorModel8Bit(0, 0, 255);
    private static ColorModel16Bit undersegColor = ColorModel16Bit.ColorModel8Bit(125, 5, 63);
    private static ColorModel16Bit oversegColor = ColorModel16Bit.ColorModel8Bit(141, 56, 201);
    public static final double RELATIVE_THRESHOLD = 0.1;
    public static final double ABSOLUTE_THRESHOLD = 100.0;

    private static Logger log() {
        return Logger.getLogger(SegmentEvaluation.class.getName());
    }

    public SegmentEvaluation(String modelImageName, String resultImageName) {
        this.setModelImageName(modelImageName);
        this.setResultImageName(resultImageName);
        this.init();
    }

    private void init() {
        this.modelImage = (RGB48Image)ToolkitLoader.loadViaToolkitOrCodecs((String)this.modelImageName);
        this.resultImage = (RGB48Image)ToolkitLoader.loadViaToolkitOrCodecs((String)this.resultImageName);
        this.rootOutDir = System.getProperty(outDir, null);
        if (this.modelImage == null || this.resultImage == null) {
            SegmentEvaluation.log().severe("Unable to load images");
            this.exit(-1);
        }
        if (this.modelImage.getWidth() != this.resultImage.getWidth() && this.modelImage.getHeight() != this.resultImage.getHeight()) {
            SegmentEvaluation.log().severe("Dimensions of images donot match");
            this.exit(-2);
        }
        this.evaluate(3);
        this.evaluate(1);
        this.evaluate(2);
        this.evaluate(0);
        this.evaluate(4);
        this.evaluate(5);
        this.evaluate(6);
    }

    public void saveImage(PixelImage image, String imageName) throws Exception {
        PNGCodec codec = new PNGCodec();
        codec.setImage(image);
        codec.setOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(new File(imageName))));
        codec.process();
        codec.close();
    }

    private void evaluate(int enumerator) {
        this.modelEnumerator = ColorEnumerator.enumerateColorsInImage(this.modelImage, enumerator);
        this.resultEnumerator = ColorEnumerator.enumerateColorsInImage(this.resultImage, enumerator);
        this.evalResult = new SegmentEvaluationResult();
        this.colorMatrix = new int[this.modelEnumerator.getNumberOfLabels()][this.resultEnumerator.getNumberOfLabels()];
        int i = 0;
        while (i < this.colorMatrix.length) {
            Arrays.fill(this.colorMatrix[i], 0);
            ++i;
        }
        this.evaluateColorMatrix();
        this.performEvaluation();
        String tmp = new File(this.modelImageName).getName();
        StringBuffer imgName = new StringBuffer(tmp.substring(0, tmp.indexOf(46)));
        StringBuffer resultName = new StringBuffer(imgName.toString());
        String outfile = System.getProperty(outFile, "null");
        StringBuffer evalName = new StringBuffer();
        if (outFile != null) {
            evalName = new StringBuffer(outfile);
        }
        switch (enumerator) {
            case 3: {
                imgName.append("_table_model.png");
                resultName.append("_table_result.png");
                evalName.append("_table.out");
                break;
            }
            case 0: {
                imgName.append("_cell_model.png");
                resultName.append("_cell_result.png");
                evalName.append("_cell.out");
                break;
            }
            case 1: {
                imgName.append("_row_model.png");
                resultName.append("_row_result.png");
                evalName.append("_row.out");
                break;
            }
            case 4: {
                imgName.append("_rowspan_model.png");
                resultName.append("_rowspan_result.png");
                evalName.append("_rowspan.out");
                break;
            }
            case 5: {
                imgName.append("_colspan_model.png");
                resultName.append("_colspan_result.png");
                evalName.append("_colspan.out");
                break;
            }
            case 6: {
                imgName.append("_rowcolspan_model.png");
                resultName.append("_rowcolspan_result.png");
                evalName.append("_rowcolspan.out");
                break;
            }
            case 2: {
                imgName.append("_col_model.png");
                resultName.append("_col_result.png");
                evalName.append("_col.out");
            }
        }
        if (this.rootOutDir != null) {
            this.saveSegmentationErrors(this.evalResult, new File(this.rootOutDir, imgName.toString()).getAbsolutePath(), new File(this.rootOutDir, resultName.toString()).getAbsolutePath());
            this.saveEvaluationResult(this.evalResult, evalName.toString());
        }
    }

    public void saveEvaluationResult(SegmentEvaluationResult eval, String out_file) {
        File f = new File(this.rootOutDir, out_file);
        StringBuffer resultLine = new StringBuffer();
        resultLine.append(new File(this.modelImageName).getName());
        resultLine.append(";" + new File(this.resultImageName).getName());
        resultLine.append(";" + eval.getFileString());
        resultLine.append(";");
        try {
            PrintWriter writer = new PrintWriter(new OutputStreamWriter(new FileOutputStream(f, true)));
            writer.println(resultLine.toString());
            writer.close();
        }
        catch (Exception ex) {
            System.out.println("Cant write to aan outfile");
        }
    }

    public void saveSegmentationErrors(SegmentEvaluationResult eval, String model_out, String result_out) {
        int num_over = eval.getiOverSeg().size();
        int num_under = eval.getiUnderSeg().size();
        int num_miss = eval.getiMissed().size();
        int num_falarm = eval.getiFAlarm().size();
        RGB48Image modelImageCopy = (RGB48Image)this.modelImage.createCopy();
        RGB48Image resultImageCopy = (RGB48Image)this.resultImage.createCopy();
        int width = modelImageCopy.getWidth();
        int height = modelImageCopy.getHeight();
        if (modelImageCopy != null && resultImageCopy != null && this.modelEnumerator != null && this.resultEnumerator != null) {
            int y;
            int x;
            short value;
            int j;
            int i = 0;
            while (i < height) {
                j = 0;
                while (j < width) {
                    value = this.modelEnumerator.getNormalizedImage()[i * width + j];
                    x = 0;
                    while (x < num_over) {
                        if (value == (Integer)eval.getiOverSeg().get(x)) {
                            modelImageCopy.putSample(2, j, i, oversegColor.getB());
                            modelImageCopy.putSample(1, j, i, oversegColor.getG());
                            modelImageCopy.putSample(0, j, i, oversegColor.getR());
                            break;
                        }
                        ++x;
                    }
                    y = 0;
                    while (y < num_miss) {
                        if (value == (Integer)eval.getiMissed().get(y)) {
                            modelImageCopy.putSample(1, j, i, missColor.getG());
                            modelImageCopy.putSample(2, j, i, missColor.getB());
                            modelImageCopy.putSample(0, j, i, missColor.getR());
                            break;
                        }
                        ++y;
                    }
                    if (value > 2 && !eval.getiOverSeg().contains(value) && !eval.getiMissed().contains(value)) {
                        modelImageCopy.putSample(1, j, i, fineColor.getG());
                        modelImageCopy.putSample(2, j, i, fineColor.getB());
                        modelImageCopy.putSample(0, j, i, fineColor.getR());
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < height) {
                j = 0;
                while (j < width) {
                    value = this.resultEnumerator.getNormalizedImage()[i * width + j];
                    x = 0;
                    while (x < num_under) {
                        if (value == (Integer)eval.getiUnderSeg().get(x)) {
                            resultImageCopy.putSample(0, j, i, undersegColor.getR());
                            resultImageCopy.putSample(1, j, i, undersegColor.getG());
                            resultImageCopy.putSample(2, j, i, undersegColor.getB());
                            break;
                        }
                        ++x;
                    }
                    y = 0;
                    while (y < num_falarm) {
                        if (value == (Integer)eval.getiFAlarm().get(y)) {
                            resultImageCopy.putSample(0, j, i, falarmColor.getR());
                            resultImageCopy.putSample(1, j, i, falarmColor.getG());
                            resultImageCopy.putSample(2, j, i, falarmColor.getB());
                            break;
                        }
                        ++y;
                    }
                    if (value > 2 && !eval.getiUnderSeg().contains(value) && !eval.getiFAlarm().contains(value)) {
                        resultImageCopy.putSample(1, j, i, fineColor.getG());
                        resultImageCopy.putSample(2, j, i, fineColor.getB());
                        resultImageCopy.putSample(0, j, i, fineColor.getR());
                    }
                    ++j;
                }
                ++i;
            }
        }
        try {
            this.saveImage((PixelImage)modelImageCopy, model_out);
            this.saveImage((PixelImage)resultImageCopy, result_out);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void calculateCorrect() {
        int j;
        int startIndex = 3;
        int nrows = this.colorMatrix.length;
        int ncols = this.colorMatrix[nrows - 1].length;
        int[] rowsum = new int[nrows];
        int[] colsum = new int[ncols];
        Arrays.fill(rowsum, 0);
        Arrays.fill(colsum, 0);
        int i = 0;
        while (i < ncols) {
            j = 0;
            while (j < nrows) {
                int n = i;
                colsum[n] = colsum[n] + this.colorMatrix[j][i];
                ++j;
            }
            ++i;
        }
        int j2 = 0;
        while (j2 < nrows) {
            int i2 = 0;
            while (i2 < ncols) {
                int n = j2;
                rowsum[n] = rowsum[n] + this.colorMatrix[j2][i2];
                ++i2;
            }
            ++j2;
        }
        i = startIndex;
        while (i < ncols) {
            j = startIndex;
            while (j < nrows) {
                if (this.colorMatrix[j][i] != 0) {
                    if (this.colorMatrix[j][i] >= (int)(0.9 * (double)colsum[i]) && this.colorMatrix[j][i] >= (int)(0.9 * (double)rowsum[j])) {
                        this.evalResult.incrementCorrect();
                    } else if (this.colorMatrix[j][i] > (int)(0.1 * (double)colsum[i]) && this.colorMatrix[j][i] > (int)(0.1 * (double)rowsum[j])) {
                        boolean partialEdges = false;
                        int n = startIndex;
                        while (n < ncols) {
                            if (n != i && (double)this.colorMatrix[j][n] / (double)colsum[n] >= 0.1) {
                                partialEdges = true;
                            }
                            ++n;
                        }
                        n = startIndex;
                        while (n < nrows) {
                            if (n != j && (double)this.colorMatrix[n][i] / (double)rowsum[n] >= 0.1) {
                                partialEdges = true;
                            }
                            ++n;
                        }
                        if (!partialEdges) {
                            this.evalResult.incrementPartialMatches();
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void performEvaluation() {
        double frac;
        int splits;
        int total;
        int startIndex;
        int i = startIndex = 3;
        while (i < this.colorMatrix.length) {
            total = 0;
            int j = startIndex;
            while (j < this.colorMatrix[i].length) {
                total += this.colorMatrix[i][j];
                ++j;
            }
            if (total == 0) {
                this.evalResult.incrementMCount();
                this.evalResult.incrementMOver();
                this.evalResult.incrementMissed();
                this.evalResult.pushIMissed(i);
            } else {
                this.evalResult.incrementMCount();
                splits = 0;
                int j2 = startIndex;
                while (j2 < this.colorMatrix[i].length) {
                    if (this.colorMatrix[i][j2] != 0 && (frac = (double)this.colorMatrix[i][j2] * 1.0 / (double)total) > 0.1) {
                        this.evalResult.incrementMOver();
                        ++splits;
                    }
                    ++j2;
                }
                if (splits > 1) {
                    this.evalResult.pushIOverSeg(i);
                }
            }
            ++i;
        }
        int j = startIndex;
        while (j < this.colorMatrix[0].length) {
            total = 0;
            int i2 = startIndex;
            while (i2 < this.colorMatrix.length) {
                total += this.colorMatrix[i2][j];
                ++i2;
            }
            if (total == 0) {
                this.evalResult.incrementICount();
                this.evalResult.incrementiOver();
                this.evalResult.incrementFalseAlarms();
                this.evalResult.pushIFAlarm(j);
            } else {
                this.evalResult.incrementICount();
                splits = 0;
                int i3 = startIndex;
                while (i3 < this.colorMatrix.length) {
                    if (this.colorMatrix[i3][j] != 0 && (frac = (double)this.colorMatrix[i3][j] * 1.0 / (double)total) > 0.1) {
                        this.evalResult.incrementiOver();
                        ++splits;
                    }
                    ++i3;
                }
                if (splits > 1) {
                    this.evalResult.pushIUnderSeg(j);
                }
            }
            ++j;
        }
        this.calculateCorrect();
    }

    private void evaluateColorMatrix() {
        short[] result1d;
        short[] model1d = this.modelEnumerator.getNormalizedImage();
        if (model1d.length != (result1d = this.resultEnumerator.getNormalizedImage()).length) {
            SegmentEvaluation.log().severe("Model and Result Normalized Images don't match in size");
            this.exit(-1);
        }
        boolean two_count = false;
        boolean thr_count = false;
        int i = 0;
        while (i < model1d.length) {
            short mval = model1d[i];
            short rval = result1d[i];
            int[] nArray = this.colorMatrix[mval];
            short s = rval;
            nArray[s] = nArray[s] + 1;
            ++i;
        }
    }

    private void printColorMatrix() {
        int i = 3;
        while (i < this.colorMatrix.length) {
            int j = 3;
            while (j < this.colorMatrix[i].length) {
                System.out.print(String.valueOf(this.colorMatrix[i][j]) + "\t");
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    public void exit(int status) {
        if (status == 0) {
            SegmentEvaluation.log().info("Done Segment Evaluation");
        } else {
            SegmentEvaluation.log().severe("Segment Evaluation Failed. Exit with status code: " + status);
        }
        System.exit(status);
    }

    public int[][] getColorMatrix() {
        return this.colorMatrix;
    }

    public void setColorMatrix(int[][] colorMatrix) {
        this.colorMatrix = colorMatrix;
    }

    public String getModelImageName() {
        return this.modelImageName;
    }

    public void setModelImageName(String modelImageName) {
        this.modelImageName = modelImageName;
    }

    public String getResultImageName() {
        return this.resultImageName;
    }

    public void setResultImageName(String resultImageName) {
        this.resultImageName = resultImageName;
    }

    public RGB48Image getModelImage() {
        return this.modelImage;
    }

    public void setModelImage(RGB48Image modelImage) {
        this.modelImage = modelImage;
    }

    public RGB48Image getResultImage() {
        return this.resultImage;
    }

    public void setResultImage(RGB48Image resultImage) {
        this.resultImage = resultImage;
    }

    public SegmentEvaluationResult getEvalResult() {
        return this.evalResult;
    }

    public void setEvalResult(SegmentEvaluationResult evalResult) {
        this.evalResult = evalResult;
    }

    public static void main(String[] args) {
        System.out.println("Evaluation starts: " + new Date());
        SegmentEvaluation evaluator = new SegmentEvaluation(args[0], args[1]);
        System.out.println("Evaluation done: " + new Date());
    }
}

