/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.util;

import java.io.IOException;
import java.io.OutputStream;

public class SeekableByteArrayOutputStream
extends OutputStream {
    private byte[] buffer;
    private boolean closed;
    private int incrementStep;
    private int offset;
    private int size;

    public SeekableByteArrayOutputStream() {
        this(1024, 1024);
    }

    public SeekableByteArrayOutputStream(int initialCapacity) {
        this(initialCapacity, initialCapacity == 0 ? 1024 : initialCapacity);
    }

    public SeekableByteArrayOutputStream(int initialCapacity, int increment) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Value for initial capacity must not be negative.");
        }
        if (increment < 1) {
            throw new IllegalArgumentException("Value for increment must be 1 or larger.");
        }
        this.buffer = new byte[initialCapacity];
        this.incrementStep = increment;
        this.offset = 0;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    private void ensureSpace(int numBytes) throws IOException {
        if (this.closed) {
            throw new IOException("Stream was closed already. Cannot write to closed stream.");
        }
        if (numBytes < 0) {
            throw new IllegalArgumentException("Cannot write negative number of bytes (" + numBytes + ").");
        }
        if (this.buffer.length - this.offset < numBytes) {
            this.increaseBuffer(Math.max(this.buffer.length + this.incrementStep, this.offset + numBytes));
        }
    }

    public int getPosition() {
        return this.offset;
    }

    public int getSize() {
        return this.size;
    }

    private void increaseBuffer(int newLength) {
        if (newLength <= this.buffer.length) {
            return;
        }
        byte[] temp = new byte[newLength];
        System.arraycopy(this.buffer, 0, temp, 0, this.offset);
        this.buffer = temp;
    }

    public void seek(int newOffset) throws IOException {
        if (newOffset < 0) {
            throw new IOException("Cannot seek to negative offset (" + newOffset + ").");
        }
        if (newOffset > this.size) {
            throw new IOException("Cannot seek to offset " + newOffset + ", stream has only " + this.size + " byte(s).");
        }
        this.offset = newOffset;
    }

    public byte[] toByteArray() {
        byte[] result = new byte[this.size];
        System.arraycopy(this.buffer, 0, result, 0, this.size);
        return result;
    }

    public void truncate() {
        this.size = this.offset;
    }

    @Override
    public void write(int b) throws IOException {
        this.ensureSpace(1);
        this.buffer[this.offset++] = (byte)b;
        if (this.offset > this.size) {
            this.size = this.offset;
        }
    }

    @Override
    public void write(byte[] data) throws IOException {
        this.write(data, 0, data.length);
    }

    @Override
    public void write(byte[] src, int srcOffset, int num) throws IOException {
        this.ensureSpace(num);
        System.arraycopy(src, srcOffset, this.buffer, this.offset, num);
        this.offset += num;
        if (this.offset > this.size) {
            this.size = this.offset;
        }
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.buffer, 0, this.size);
    }
}

