/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.gui.awt.dialogs;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import net.sourceforge.jiu.apps.Strings;

public class ScaleDialog
extends Dialog
implements ActionListener,
KeyListener {
    private Button ok;
    private Button cancel;
    private TextComponent heightTextField;
    private TextComponent widthTextField;
    private Checkbox maintainAspectRatio;
    private Choice types;
    private boolean pressedOk = false;
    private String oldWidthString;
    private String oldHeightString;
    private int oldWidth;
    private int oldHeight;
    private int type;

    public ScaleDialog(Frame owner, Strings strings, int width, int height, boolean pickType, String[] typeNames, int initialType) {
        super(owner, strings.get(60), true);
        this.oldWidth = width;
        this.oldWidthString = Integer.toString(this.oldWidth);
        this.oldHeight = height;
        this.oldHeightString = Integer.toString(this.oldHeight);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(0, 2));
        Label widthLabel = new Label(strings.get(61));
        this.widthTextField = new TextField(Integer.toString(width), 6);
        this.widthTextField.addKeyListener(this);
        Label heightLabel = new Label(strings.get(62));
        this.heightTextField = new TextField(Integer.toString(height), 6);
        this.heightTextField.addKeyListener(this);
        panel.add(widthLabel);
        panel.add(this.widthTextField);
        panel.add(heightLabel);
        panel.add(this.heightTextField);
        panel.add(new Label(""));
        this.maintainAspectRatio = new Checkbox(strings.get(63), true);
        panel.add(this.maintainAspectRatio);
        this.type = initialType;
        if (pickType) {
            panel.add(new Label(strings.get(76)));
            this.types = new Choice();
            int i = 0;
            while (i < typeNames.length) {
                this.types.add(typeNames[i]);
                ++i;
            }
            this.types.select(initialType);
            panel.add(this.types);
        }
        this.add((Component)panel, "Center");
        this.ok = new Button(strings.get(64));
        this.ok.addActionListener(this);
        this.cancel = new Button(strings.get(65));
        this.cancel.addActionListener(this);
        panel = new Panel();
        panel.add(this.ok);
        panel.add(this.cancel);
        this.add((Component)panel, "South");
        this.pack();
        this.center();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.ok) {
            this.pressedOk = true;
            this.setVisible(false);
        } else if (e.getSource() == this.cancel) {
            this.setVisible(false);
        }
    }

    public void center() {
        Rectangle rect = this.getBounds();
        int width = rect.width;
        int height = rect.height;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(screenSize.width / 2 - width / 2, screenSize.height / 2 - height / 2);
    }

    public int getHeightValue() {
        return this.getValue(this.heightTextField);
    }

    public int getType() {
        if (this.types == null) {
            return this.type;
        }
        return this.types.getSelectedIndex();
    }

    private int getValue(TextComponent textField) {
        try {
            return Integer.parseInt(textField.getText());
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    public int getWidthValue() {
        return this.getValue(this.widthTextField);
    }

    public boolean hasPressedOk() {
        return this.pressedOk;
    }

    public void handleKeys(KeyEvent e) {
        if (e.getSource() == this.widthTextField) {
            int w;
            String text = this.widthTextField.getText();
            if (this.maintainAspectRatio.getState() && !text.equals(this.oldWidthString) && (w = this.getValue(this.widthTextField)) > 0) {
                this.oldHeightString = Integer.toString((int)((float)w * (float)this.oldHeight / (float)this.oldWidth));
                this.heightTextField.setText(this.oldHeightString);
            }
        } else if (e.getSource() == this.heightTextField) {
            int h;
            String text = this.heightTextField.getText();
            if (this.maintainAspectRatio.getState() && !text.equals(this.oldHeightString) && (h = this.getValue(this.heightTextField)) > 0) {
                this.oldWidthString = Integer.toString((int)((float)h * (float)this.oldWidth / (float)this.oldHeight));
                this.widthTextField.setText(this.oldWidthString);
            }
        }
        this.oldWidthString = this.widthTextField.getText();
        this.oldHeightString = this.heightTextField.getText();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.handleKeys(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.handleKeys(e);
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.handleKeys(e);
    }
}

