/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.gui.awt.dialogs;

import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import net.sourceforge.jiu.apps.Strings;

public class ReduceGrayscaleDialog
extends Dialog
implements ActionListener,
AdjustmentListener {
    public static final int TYPE_DITHERING_NONE = 0;
    public static final int TYPE_ORDERED_DITHERING = 1;
    public static final int TYPE_FLOYD_STEINBERG_ERROR_DIFFUSION = 2;
    public static final int TYPE_STUCKI_ERROR_DIFFUSION = 3;
    public static final int TYPE_BURKES_ERROR_DIFFUSION = 4;
    public static final int TYPE_SIERRA_ERROR_DIFFUSION = 5;
    public static final int TYPE_JARVIS_JUDICE_NINKE_ERROR_DIFFUSION = 6;
    public static final int TYPE_STEVENSON_ARCE_ERROR_DIFFUSION = 7;
    public final int[][] DITHERING_METHODS;
    private Strings strings;
    private Button ok;
    private Button cancel;
    private Scrollbar scrollbar;
    private Choice ditheringMethod;
    private Label bitLabel;
    private Label shadesLabel;
    private boolean pressedOk;

    public ReduceGrayscaleDialog(Frame owner, Strings strings, int bits, int maxBits, int ditheringMethodSelection) {
        super(owner, strings.get(99), true);
        int[][] nArrayArray = new int[2][];
        int[] nArray = new int[8];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[]{92, 91, 124, 125, 126, 127, 128, 129};
        this.DITHERING_METHODS = nArrayArray;
        this.pressedOk = false;
        this.strings = strings;
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(0, 2));
        this.bitLabel = new Label();
        panel.add(this.bitLabel);
        this.scrollbar = new Scrollbar(0, bits, 1, 1, maxBits + 1);
        this.scrollbar.addAdjustmentListener(this);
        panel.add(this.scrollbar);
        panel.add(new Label(String.valueOf(strings.get(102)) + ": "));
        this.shadesLabel = new Label();
        panel.add(this.shadesLabel);
        panel.add(new Label(strings.get(93)));
        this.ditheringMethod = new Choice();
        int i = 0;
        while (i < this.DITHERING_METHODS[0].length) {
            this.ditheringMethod.add(strings.get(this.DITHERING_METHODS[1][i]));
            if (ditheringMethodSelection == i) {
                this.ditheringMethod.select(i);
            }
            ++i;
        }
        panel.add(this.ditheringMethod);
        this.add((Component)panel, "Center");
        this.ok = new Button(strings.get(64));
        this.ok.addActionListener(this);
        this.cancel = new Button(strings.get(65));
        this.cancel.addActionListener(this);
        panel = new Panel();
        panel.add(this.ok);
        panel.add(this.cancel);
        this.add((Component)panel, "South");
        this.updateLabels();
        this.pack();
        this.center();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.ok) {
            this.pressedOk = true;
            this.setVisible(false);
        } else if (e.getSource() == this.cancel) {
            this.setVisible(false);
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.updateLabels();
    }

    public void center() {
        Rectangle rect = this.getBounds();
        int width = rect.width;
        int height = rect.height;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(screenSize.width / 2 - width / 2, screenSize.height / 2 - height / 2);
    }

    public int getDitheringMethod() {
        return this.DITHERING_METHODS[0][this.ditheringMethod.getSelectedIndex()];
    }

    public int getNumBits() {
        return this.scrollbar.getValue();
    }

    public boolean hasPressedOk() {
        return this.pressedOk;
    }

    private void updateLabels() {
        int numBits = this.getNumBits();
        this.bitLabel.setText(String.valueOf(this.strings.get(101)) + ": " + numBits);
        this.shadesLabel.setText(Integer.toString(1 << numBits));
    }
}

