/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.gui.awt.dialogs;

import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import net.sourceforge.jiu.apps.Strings;

public class MedianCutDialog
extends Dialog
implements ActionListener,
ItemListener,
KeyListener {
    public final int[][] METHODS;
    public final int[] ERROR_DIFFUSION_STRINGS;
    public final int[] ERROR_DIFFUSION_TYPES;
    private Button ok;
    private Button cancel;
    private TextField numColorsField;
    private Choice outputColorType;
    private Choice reprColorMethod;
    private Choice algorithms;
    private Choice errorDiffusion;
    private TextField numPassesField;
    private TextField tauField;
    private boolean pressedOk;

    public MedianCutDialog(Frame owner, Strings strings, int numColors, int representativeColorMethod, boolean paletted, int numPasses, double initialTau) {
        super(owner, strings.get(67), true);
        int[][] nArrayArray = new int[2][];
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[2] = 2;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[]{70, 69, 71};
        this.METHODS = nArrayArray;
        this.ERROR_DIFFUSION_STRINGS = new int[]{124, 125, 126, 127, 128, 129};
        int[] nArray2 = new int[6];
        nArray2[1] = 1;
        nArray2[2] = 2;
        nArray2[3] = 3;
        nArray2[4] = 4;
        nArray2[5] = 5;
        this.ERROR_DIFFUSION_TYPES = nArray2;
        this.pressedOk = false;
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(0, 2));
        panel.add(new Label(strings.get(66)));
        this.numColorsField = new TextField(Integer.toString(numColors), 6);
        this.numColorsField.addKeyListener(this);
        panel.add(this.numColorsField);
        panel.add(new Label(strings.get(68)));
        this.outputColorType = new Choice();
        this.outputColorType.add(strings.get(72));
        this.outputColorType.add(strings.get(73));
        this.outputColorType.select(paletted ? 0 : 1);
        panel.add(this.outputColorType);
        panel.add(new Label(strings.get(74)));
        this.reprColorMethod = new Choice();
        int i = 0;
        while (i < this.METHODS[0].length) {
            this.reprColorMethod.add(strings.get(this.METHODS[1][i]));
            if (representativeColorMethod == this.METHODS[0][i]) {
                this.reprColorMethod.select(i);
            }
            ++i;
        }
        panel.add(this.reprColorMethod);
        panel.add(new Label(strings.get(130)));
        this.algorithms = new Choice();
        this.algorithms.add(strings.get(131));
        this.algorithms.add(strings.get(132));
        this.algorithms.add(strings.get(75));
        this.algorithms.select(1);
        this.algorithms.addItemListener(this);
        panel.add(this.algorithms);
        panel.add(new Label(strings.get(132)));
        this.errorDiffusion = new Choice();
        i = 0;
        while (i < this.ERROR_DIFFUSION_STRINGS.length) {
            this.errorDiffusion.add(strings.get(this.ERROR_DIFFUSION_STRINGS[i]));
            ++i;
        }
        this.errorDiffusion.select(0);
        panel.add(this.errorDiffusion);
        panel.add(new Label(strings.get(156)));
        this.numPassesField = new TextField(Integer.toString(numPasses));
        this.numPassesField.addKeyListener(this);
        panel.add(this.numPassesField);
        panel.add(new Label(strings.get(157)));
        this.tauField = new TextField(Double.toString(initialTau));
        this.tauField.addKeyListener(this);
        panel.add(this.tauField);
        this.add((Component)panel, "Center");
        this.ok = new Button(strings.get(64));
        this.ok.addActionListener(this);
        this.cancel = new Button(strings.get(65));
        this.cancel.addActionListener(this);
        this.updateStates();
        panel = new Panel();
        panel.add(this.ok);
        panel.add(this.cancel);
        this.add((Component)panel, "South");
        this.pack();
        this.center();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.ok) {
            this.pressedOk = true;
            this.setVisible(false);
        } else if (e.getSource() == this.cancel) {
            this.setVisible(false);
        }
    }

    public void center() {
        Rectangle rect = this.getBounds();
        int width = rect.width;
        int height = rect.height;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(screenSize.width / 2 - width / 2, screenSize.height / 2 - height / 2);
    }

    public int getErrorDiffusion() {
        if (this.algorithms.getSelectedIndex() == 1) {
            return this.ERROR_DIFFUSION_TYPES[this.errorDiffusion.getSelectedIndex()];
        }
        return -1;
    }

    private double getDoubleValue(TextField textField) {
        try {
            Double d = new Double(textField.getText());
            return d;
        }
        catch (NumberFormatException nfe) {
            return Double.NaN;
        }
    }

    private int getIntValue(TextField textField) {
        try {
            return Integer.parseInt(textField.getText());
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    public int getNumColors() {
        return this.getIntValue(this.numColorsField);
    }

    public int getNumPasses() {
        return this.getIntValue(this.numPassesField);
    }

    public int getReprColorMethod() {
        return this.METHODS[0][this.reprColorMethod.getSelectedIndex()];
    }

    public double getTau() {
        return this.getDoubleValue(this.tauField);
    }

    public boolean hasPressedOk() {
        return this.pressedOk;
    }

    public boolean isOutputTypePaletted() {
        return this.outputColorType.getSelectedIndex() == 0;
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (event.getSource() == this.algorithms) {
            this.updateStates();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.updateOkButton();
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.updateOkButton();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.updateOkButton();
    }

    private void updateOkButton() {
        boolean enabled;
        int nc = this.getNumColors();
        boolean bl = enabled = nc >= 1 && nc <= 256;
        if (enabled && this.algorithms.getSelectedIndex() == 2) {
            enabled = this.getTau() >= 0.0 && this.getNumPasses() >= 1;
        }
        this.ok.setEnabled(enabled);
    }

    private void updateStates() {
        int algorithmSelection = this.algorithms.getSelectedIndex();
        boolean ed = algorithmSelection == 1;
        this.errorDiffusion.setEnabled(ed);
        ed = algorithmSelection == 2;
        this.tauField.setEnabled(ed);
        this.numPassesField.setEnabled(ed);
    }

    public boolean useContourRemoval() {
        return this.algorithms.getSelectedIndex() == 2;
    }

    public boolean useErrorDiffusion() {
        return this.algorithms.getSelectedIndex() == 1;
    }
}

