/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.gui.awt.dialogs;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import net.sourceforge.jiu.apps.Strings;
import net.sourceforge.jiu.gui.awt.dialogs.Dialogs;

public class MapToArbitraryPaletteDialog
extends Dialog
implements ActionListener {
    public static final int PALETTE_FILE = 0;
    public static final int PALETTE_WEBSAFE = 1;
    public static final int PALETTE_PALM_256_COLORS = 2;
    public static final int PALETTE_PALM_16_COLORS = 3;
    public static final int PALETTE_PALM_16_GRAY = 4;
    public static final int PALETTE_PALM_4_GRAY = 5;
    public static final int NUM_PALETTE_TYPES = 6;
    private static final int[] PALETTE_STRING_CONSTANTS = new int[]{165, 164, 210, 211, 212, 213};
    private static final int[] DITHERING_STRING_CONSTANTS = new int[]{92, 124, 125, 126, 127, 128, 129};
    private static final int[] ERROR_DIFFUSION_TYPES;
    private Button ok;
    private Button cancel;
    private Checkbox[] checkboxes;
    private CheckboxGroup paletteType;
    private Choice dithering;
    private boolean pressedOk = false;

    static {
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        ERROR_DIFFUSION_TYPES = nArray;
    }

    public MapToArbitraryPaletteDialog(Frame owner, Strings strings) {
        super(owner, strings.get(167), true);
        Panel mainPanel = new Panel(new GridLayout(0, 1));
        Panel panel = new Panel(new GridLayout(0, 1));
        panel.add(new Label(strings.get(166)));
        mainPanel.add(panel);
        panel = new Panel(new GridLayout(0, 1));
        this.paletteType = new CheckboxGroup();
        this.checkboxes = new Checkbox[PALETTE_STRING_CONSTANTS.length];
        boolean selected = true;
        int i = 0;
        while (i < 6) {
            this.checkboxes[i] = new Checkbox(strings.get(PALETTE_STRING_CONSTANTS[i]), this.paletteType, selected);
            selected = false;
            panel.add(this.checkboxes[i]);
            ++i;
        }
        mainPanel.add(panel);
        panel = new Panel();
        panel.add(new Label(strings.get(93)));
        this.dithering = new Choice();
        i = 0;
        while (i < DITHERING_STRING_CONSTANTS.length) {
            this.dithering.add(strings.get(DITHERING_STRING_CONSTANTS[i]));
            ++i;
        }
        this.dithering.select(1);
        panel.add(this.dithering);
        mainPanel.add(panel);
        this.add((Component)mainPanel, "Center");
        panel = new Panel();
        this.ok = new Button(strings.get(64));
        this.ok.addActionListener(this);
        panel.add(this.ok);
        this.cancel = new Button(strings.get(65));
        this.cancel.addActionListener(this);
        panel.add(this.cancel);
        this.add((Component)panel, "South");
        this.pack();
        Dialogs.center(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.ok) {
            this.pressedOk = true;
            this.setVisible(false);
        } else if (e.getSource() == this.cancel) {
            this.setVisible(false);
        }
    }

    public int getErrorDiffusionType() {
        int sel = this.dithering.getSelectedIndex();
        if (sel > 0 && sel <= ERROR_DIFFUSION_TYPES.length) {
            return ERROR_DIFFUSION_TYPES[sel - 1];
        }
        return -1;
    }

    public int getPaletteType() {
        int i = 0;
        while (i < this.checkboxes.length) {
            if (this.checkboxes[i].getState()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean hasPressedOk() {
        return this.pressedOk;
    }

    public boolean useErrorDiffusion() {
        return this.dithering.getSelectedIndex() > 0;
    }
}

