/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.gui.awt.dialogs;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import net.sourceforge.jiu.apps.Strings;
import net.sourceforge.jiu.gui.awt.dialogs.Dialogs;

public class GammaCorrectionDialog
extends Dialog
implements ActionListener,
KeyListener {
    private Button ok;
    private Button cancel;
    private TextField gammaTextField;
    private boolean pressedOk;
    private Double result;
    private final double MAX_GAMMA;

    public GammaCorrectionDialog(Frame owner, Strings strings, double initialValue, double maxGamma) {
        super(owner, strings.get(112), true);
        this.MAX_GAMMA = maxGamma;
        Panel panel = new Panel(new BorderLayout());
        panel.add((Component)new Label(strings.get(113)), "Center");
        this.gammaTextField = new TextField(Double.toString(initialValue));
        this.gammaTextField.addKeyListener(this);
        panel.add((Component)this.gammaTextField, "East");
        this.add((Component)panel, "Center");
        panel = new Panel();
        this.ok = new Button(strings.get(64));
        this.ok.addActionListener(this);
        this.cancel = new Button(strings.get(65));
        this.cancel.addActionListener(this);
        panel.add(this.ok);
        panel.add(this.cancel);
        this.add((Component)panel, "South");
        this.pack();
        Dialogs.center(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.ok) {
            this.pressedOk = true;
            this.result = this.getValue(this.gammaTextField);
            this.setVisible(false);
        } else if (e.getSource() == this.cancel) {
            this.setVisible(false);
        }
    }

    private Double getValue(TextField tf) {
        double d;
        if (tf == null) {
            return null;
        }
        try {
            d = Double.valueOf(tf.getText());
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        if (d <= 0.0 || d > this.MAX_GAMMA) {
            return null;
        }
        return new Double(d);
    }

    public Double getValue() {
        return this.result;
    }

    public boolean hasPressedOk() {
        return this.pressedOk;
    }

    public void handleKeys(KeyEvent e) {
        this.ok.setEnabled(this.getValue(this.gammaTextField) != null);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.handleKeys(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.handleKeys(e);
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.handleKeys(e);
    }
}

