/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.gui.awt;

import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.IOException;
import java.util.Vector;
import net.sourceforge.jiu.codecs.ImageLoader;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.data.RGB24Image;
import net.sourceforge.jiu.gui.awt.ImageCreator;
import net.sourceforge.jiu.ops.OperationFailedException;

public class ToolkitLoader {
    private static Frame frame = null;

    private ToolkitLoader() {
    }

    public static Image load(String fileName) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.getImage(fileName);
        if (frame == null) {
            frame = new Frame();
        }
        MediaTracker mt = new MediaTracker(frame);
        mt.addImage(image, 0);
        try {
            mt.waitForID(0);
        }
        catch (InterruptedException e) {
            return null;
        }
        return image;
    }

    public static RGB24Image loadAsRgb24Image(String fileName) {
        return ImageCreator.convertImageToRGB24Image(ToolkitLoader.load(fileName));
    }

    public static PixelImage loadViaToolkitOrCodecs(String fileName) {
        return ToolkitLoader.loadViaToolkitOrCodecs(fileName, false, null);
    }

    public static PixelImage loadViaToolkitOrCodecs(String fileName, boolean preferToolkit, Vector progressListeners) {
        PixelImage result = null;
        try {
            if (preferToolkit) {
                result = ToolkitLoader.loadAsRgb24Image(fileName);
                if (result == null) {
                    result = ImageLoader.load(fileName, progressListeners);
                }
            } else {
                result = ImageLoader.load(fileName, progressListeners);
                if (result == null) {
                    result = ToolkitLoader.loadAsRgb24Image(fileName);
                }
            }
        }
        catch (OperationFailedException operationFailedException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }
}

