/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.gui.awt;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.ScrollPane;

public class ImageCanvas
extends Canvas {
    private Image image;
    private int width;
    private int height;
    private int scaledWidth;
    private int scaledHeight;
    private double zoomFactorX = 1.0;
    private double zoomFactorY = 1.0;
    private boolean zoomToFit;
    private ScrollPane myScrollPane;

    public ImageCanvas(ScrollPane scrollPane) {
        this.myScrollPane = scrollPane;
    }

    public void computeZoomToFitSize() {
        if (!this.zoomToFit || this.myScrollPane == null) {
            return;
        }
        Dimension scrollPaneSize = this.myScrollPane.getSize();
        int maxWidth = scrollPaneSize.width;
        int maxHeight = scrollPaneSize.height;
        double paneRatio = (double)maxWidth / (double)maxHeight;
        double imageRatio = (double)this.width / (double)this.height;
        if (paneRatio < imageRatio) {
            this.scaledWidth = maxWidth;
            this.scaledHeight = (int)((double)this.scaledWidth * imageRatio);
        } else {
            this.scaledHeight = maxHeight;
            this.scaledWidth = (int)((double)this.scaledHeight * imageRatio);
        }
        --this.scaledHeight;
        --this.scaledWidth;
        this.zoomFactorY = this.zoomFactorX = (double)this.scaledWidth / (double)this.width;
    }

    public int getZoomPercentageX() {
        return (int)(this.zoomFactorX * 100.0);
    }

    public int getZoomPercentageY() {
        return (int)(this.zoomFactorY * 100.0);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.scaledWidth, this.scaledHeight);
    }

    @Override
    public void paint(Graphics g) {
        if (this.image == null) {
            super.paint(g);
        } else {
            Rectangle rect = this.getBounds();
            int canvasWidth = rect.width;
            int canvasHeight = rect.height;
            int x1 = 0;
            int y1 = 0;
            if (canvasWidth > this.scaledWidth) {
                x1 = (canvasWidth - this.scaledWidth) / 2;
            }
            if (canvasHeight > this.scaledHeight) {
                y1 = (canvasHeight - this.scaledHeight) / 2;
            }
            if (canvasHeight > canvasWidth || canvasHeight > this.scaledHeight) {
                super.paint(g);
            }
            g.drawImage(this.image, x1, y1, this.scaledWidth, this.scaledHeight, this);
        }
    }

    public void setImage(Image newImage) {
        this.image = newImage;
        this.width = this.image.getWidth(this);
        this.height = this.image.getHeight(this);
        this.scaledWidth = (int)((double)this.width * this.zoomFactorX);
        this.scaledHeight = (int)((double)this.height * this.zoomFactorY);
        this.setSize(this.scaledWidth, this.scaledHeight);
        this.validate();
    }

    public void setOriginalSize() {
        this.setZoomFactor(1.0);
    }

    public double getZoomFactorX() {
        return this.zoomFactorX;
    }

    public double getZoomFactorY() {
        return this.zoomFactorY;
    }

    public void setInterpolation(int newType) {
        switch (newType) {
            case 2: {
                break;
            }
            case 1: {
                break;
            }
        }
    }

    public void setZoomFactor(double newZoomFactor) {
        this.setZoomFactors(newZoomFactor, newZoomFactor);
    }

    public void setZoomFactors(double newZoomFactorX, double newZoomFactorY) {
        if (newZoomFactorX <= 0.0 || newZoomFactorY <= 0.0) {
            throw new IllegalArgumentException("Zoom factors must be larger than 0.0.");
        }
        this.zoomFactorX = newZoomFactorX;
        this.zoomFactorY = newZoomFactorY;
        this.scaledWidth = (int)((double)this.width * this.zoomFactorX);
        this.scaledHeight = (int)((double)this.height * this.zoomFactorY);
        this.setSize(this.scaledWidth, this.scaledHeight);
        this.myScrollPane.validate();
    }

    public void setZoomToFit(boolean newValue) {
        this.zoomToFit = newValue;
        this.validate();
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }
}

