/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.gui.awt;

import java.awt.image.BufferedImage;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.data.RGB24Image;

public class BufferedRGB24Image
implements RGB24Image {
    private static final int RED_SHIFT = 16;
    private static final int GREEN_SHIFT = 8;
    private static final int BLUE_SHIFT = 0;
    private static final int[] RGB_CLEAR = new int[3];
    private static final int[] RGB_SHIFT = new int[3];
    private final int HEIGHT;
    private final BufferedImage image;
    private final int WIDTH;

    static {
        BufferedRGB24Image.RGB_SHIFT[0] = 16;
        BufferedRGB24Image.RGB_SHIFT[1] = 8;
        BufferedRGB24Image.RGB_SHIFT[2] = 0;
        BufferedRGB24Image.RGB_CLEAR[0] = -16711681;
        BufferedRGB24Image.RGB_CLEAR[1] = -65281;
        BufferedRGB24Image.RGB_CLEAR[2] = -256;
    }

    public BufferedRGB24Image(BufferedImage bufferedImage) {
        this.image = bufferedImage;
        if (this.image == null) {
            throw new IllegalArgumentException("Argument image object must not be null.");
        }
        this.WIDTH = this.image.getWidth();
        this.HEIGHT = this.image.getHeight();
    }

    @Override
    public void clear(byte newValue) {
        int RGB = newValue & 0xFF | (newValue & 0xFF) << 8 | (newValue & 0xFF) << 16;
        int y = 0;
        while (y < this.getHeight()) {
            int x = 0;
            while (x < this.getWidth()) {
                int rgba = this.image.getRGB(x, y);
                rgba = rgba & 0xFF000000 | RGB;
                this.image.setRGB(x, y, rgba);
                ++x;
            }
            ++y;
        }
    }

    @Override
    public void clear(int newValue) {
        this.clear((byte)newValue);
    }

    @Override
    public void clear(int channelIndex, byte newValue) {
        int MASK = RGB_CLEAR[channelIndex];
        int SAMPLE = (newValue & 0xFF) << RGB_SHIFT[channelIndex];
        int y = 0;
        while (y < this.getHeight()) {
            int x = 0;
            while (x < this.getWidth()) {
                int rgba = this.image.getRGB(x, y);
                rgba = rgba & MASK | SAMPLE;
                this.image.setRGB(x, y, rgba);
                ++x;
            }
            ++y;
        }
    }

    @Override
    public void clear(int channelIndex, int newValue) {
        this.clear(channelIndex, (byte)newValue);
    }

    @Override
    public PixelImage createCompatibleImage(int width, int height) {
        BufferedImage newBufferedImage = new BufferedImage(width, height, this.image.getType());
        return new BufferedRGB24Image(newBufferedImage);
    }

    @Override
    public PixelImage createCopy() {
        BufferedImage newBufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), this.image.getType());
        this.image.copyData(newBufferedImage.getRaster());
        return new BufferedRGB24Image(newBufferedImage);
    }

    @Override
    public long getAllocatedMemory() {
        return 4L * (long)this.getWidth() * (long)this.getHeight();
    }

    @Override
    public int getBitsPerPixel() {
        return 24;
    }

    @Override
    public byte getByteSample(int x, int y) {
        return this.getByteSample(0, x, y);
    }

    @Override
    public byte getByteSample(int channelIndex, int x, int y) {
        return (byte)(this.image.getRGB(x, y) >> RGB_SHIFT[channelIndex] & 0xFF);
    }

    @Override
    public void getByteSamples(int channelIndex, int x, int y, int w, int h, byte[] dest, int destOffset) {
        int SHIFT = RGB_SHIFT[channelIndex];
        int[] row = new int[w];
        while (h-- > 0) {
            this.image.getRGB(x, y++, w, 1, row, 0, w);
            int columns = w;
            int rowIndex = 0;
            while (columns-- > 0) {
                dest[destOffset++] = (byte)(row[rowIndex++] >> SHIFT & 0xFF);
            }
        }
    }

    public void getByteSamples(int x, int y, int w, int h, byte[] dest, int destOffset) {
        this.getByteSamples(0, x, y, w, h, dest, destOffset);
    }

    @Override
    public int getHeight() {
        return this.HEIGHT;
    }

    @Override
    public Class getImageType() {
        return RGB24Image.class;
    }

    @Override
    public int getMaxSample(int channel) {
        if (channel == 2 || channel == 0 || channel == 1) {
            return 255;
        }
        throw new IllegalArgumentException("Not a valid channel index: " + channel);
    }

    @Override
    public int getNumChannels() {
        return 3;
    }

    @Override
    public int getSample(int x, int y) {
        return this.getSample(0, x, y);
    }

    @Override
    public int getSample(int channelIndex, int x, int y) {
        return this.image.getRGB(x, y) >> RGB_SHIFT[channelIndex] & 0xFF;
    }

    public void getSamples(int x, int y, int w, int h, int[] dest, int destOffs) {
        this.getSamples(0, x, y, w, h, dest, destOffs);
    }

    @Override
    public void getSamples(int channelIndex, int x, int y, int w, int h, int[] dest, int destOffs) {
        int SHIFT = RGB_SHIFT[channelIndex];
        int[] row = new int[w];
        while (h-- > 0) {
            this.image.getRGB(x, y++, w, 1, row, 0, w);
            int columns = w;
            int rowIndex = 0;
            while (columns-- > 0) {
                dest[destOffs++] = row[rowIndex++] >> SHIFT & 0xFF;
            }
        }
    }

    @Override
    public int getWidth() {
        return this.WIDTH;
    }

    @Override
    public void putByteSample(int channelIndex, int x, int y, byte newValue) {
        int argb = this.image.getRGB(x, y) & RGB_CLEAR[channelIndex];
        this.image.setRGB(x, y, argb | (newValue & 0xFF) << RGB_SHIFT[channelIndex]);
    }

    @Override
    public void putByteSample(int x, int y, byte newValue) {
        this.putByteSample(0, x, y, newValue);
    }

    @Override
    public void putByteSamples(int channelIndex, int x, int y, int w, int h, byte[] src, int srcOffset) {
        int SHIFT = RGB_SHIFT[channelIndex];
        int MASK = RGB_CLEAR[channelIndex];
        int[] row = new int[w];
        while (h-- > 0) {
            this.image.getRGB(x, y, w, 1, row, 0, w);
            int columns = w;
            int rowIndex = 0;
            while (columns-- > 0) {
                int argb = row[rowIndex] & MASK;
                row[rowIndex++] = argb | (src[srcOffset++] & 0xFF) << SHIFT;
            }
            this.image.setRGB(x, y++, w, 1, row, 0, w);
        }
    }

    public void putByteSamples(int x, int y, int w, int h, byte[] src, int srcOffset) {
        this.putByteSamples(0, x, y, w, h, src, srcOffset);
    }

    @Override
    public void putSample(int x, int y, int newValue) {
        this.putSample(0, x, y, newValue);
    }

    @Override
    public void putSample(int channelIndex, int x, int y, int newValue) {
        int argb = this.image.getRGB(x, y) & RGB_CLEAR[channelIndex];
        this.image.setRGB(x, y, argb | newValue << RGB_SHIFT[channelIndex]);
    }

    @Override
    public void putSamples(int channelIndex, int x, int y, int w, int h, int[] src, int srcOffset) {
        int SHIFT = RGB_SHIFT[channelIndex];
        int MASK = RGB_CLEAR[channelIndex];
        int[] row = new int[w];
        while (h-- > 0) {
            this.image.getRGB(x, y, w, 1, row, 0, w);
            int columns = w;
            int rowIndex = 0;
            while (columns-- > 0) {
                int argb = row[rowIndex] & MASK;
                row[rowIndex++] = argb | src[srcOffset++] << SHIFT;
            }
            this.image.setRGB(x, y++, w, 1, row, 0, w);
        }
    }
}

