/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.geometry;

import net.sourceforge.jiu.data.IntegerImage;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.ops.ImageToImageOperation;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.WrongParameterException;

public class Shear
extends ImageToImageOperation {
    private double angle;

    public static int computeNewImageWidth(int oldImageWidth, int height, double angle) {
        double shearfac = Math.tan(angle * Math.PI / 180.0);
        if (shearfac < 0.0) {
            shearfac = -shearfac;
        }
        return (int)((double)height * shearfac + (double)oldImageWidth + 0.999999);
    }

    public double getAngle() {
        return this.angle;
    }

    private void process(IntegerImage in, IntegerImage out) {
        int WIDTH = in.getWidth();
        int HEIGHT = in.getHeight();
        int totalItems = in.getNumChannels() * HEIGHT;
        int processedItems = 0;
        double angle = this.getAngle() * Math.PI / 180.0;
        double shearfac = Math.tan(angle);
        if (shearfac < 0.0) {
            shearfac = -shearfac;
        }
        int NEW_WIDTH = (int)((double)HEIGHT * shearfac + (double)WIDTH + 0.999999);
        if (out == null) {
            out = (IntegerImage)in.createCompatibleImage(NEW_WIDTH, HEIGHT);
            this.setOutputImage(out);
        }
        int c = 0;
        while (c < in.getNumChannels()) {
            int y = 0;
            while (y < HEIGHT) {
                double new0 = angle > 0.0 ? (double)y * shearfac : (double)(HEIGHT - y) * shearfac;
                int intnew0 = (int)new0;
                double fracnew0 = new0 - (double)intnew0;
                double omfracnew0 = 1.0 - fracnew0;
                int prev = 0;
                int x = 0;
                while (x < WIDTH) {
                    int value = in.getSample(c, x, y);
                    out.putSample(c, intnew0 + x, y, (int)(fracnew0 * (double)prev + omfracnew0 * (double)value));
                    prev = value;
                    ++x;
                }
                out.putSample(c, intnew0 + WIDTH, y, (int)(fracnew0 * (double)prev));
                this.setProgress(processedItems++, totalItems);
                ++y;
            }
            ++c;
        }
    }

    @Override
    public void process() throws MissingParameterException, WrongParameterException {
        this.ensureInputImageIsAvailable();
        PixelImage in = this.getInputImage();
        this.ensureOutputImageResolution(Shear.computeNewImageWidth(in.getWidth(), in.getHeight(), this.getAngle()), in.getHeight());
        if (!(in instanceof IntegerImage)) {
            throw new WrongParameterException("Input image must implement IntegerImage.");
        }
        this.process((IntegerImage)in, (IntegerImage)this.getOutputImage());
    }

    public void setAngle(double newAngle) {
        if (newAngle <= -90.0 || newAngle >= 90.0) {
            throw new IllegalArgumentException("Angle must be > -90 and < 90; got " + newAngle);
        }
        this.angle = newAngle;
    }
}

