/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.geometry;

import net.sourceforge.jiu.data.IntegerImage;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.ops.ImageToImageOperation;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.WrongParameterException;

public class Rotate180
extends ImageToImageOperation {
    private void process(IntegerImage in, IntegerImage out) {
        int WIDTH = in.getWidth();
        int HEIGHT = in.getHeight();
        if (out == null) {
            out = (IntegerImage)in.createCompatibleImage(WIDTH, HEIGHT);
            this.setOutputImage(out);
        }
        int totalItems = in.getNumChannels() * HEIGHT;
        int processedItems = 0;
        int c = 0;
        while (c < in.getNumChannels()) {
            int y1 = 0;
            int y2 = HEIGHT - 1;
            while (y1 < HEIGHT) {
                int x1 = 0;
                int x2 = WIDTH - 1;
                while (x1 < WIDTH) {
                    out.putSample(c, x2, y2, in.getSample(c, x1, y1));
                    ++x1;
                    --x2;
                }
                this.setProgress(processedItems++, totalItems);
                ++y1;
                --y2;
            }
            ++c;
        }
    }

    @Override
    public void process() throws MissingParameterException, WrongParameterException {
        this.ensureInputImageIsAvailable();
        this.ensureImagesHaveSameResolution();
        PixelImage image = this.getInputImage();
        if (!(image instanceof IntegerImage)) {
            throw new WrongParameterException("Input image must implement IntegerImage.");
        }
        this.process((IntegerImage)image, (IntegerImage)this.getOutputImage());
    }
}

