/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.geometry;

import net.sourceforge.jiu.data.IntegerImage;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.ops.ImageToImageOperation;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.WrongParameterException;

public class Flip
extends ImageToImageOperation {
    private void process(IntegerImage in, IntegerImage out) {
        int WIDTH = in.getWidth();
        int HEIGHT = in.getHeight();
        int TOTAL_ITEMS = in.getNumChannels() * HEIGHT;
        if (out == null) {
            out = (IntegerImage)in.createCompatibleImage(WIDTH, HEIGHT);
            this.setOutputImage(out);
        }
        int processedItems = 0;
        int c = 0;
        while (c < in.getNumChannels()) {
            int y1 = 0;
            int y2 = HEIGHT - 1;
            while (y1 < HEIGHT) {
                int x = 0;
                while (x < WIDTH) {
                    out.putSample(c, x, y2, in.getSample(c, x, y1));
                    ++x;
                }
                this.setProgress(processedItems++, TOTAL_ITEMS);
                ++y1;
                --y2;
            }
            ++c;
        }
    }

    @Override
    public void process() throws MissingParameterException, WrongParameterException {
        this.ensureInputImageIsAvailable();
        this.ensureImagesHaveSameResolution();
        PixelImage in = this.getInputImage();
        if (!(in instanceof IntegerImage)) {
            throw new WrongParameterException("Input image must be of type IntegerImage.");
        }
        this.process((IntegerImage)in, (IntegerImage)this.getOutputImage());
    }
}

