/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.filters;

import net.sourceforge.jiu.data.GrayIntegerImage;
import net.sourceforge.jiu.data.IntegerImage;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.data.RGBIntegerImage;
import net.sourceforge.jiu.ops.ImageToImageOperation;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.WrongParameterException;

public abstract class AreaFilterOperation
extends ImageToImageOperation {
    private int areaWidth;
    private int areaHeight;

    public void checkAreaHeight(int height) {
        if (height < 1) {
            throw new IllegalArgumentException("Height must be larger than 0.");
        }
        if ((height & 1) == 0) {
            throw new IllegalArgumentException("Height must be odd.");
        }
    }

    public void checkAreaWidth(int width) {
        if (width < 1) {
            throw new IllegalArgumentException("Width must be larger than 0.");
        }
        if ((width & 1) == 0) {
            throw new IllegalArgumentException("Width must be odd.");
        }
    }

    public abstract int computeSample(int[] var1, int var2);

    public int getAreaHeight() {
        return this.areaHeight;
    }

    public int getAreaWidth() {
        return this.areaWidth;
    }

    private void process(int channelIndex, IntegerImage in, IntegerImage out) {
        this.processBorders(channelIndex, in, out);
        this.processCenter(channelIndex, in, out);
    }

    private void process(IntegerImage in, IntegerImage out) {
        if (out == null) {
            out = (IntegerImage)in.createCompatibleImage(in.getWidth(), in.getHeight());
            this.setOutputImage(out);
        }
        int channelIndex = 0;
        while (channelIndex < in.getNumChannels()) {
            this.process(channelIndex, in, out);
            ++channelIndex;
        }
    }

    @Override
    public void process() throws MissingParameterException, WrongParameterException {
        if (this.areaWidth == 0) {
            throw new MissingParameterException("Area width has not been initialized.");
        }
        if (this.areaHeight == 0) {
            throw new MissingParameterException("Area height has not been initialized.");
        }
        this.ensureInputImageIsAvailable();
        this.ensureImagesHaveSameResolution();
        PixelImage in = this.getInputImage();
        PixelImage out = this.getOutputImage();
        if (!(in instanceof GrayIntegerImage) && !(in instanceof RGBIntegerImage)) {
            throw new WrongParameterException("Input image must implement GrayIntegerImage or RGBIntegerImage.");
        }
        this.process((IntegerImage)in, (IntegerImage)out);
    }

    private void processBorders(int channelIndex, IntegerImage in, IntegerImage out) {
    }

    private void processCenter(int channelIndex, IntegerImage in, IntegerImage out) {
        int HEIGHT = in.getHeight();
        int WIDTH = in.getWidth();
        int AREA_WIDTH = this.getAreaWidth();
        int H_2 = AREA_WIDTH / 2;
        int AREA_HEIGHT = this.getAreaHeight();
        int V_2 = AREA_HEIGHT / 2;
        if (WIDTH < AREA_WIDTH || HEIGHT < AREA_HEIGHT) {
            return;
        }
        int NUM_SAMPLES = AREA_WIDTH * AREA_HEIGHT;
        int TOTAL_ITEMS = in.getNumChannels() * HEIGHT;
        int processedItems = channelIndex * HEIGHT + AREA_HEIGHT / 2;
        int[] samples = new int[AREA_WIDTH * AREA_HEIGHT];
        int y1 = 0;
        int y2 = V_2;
        while (y2 < HEIGHT - V_2) {
            int x1 = 0;
            int x2 = H_2;
            while (x2 < WIDTH - H_2) {
                in.getSamples(channelIndex, x1, y1, this.areaWidth, this.areaHeight, samples, 0);
                out.putSample(channelIndex, x2, y2, this.computeSample(samples, NUM_SAMPLES));
                ++x1;
                ++x2;
            }
            this.setProgress(processedItems++, TOTAL_ITEMS);
            ++y1;
            ++y2;
        }
    }

    public void setArea(int width, int height) {
        this.setAreaWidth(width);
        this.setAreaHeight(height);
    }

    public void setAreaHeight(int height) {
        this.checkAreaHeight(height);
        this.areaHeight = height;
    }

    public void setAreaWidth(int width) {
        this.checkAreaWidth(width);
        this.areaWidth = width;
    }
}

