/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.reduction;

import net.sourceforge.jiu.data.BilevelImage;
import net.sourceforge.jiu.data.GrayIntegerImage;
import net.sourceforge.jiu.data.MemoryBilevelImage;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.ops.ImageToImageOperation;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.WrongParameterException;

public class ReduceToBilevelThreshold
extends ImageToImageOperation {
    private Integer threshold;

    public Integer getThreshold() {
        return this.threshold;
    }

    private void process(GrayIntegerImage in, BilevelImage out) throws WrongParameterException {
        int THRESHOLD;
        int MAX_SAMPLE = in.getMaxSample(0);
        if (this.threshold == null) {
            this.threshold = new Integer((MAX_SAMPLE + 1) / 2);
        }
        if ((THRESHOLD = this.threshold.intValue()) > MAX_SAMPLE) {
            throw new WrongParameterException("Threshold must be smaller than or equal to the maximum sample of the input image.");
        }
        int WIDTH = in.getWidth();
        int HEIGHT = in.getHeight();
        out.clear(0);
        int y = 0;
        while (y < HEIGHT) {
            int x = 0;
            while (x < WIDTH) {
                if (in.getSample(0, x, y) >= THRESHOLD) {
                    out.putWhite(x, y);
                }
                ++x;
            }
            this.setProgress(y, HEIGHT);
            ++y;
        }
    }

    @Override
    public void process() throws MissingParameterException, WrongParameterException {
        PixelImage in = this.getInputImage();
        if (in == null) {
            throw new MissingParameterException("Input image missing.");
        }
        if (!(in instanceof GrayIntegerImage)) {
            throw new WrongParameterException("Input image must implement GrayIntegerImage.");
        }
        PixelImage out = this.getOutputImage();
        if (out == null) {
            out = new MemoryBilevelImage(in.getWidth(), in.getHeight());
            this.setOutputImage(out);
        }
        if (out != null && !(out instanceof BilevelImage)) {
            throw new WrongParameterException("Output image must implement BilevelImage.");
        }
        if (out != null && (in.getWidth() != out.getWidth() || in.getHeight() != out.getHeight())) {
            throw new WrongParameterException("Input and output images must have the same resolution.");
        }
        this.process((GrayIntegerImage)in, (BilevelImage)out);
    }

    public void setThreshold(int newThreshold) {
        if (newThreshold < 0) {
            throw new IllegalArgumentException("New threshold value must be 0 or larger.");
        }
        this.threshold = new Integer(newThreshold);
    }
}

