/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.quantization;

import net.sourceforge.jiu.color.quantization.RGBQuantizer;
import net.sourceforge.jiu.data.MemoryPaletted8Image;
import net.sourceforge.jiu.data.Palette;
import net.sourceforge.jiu.data.Paletted8Image;
import net.sourceforge.jiu.data.RGB24Image;
import net.sourceforge.jiu.data.RGBIndex;
import net.sourceforge.jiu.ops.ImageToImageOperation;

public class UniformPaletteQuantizer
extends ImageToImageOperation
implements RGBIndex,
RGBQuantizer {
    private final int RED_BITS;
    private final int RED_LEFT_SHIFT;
    private final int RED_RIGHT_SHIFT;
    private final int[] RED_VALUES;
    private final int GREEN_BITS;
    private final int GREEN_LEFT_SHIFT;
    private final int GREEN_RIGHT_SHIFT;
    private final int[] GREEN_VALUES;
    private final int BLUE_BITS;
    private final int BLUE_RIGHT_SHIFT;
    private final int[] BLUE_VALUES;
    private final int TOTAL_BITS;
    private int[] PALETTE_RED;
    private int[] PALETTE_GREEN;
    private int[] PALETTE_BLUE;

    public UniformPaletteQuantizer(int redBits, int greenBits, int blueBits) {
        if (redBits < 1) {
            throw new IllegalArgumentException("Must have at least 1 bit for red.");
        }
        if (greenBits < 1) {
            throw new IllegalArgumentException("Must have at least 1 bit for green.");
        }
        if (blueBits < 1) {
            throw new IllegalArgumentException("Must have at least 1 bit for blue.");
        }
        this.BLUE_BITS = blueBits;
        this.BLUE_RIGHT_SHIFT = 8 - this.BLUE_BITS;
        this.BLUE_VALUES = new int[1 << this.BLUE_BITS];
        int i = 0;
        while (i < this.BLUE_VALUES.length) {
            this.BLUE_VALUES[i] = i * 255 / (this.BLUE_VALUES.length - 1);
            ++i;
        }
        this.GREEN_BITS = greenBits;
        this.GREEN_RIGHT_SHIFT = 8 - this.GREEN_BITS;
        this.GREEN_LEFT_SHIFT = this.BLUE_BITS;
        this.GREEN_VALUES = new int[1 << this.GREEN_BITS];
        i = 0;
        while (i < this.GREEN_VALUES.length) {
            this.GREEN_VALUES[i] = i * 255 / (this.GREEN_VALUES.length - 1);
            ++i;
        }
        this.RED_BITS = redBits;
        this.RED_RIGHT_SHIFT = 8 - this.RED_BITS;
        this.RED_LEFT_SHIFT = this.GREEN_BITS + this.BLUE_BITS;
        this.RED_VALUES = new int[1 << this.RED_BITS];
        i = 0;
        while (i < this.RED_VALUES.length) {
            this.RED_VALUES[i] = i * 255 / (this.RED_VALUES.length - 1);
            ++i;
        }
        this.TOTAL_BITS = this.RED_BITS + this.GREEN_BITS + this.BLUE_BITS;
        if (this.TOTAL_BITS > 8) {
            throw new IllegalArgumentException("Sum of red / green / blue bits must not exceed 8.");
        }
    }

    @Override
    public Palette createPalette() {
        int numEntries = 1 << this.TOTAL_BITS;
        Palette result = new Palette(numEntries, 255);
        this.PALETTE_RED = new int[numEntries];
        this.PALETTE_GREEN = new int[numEntries];
        this.PALETTE_BLUE = new int[numEntries];
        int index = 0;
        int r = 0;
        while (r < 1 << this.RED_BITS) {
            int g = 0;
            while (g < 1 << this.GREEN_BITS) {
                int b = 0;
                while (b < 1 << this.BLUE_BITS) {
                    result.putSample(0, index, this.RED_VALUES[r]);
                    this.PALETTE_RED[index] = this.RED_VALUES[r];
                    result.putSample(1, index, this.GREEN_VALUES[g]);
                    this.PALETTE_GREEN[index] = this.GREEN_VALUES[g];
                    result.putSample(2, index, this.BLUE_VALUES[b]);
                    this.PALETTE_BLUE[index] = this.BLUE_VALUES[b];
                    ++index;
                    ++b;
                }
                ++g;
            }
            ++r;
        }
        return result;
    }

    @Override
    public int map(int[] origRgb, int[] quantizedRgb) {
        int index = this.mapToIndex(origRgb[0], origRgb[1], origRgb[2]);
        quantizedRgb[0] = this.PALETTE_RED[index];
        quantizedRgb[1] = this.PALETTE_GREEN[index];
        quantizedRgb[2] = this.PALETTE_BLUE[index];
        return index;
    }

    public final int mapToIndex(int red, int green, int blue) {
        return red >> this.RED_RIGHT_SHIFT << this.RED_LEFT_SHIFT | green >> this.GREEN_RIGHT_SHIFT << this.GREEN_LEFT_SHIFT | blue >> this.BLUE_RIGHT_SHIFT;
    }

    private void process(RGB24Image in, Paletted8Image out) {
        int WIDTH = in.getWidth();
        int HEIGHT = in.getHeight();
        if (out == null) {
            out = new MemoryPaletted8Image(WIDTH, HEIGHT, this.createPalette());
        }
        int y = 0;
        while (y < HEIGHT) {
            int x = 0;
            while (x < WIDTH) {
                int r = in.getSample(0, x, y);
                int g = in.getSample(1, x, y);
                int b = in.getSample(2, x, y);
                out.putSample(0, x, y, this.mapToIndex(r, g, b));
                ++x;
            }
            this.setProgress(y, HEIGHT);
            ++y;
        }
        this.setOutputImage(out);
    }

    @Override
    public void process() {
        this.process((RGB24Image)this.getInputImage(), (Paletted8Image)this.getOutputImage());
    }
}

