/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.quantization;

import net.sourceforge.jiu.color.analysis.Histogram3DCreator;
import net.sourceforge.jiu.color.data.Histogram3D;
import net.sourceforge.jiu.color.quantization.ArbitraryPaletteQuantizer;
import net.sourceforge.jiu.color.quantization.RGBColor;
import net.sourceforge.jiu.color.quantization.RGBColorList;
import net.sourceforge.jiu.color.quantization.RGBQuantizer;
import net.sourceforge.jiu.data.IntegerImage;
import net.sourceforge.jiu.data.Palette;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.data.RGB24Image;
import net.sourceforge.jiu.data.RGBIndex;
import net.sourceforge.jiu.ops.ImageToImageOperation;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.OperationFailedException;
import net.sourceforge.jiu.ops.WrongParameterException;

public class PopularityQuantizer
extends ImageToImageOperation
implements RGBIndex,
RGBQuantizer {
    private ArbitraryPaletteQuantizer arbQuantizer;
    private int paletteSize;
    private Palette palette;
    private boolean doNotMap;

    @Override
    public Palette createPalette() {
        if (this.palette == null) {
            try {
                this.palette = this.determinePalette();
                return (Palette)this.palette.clone();
            }
            catch (OperationFailedException ofe) {
                return null;
            }
        }
        return (Palette)this.palette.clone();
    }

    private Palette determinePalette() throws OperationFailedException {
        Histogram3DCreator hc = new Histogram3DCreator();
        hc.setImage((IntegerImage)this.getInputImage(), 0, 1, 2);
        hc.process();
        Histogram3D hist = hc.getHistogram();
        if (hist == null) {
            throw new OperationFailedException("Could not create histogram from input image.");
        }
        int numUniqueColors = hist.getNumUsedEntries();
        if (numUniqueColors <= this.paletteSize) {
            this.paletteSize = numUniqueColors;
        }
        RGBColorList list = new RGBColorList(hist);
        list.sortByCounter(0, list.getNumEntries() - 1);
        Palette result = new Palette(this.paletteSize);
        int paletteIndex = this.paletteSize - 1;
        int listIndex = list.getNumEntries() - 1;
        while (paletteIndex >= 0) {
            RGBColor color = list.getColor(listIndex--);
            result.put(paletteIndex--, color.getSample(0), color.getSample(1), color.getSample(2));
        }
        return result;
    }

    public int getPaletteSize() {
        return this.paletteSize;
    }

    @Override
    public int map(int[] origRgb, int[] quantizedRgb) {
        return this.arbQuantizer.map(origRgb, quantizedRgb);
    }

    @Override
    public void process() throws MissingParameterException, OperationFailedException, WrongParameterException {
        this.ensureInputImageIsAvailable();
        this.ensureImagesHaveSameResolution();
        PixelImage in = this.getInputImage();
        if (!(in instanceof RGB24Image)) {
            throw new WrongParameterException("Input image must implement RGB24Image.");
        }
        Histogram3DCreator hc = new Histogram3DCreator();
        hc.setImage((IntegerImage)in, 0, 1, 2);
        hc.process();
        Histogram3D hist = hc.getHistogram();
        if (hist == null) {
            throw new OperationFailedException("Could not create histogram from input image.");
        }
        int numUniqueColors = hist.getNumUsedEntries();
        if (numUniqueColors <= this.paletteSize) {
            this.paletteSize = numUniqueColors;
        }
        this.arbQuantizer = new ArbitraryPaletteQuantizer(this.createPalette());
        if (!this.doNotMap) {
            this.arbQuantizer.setInputImage(in);
            this.arbQuantizer.setOutputImage(this.getOutputImage());
            this.arbQuantizer.process();
            this.setOutputImage(this.arbQuantizer.getOutputImage());
        }
    }

    public void setMapping(boolean newValue) {
        this.doNotMap = !newValue;
    }

    public void setPaletteSize(int newPaletteSize) {
        if (newPaletteSize < 1) {
            throw new IllegalArgumentException("Palette size must be 1 or larger.");
        }
        if (newPaletteSize > 256) {
            throw new IllegalArgumentException("Palette size must be at most 256.");
        }
        this.paletteSize = newPaletteSize;
    }
}

