/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.quantization;

import net.sourceforge.jiu.color.quantization.RGBQuantizer;
import net.sourceforge.jiu.data.MemoryPaletted8Image;
import net.sourceforge.jiu.data.Palette;
import net.sourceforge.jiu.data.Paletted8Image;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.data.RGB24Image;
import net.sourceforge.jiu.data.RGBIndex;
import net.sourceforge.jiu.ops.ImageToImageOperation;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.WrongParameterException;

public class ArbitraryPaletteQuantizer
extends ImageToImageOperation
implements RGBIndex,
RGBQuantizer {
    private final int[] RED;
    private final int[] GREEN;
    private final int[] BLUE;
    private Palette palette;
    private int numEntries;

    public ArbitraryPaletteQuantizer(Palette palette) {
        this.palette = palette;
        this.numEntries = palette.getNumEntries();
        this.RED = new int[this.numEntries];
        this.GREEN = new int[this.numEntries];
        this.BLUE = new int[this.numEntries];
        int i = 0;
        while (i < this.numEntries) {
            this.RED[i] = palette.getSample(0, i);
            this.GREEN[i] = palette.getSample(1, i);
            this.BLUE[i] = palette.getSample(2, i);
            ++i;
        }
    }

    @Override
    public Palette createPalette() {
        return (Palette)this.palette.clone();
    }

    @Override
    public int map(int[] origRgb, int[] quantizedRgb) {
        int r = origRgb[0];
        int g = origRgb[1];
        int b = origRgb[2];
        int minIndex = 0;
        int minDistance = Integer.MAX_VALUE;
        int index = 0;
        while (index < this.numEntries) {
            int v = r - this.RED[index];
            int distance = v * v;
            v = g - this.GREEN[index];
            distance += v * v;
            v = b - this.BLUE[index];
            if ((distance += v * v) < minDistance) {
                minDistance = distance;
                minIndex = index;
            }
            ++index;
        }
        quantizedRgb[0] = this.RED[minIndex];
        quantizedRgb[1] = this.GREEN[minIndex];
        quantizedRgb[2] = this.BLUE[minIndex];
        return minIndex;
    }

    public int map(int red, int green, int blue) {
        int minIndex = 0;
        int minDistance = Integer.MAX_VALUE;
        int index = 0;
        while (index < this.numEntries) {
            int v = red - this.RED[index];
            int distance = v * v;
            v = green - this.GREEN[index];
            distance += v * v;
            v = blue - this.BLUE[index];
            if ((distance += v * v) < minDistance) {
                minDistance = distance;
                minIndex = index;
            }
            ++index;
        }
        return minIndex;
    }

    private void process(RGB24Image in, Paletted8Image out) {
        int WIDTH = in.getWidth();
        int HEIGHT = in.getHeight();
        if (out == null) {
            out = new MemoryPaletted8Image(WIDTH, HEIGHT, this.createPalette());
        }
        int y = 0;
        while (y < HEIGHT) {
            int x = 0;
            while (x < WIDTH) {
                out.putSample(0, x, y, this.map(in.getSample(0, x, y), in.getSample(1, x, y), in.getSample(2, x, y)));
                ++x;
            }
            this.setProgress(y, HEIGHT);
            ++y;
        }
        this.setOutputImage(out);
    }

    @Override
    public void process() throws MissingParameterException, WrongParameterException {
        this.ensureInputImageIsAvailable();
        PixelImage in = this.getInputImage();
        if (!(in instanceof RGB24Image)) {
            throw new WrongParameterException("Input image must be of type RGB24Image.");
        }
        PixelImage out = this.getOutputImage();
        if (out != null && !(out instanceof Paletted8Image)) {
            throw new WrongParameterException("Output image must be of type Paletted8Image.");
        }
        this.process((RGB24Image)in, (Paletted8Image)out);
    }
}

