/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.promotion;

import net.sourceforge.jiu.data.BilevelImage;
import net.sourceforge.jiu.data.Gray8Image;
import net.sourceforge.jiu.data.MemoryGray8Image;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.ops.ImageToImageOperation;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.WrongParameterException;

public class PromotionGray8
extends ImageToImageOperation {
    private void prepare(PixelImage in) throws MissingParameterException, WrongParameterException {
        if (in == null) {
            throw new MissingParameterException("Missing input image.");
        }
        if (!(in instanceof BilevelImage)) {
            throw new WrongParameterException("Unsupported input image type: " + in.getClass().getName());
        }
        PixelImage out = this.getOutputImage();
        if (out == null) {
            this.setOutputImage(new MemoryGray8Image(in.getWidth(), in.getHeight()));
        } else {
            if (!(out instanceof Gray8Image)) {
                throw new WrongParameterException("Specified output image type must be of class Gray8Image; got " + in.getClass().getName());
            }
            if (in.getWidth() != out.getWidth()) {
                throw new WrongParameterException("Specified output image must have same width as input image.");
            }
            if (in.getHeight() != out.getHeight()) {
                throw new WrongParameterException("Specified output image must have same height as input image.");
            }
        }
    }

    private void process(BilevelImage in, Gray8Image out) {
        int WIDTH = in.getWidth();
        int HEIGHT = in.getHeight();
        int MAX = -1;
        boolean MIN = false;
        int y = 0;
        while (y < HEIGHT) {
            int x = 0;
            while (x < WIDTH) {
                if (in.isBlack(x, y)) {
                    out.putByteSample(0, x, y, (byte)0);
                } else {
                    out.putByteSample(0, x, y, (byte)-1);
                }
                ++x;
            }
            this.setProgress(y, HEIGHT);
            ++y;
        }
    }

    @Override
    public void process() throws MissingParameterException, WrongParameterException {
        PixelImage in = this.getInputImage();
        this.prepare(in);
        Gray8Image out = (Gray8Image)this.getOutputImage();
        if (in instanceof BilevelImage) {
            this.process((BilevelImage)in, out);
        }
    }
}

