/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.dithering;

import net.sourceforge.jiu.color.quantization.RGBQuantizer;
import net.sourceforge.jiu.data.BilevelImage;
import net.sourceforge.jiu.data.Gray8Image;
import net.sourceforge.jiu.data.IntegerImage;
import net.sourceforge.jiu.data.MemoryBilevelImage;
import net.sourceforge.jiu.data.MemoryGray8Image;
import net.sourceforge.jiu.data.MemoryPaletted8Image;
import net.sourceforge.jiu.data.Paletted8Image;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.data.RGB24Image;
import net.sourceforge.jiu.data.RGBIndex;
import net.sourceforge.jiu.ops.ImageToImageOperation;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.WrongParameterException;

public class ErrorDiffusionDithering
extends ImageToImageOperation
implements RGBIndex {
    public static final int TYPE_FLOYD_STEINBERG = 0;
    public static final int TYPE_STUCKI = 1;
    public static final int TYPE_BURKES = 2;
    public static final int TYPE_SIERRA = 3;
    public static final int TYPE_JARVIS_JUDICE_NINKE = 4;
    public static final int TYPE_STEVENSON_ARCE = 5;
    public static final int DEFAULT_TYPE = 0;
    public static final int INDEX_X_POS = 0;
    public static final int INDEX_Y_POS = 1;
    public static final int INDEX_ERROR_NUMERATOR = 2;
    public static final int INDEX_ERROR_DENOMINATOR = 3;
    private static final int[][] FLOYD_STEINBERG_DATA;
    private static final int[][] STUCKI_DATA;
    private static final int[][] BURKES_DATA;
    private static final int[][] SIERRA_DATA;
    private static final int[][] JARVIS_JUDICE_NINKE_DATA;
    private static final int[][] STEVENSON_ARCE_DATA;
    private int grayBits;
    private int imageWidth;
    private int leftColumns;
    private int rightColumns;
    private int newWidth;
    private int numRows;
    private int[][] templateData;
    private int[] errorNum;
    private int[] errorDen;
    private int[] indexLut;
    private RGBQuantizer quantizer;
    private boolean useTruecolorOutput;

    static {
        int[][] nArrayArray = new int[4][];
        int[] nArray = new int[4];
        nArray[0] = 1;
        nArray[2] = 7;
        nArray[3] = 16;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[]{-1, 1, 3, 16};
        int[] nArray2 = new int[4];
        nArray2[1] = 1;
        nArray2[2] = 5;
        nArray2[3] = 16;
        nArrayArray[2] = nArray2;
        nArrayArray[3] = new int[]{1, 1, 1, 16};
        FLOYD_STEINBERG_DATA = nArrayArray;
        int[][] nArrayArray2 = new int[12][];
        int[] nArray3 = new int[4];
        nArray3[0] = 1;
        nArray3[2] = 8;
        nArray3[3] = 42;
        nArrayArray2[0] = nArray3;
        int[] nArray4 = new int[4];
        nArray4[0] = 2;
        nArray4[2] = 4;
        nArray4[3] = 42;
        nArrayArray2[1] = nArray4;
        nArrayArray2[2] = new int[]{-2, 1, 2, 42};
        nArrayArray2[3] = new int[]{-1, 1, 4, 42};
        int[] nArray5 = new int[4];
        nArray5[1] = 1;
        nArray5[2] = 8;
        nArray5[3] = 42;
        nArrayArray2[4] = nArray5;
        nArrayArray2[5] = new int[]{1, 1, 4, 42};
        nArrayArray2[6] = new int[]{2, 1, 2, 42};
        nArrayArray2[7] = new int[]{-2, 2, 1, 42};
        nArrayArray2[8] = new int[]{-1, 2, 2, 42};
        int[] nArray6 = new int[4];
        nArray6[1] = 2;
        nArray6[2] = 4;
        nArray6[3] = 42;
        nArrayArray2[9] = nArray6;
        nArrayArray2[10] = new int[]{1, 2, 2, 42};
        nArrayArray2[11] = new int[]{2, 2, 1, 42};
        STUCKI_DATA = nArrayArray2;
        int[][] nArrayArray3 = new int[7][];
        int[] nArray7 = new int[4];
        nArray7[0] = 1;
        nArray7[2] = 8;
        nArray7[3] = 32;
        nArrayArray3[0] = nArray7;
        int[] nArray8 = new int[4];
        nArray8[0] = 2;
        nArray8[2] = 4;
        nArray8[3] = 32;
        nArrayArray3[1] = nArray8;
        nArrayArray3[2] = new int[]{-2, 1, 2, 32};
        nArrayArray3[3] = new int[]{-1, 1, 4, 32};
        int[] nArray9 = new int[4];
        nArray9[1] = 1;
        nArray9[2] = 8;
        nArray9[3] = 32;
        nArrayArray3[4] = nArray9;
        nArrayArray3[5] = new int[]{1, 1, 4, 32};
        nArrayArray3[6] = new int[]{2, 1, 2, 32};
        BURKES_DATA = nArrayArray3;
        int[][] nArrayArray4 = new int[10][];
        int[] nArray10 = new int[4];
        nArray10[0] = 1;
        nArray10[2] = 5;
        nArray10[3] = 32;
        nArrayArray4[0] = nArray10;
        nArrayArray4[1] = new int[]{2, 1, 3, 32};
        nArrayArray4[2] = new int[]{-2, 1, 2, 32};
        nArrayArray4[3] = new int[]{-1, 1, 4, 32};
        int[] nArray11 = new int[4];
        nArray11[1] = 1;
        nArray11[2] = 5;
        nArray11[3] = 32;
        nArrayArray4[4] = nArray11;
        nArrayArray4[5] = new int[]{1, 1, 4, 32};
        nArrayArray4[6] = new int[]{2, 1, 2, 32};
        nArrayArray4[7] = new int[]{-1, 2, 2, 32};
        int[] nArray12 = new int[4];
        nArray12[1] = 2;
        nArray12[2] = 3;
        nArray12[3] = 32;
        nArrayArray4[8] = nArray12;
        nArrayArray4[9] = new int[]{1, 2, 2, 32};
        SIERRA_DATA = nArrayArray4;
        int[][] nArrayArray5 = new int[12][];
        int[] nArray13 = new int[4];
        nArray13[0] = 1;
        nArray13[2] = 7;
        nArray13[3] = 48;
        nArrayArray5[0] = nArray13;
        int[] nArray14 = new int[4];
        nArray14[0] = 2;
        nArray14[2] = 5;
        nArray14[3] = 48;
        nArrayArray5[1] = nArray14;
        nArrayArray5[2] = new int[]{-2, 1, 3, 48};
        nArrayArray5[3] = new int[]{-1, 1, 5, 48};
        int[] nArray15 = new int[4];
        nArray15[1] = 1;
        nArray15[2] = 7;
        nArray15[3] = 48;
        nArrayArray5[4] = nArray15;
        nArrayArray5[5] = new int[]{1, 1, 5, 48};
        nArrayArray5[6] = new int[]{2, 1, 3, 48};
        nArrayArray5[7] = new int[]{-2, 2, 1, 48};
        nArrayArray5[8] = new int[]{-1, 2, 3, 48};
        int[] nArray16 = new int[4];
        nArray16[1] = 2;
        nArray16[2] = 5;
        nArray16[3] = 48;
        nArrayArray5[9] = nArray16;
        nArrayArray5[10] = new int[]{1, 2, 3, 48};
        nArrayArray5[11] = new int[]{2, 2, 1, 48};
        JARVIS_JUDICE_NINKE_DATA = nArrayArray5;
        int[][] nArrayArray6 = new int[12][];
        int[] nArray17 = new int[4];
        nArray17[0] = 2;
        nArray17[2] = 32;
        nArray17[3] = 200;
        nArrayArray6[0] = nArray17;
        nArrayArray6[1] = new int[]{-3, 1, 12, 200};
        nArrayArray6[2] = new int[]{-1, 1, 26, 200};
        nArrayArray6[3] = new int[]{1, 1, 30, 200};
        nArrayArray6[4] = new int[]{3, 1, 16, 200};
        nArrayArray6[5] = new int[]{-2, 2, 12, 200};
        int[] nArray18 = new int[4];
        nArray18[1] = 2;
        nArray18[2] = 26;
        nArray18[3] = 200;
        nArrayArray6[6] = nArray18;
        nArrayArray6[7] = new int[]{2, 2, 12, 200};
        nArrayArray6[8] = new int[]{-3, 3, 5, 200};
        nArrayArray6[9] = new int[]{-1, 3, 12, 200};
        nArrayArray6[10] = new int[]{1, 3, 12, 200};
        nArrayArray6[11] = new int[]{3, 3, 5, 200};
        STEVENSON_ARCE_DATA = nArrayArray6;
    }

    public ErrorDiffusionDithering() {
        this.setTemplateType(0);
    }

    private static int adjust(int value, int max) {
        if (value <= 0) {
            return 0;
        }
        if (value >= max) {
            return max;
        }
        return value;
    }

    private void fillBuffer(int channelIndex, int rowIndex, int[] dest, int destOffset) {
        IntegerImage in = (IntegerImage)this.getInputImage();
        int LAST = destOffset + this.imageWidth;
        int x = 0;
        while (destOffset != LAST) {
            dest[destOffset++] = in.getSample(channelIndex, x++, rowIndex);
        }
    }

    private void init(int[][] data, int imageWidth) {
        if (data == null) {
            throw new IllegalArgumentException("Data must not be null.");
        }
        if (imageWidth < 1) {
            throw new IllegalArgumentException("Image width must be larger than 0.");
        }
        this.imageWidth = imageWidth;
        this.leftColumns = 0;
        this.rightColumns = 0;
        this.numRows = 1;
        this.errorNum = new int[data.length];
        this.errorDen = new int[data.length];
        int i = 0;
        while (i < data.length) {
            int y;
            if (data[i] == null) {
                throw new IllegalArgumentException("Each int[] array of data must be initialized; array #" + i + " is not.");
            }
            if (data[i].length != 4) {
                throw new IllegalArgumentException("Each int[] array of data must be of length 4; array #" + i + " has length " + data[i].length + ".");
            }
            int x = data[i][0];
            if (x < 0) {
                if ((x = -x) > this.leftColumns) {
                    this.leftColumns = x;
                }
            } else if (x > 0 && x > this.rightColumns) {
                this.rightColumns = x;
            }
            if ((y = data[i][1]) < 0) {
                throw new IllegalArgumentException("The y values must be >= 0; that is not true for array index #" + i + ".");
            }
            if (y > this.numRows - 1) {
                this.numRows = y + 1;
            }
            if (x <= 0 && y == 0) {
                throw new IllegalArgumentException("If y is equal to 0, x must not be <= 0; this is true for array index #" + i + ".");
            }
            if (data[i][2] == 0 || data[i][3] == 0) {
                throw new IllegalArgumentException("Neither numerator nor denominator can be 0; this is the case for array index #" + i + ".");
            }
            this.errorNum[i] = data[i][2];
            this.errorDen[i] = data[i][3];
            ++i;
        }
        this.newWidth = imageWidth + this.leftColumns + this.rightColumns;
        this.indexLut = new int[data.length];
        i = 0;
        while (i < this.indexLut.length) {
            this.indexLut[i] = data[i][1] * this.newWidth + data[i][0];
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void process() throws MissingParameterException, WrongParameterException {
        this.ensureInputImageIsAvailable();
        this.ensureImagesHaveSameResolution();
        PixelImage in = this.getInputImage();
        PixelImage out = this.getOutputImage();
        if (in instanceof Gray8Image) {
            this.init(this.templateData, in.getWidth());
            if (this.grayBits == 1) {
                this.process((Gray8Image)in, (BilevelImage)out);
                return;
            } else {
                if (this.grayBits <= 1 || this.grayBits >= 8) throw new WrongParameterException("Cannot handle gray bits other than 1..7.");
                this.process((Gray8Image)in, (Gray8Image)out);
            }
            return;
        } else {
            if (!(in instanceof RGB24Image)) throw new WrongParameterException("Cannot handle this image: " + in.toString());
            this.init(this.templateData, in.getWidth());
            if (this.quantizer == null) {
                throw new MissingParameterException("No quantizer was specified.");
            }
            if (this.useTruecolorOutput) {
                this.process((RGB24Image)in, (RGB24Image)out);
                return;
            } else {
                this.process((RGB24Image)in, (Paletted8Image)out);
            }
        }
    }

    private void process(Gray8Image in, BilevelImage out) {
        int HEIGHT = in.getHeight();
        int WIDTH = in.getWidth();
        if (out == null) {
            out = new MemoryBilevelImage(WIDTH, HEIGHT);
        }
        int NUM_ERROR_PIXELS = this.errorNum.length;
        int[] buffer = new int[this.newWidth * this.numRows];
        int n = Math.min(this.numRows, HEIGHT);
        int offset = this.leftColumns;
        int bufferYIndex = 0;
        while (n-- > 0) {
            this.fillBuffer(0, bufferYIndex++, buffer, offset);
            offset += this.newWidth;
        }
        int bufferLastRowOffset = offset - this.newWidth;
        out.clear(0);
        int y = 0;
        while (y < HEIGHT) {
            int bufferIndex = this.leftColumns;
            int x = 0;
            while (x < WIDTH) {
                int error;
                int value = buffer[bufferIndex];
                if (value < 0) {
                    value = 0;
                } else if (value > 255) {
                    value = 255;
                }
                if ((value & 0x80) == 0) {
                    error = value;
                } else {
                    out.putWhite(x, y);
                    error = value - 255;
                }
                int i = 0;
                while (i < NUM_ERROR_PIXELS) {
                    int errorPart = error * this.errorNum[i] / this.errorDen[i];
                    int n2 = bufferIndex + this.indexLut[i];
                    buffer[n2] = buffer[n2] + errorPart;
                    ++i;
                }
                ++bufferIndex;
                ++x;
            }
            int i = 0;
            int j = this.newWidth;
            while (j < buffer.length) {
                buffer[i] = buffer[j];
                ++i;
                ++j;
            }
            if (bufferYIndex < HEIGHT) {
                this.fillBuffer(0, bufferYIndex++, buffer, bufferLastRowOffset);
            }
            this.setProgress(y, HEIGHT);
            ++y;
        }
        this.setOutputImage(out);
    }

    private void process(Gray8Image in, Gray8Image out) {
        int HEIGHT = in.getHeight();
        int WIDTH = in.getWidth();
        int RIGHT_SHIFT = 8 - this.grayBits;
        int[] GRAY_LUT = new int[1 << this.grayBits];
        int i = 0;
        while (i < GRAY_LUT.length) {
            GRAY_LUT[i] = i * 255 / (GRAY_LUT.length - 1);
            ++i;
        }
        if (out == null) {
            out = new MemoryGray8Image(WIDTH, HEIGHT);
        }
        int NUM_ERROR_PIXELS = this.errorNum.length;
        int[] buffer = new int[this.newWidth * this.numRows];
        int n = Math.min(this.numRows, HEIGHT);
        int offset = this.leftColumns;
        int bufferYIndex = 0;
        while (n-- > 0) {
            this.fillBuffer(0, bufferYIndex++, buffer, offset);
            offset += this.newWidth;
        }
        int bufferLastRowOffset = offset - this.newWidth;
        int y = 0;
        while (y < HEIGHT) {
            int bufferIndex = this.leftColumns;
            int x = 0;
            while (x < WIDTH) {
                int value = buffer[bufferIndex];
                if (value < 0) {
                    value = 0;
                } else if (value > 255) {
                    value = 255;
                }
                int quantized = GRAY_LUT[value >> RIGHT_SHIFT];
                out.putSample(0, x, y, quantized);
                int error = value - quantized;
                int i2 = 0;
                while (i2 < NUM_ERROR_PIXELS) {
                    int errorPart = error * this.errorNum[i2] / this.errorDen[i2];
                    int n2 = bufferIndex + this.indexLut[i2];
                    buffer[n2] = buffer[n2] + errorPart;
                    ++i2;
                }
                ++bufferIndex;
                ++x;
            }
            int i3 = 0;
            int j = this.newWidth;
            while (j < buffer.length) {
                buffer[i3] = buffer[j];
                ++i3;
                ++j;
            }
            if (bufferYIndex < HEIGHT) {
                this.fillBuffer(0, bufferYIndex++, buffer, bufferLastRowOffset);
            }
            this.setProgress(y, HEIGHT);
            ++y;
        }
        this.setOutputImage(out);
    }

    private void process(RGB24Image in, Paletted8Image out) {
        int HEIGHT = in.getHeight();
        int WIDTH = in.getWidth();
        int MAX = 255;
        if (out == null) {
            out = new MemoryPaletted8Image(WIDTH, HEIGHT, this.quantizer.createPalette());
        }
        int NUM_ERROR_PIXELS = this.errorNum.length;
        int[] redBuffer = new int[this.newWidth * this.numRows];
        int[] greenBuffer = new int[this.newWidth * this.numRows];
        int[] blueBuffer = new int[this.newWidth * this.numRows];
        int n = Math.min(this.numRows, HEIGHT);
        int offset = this.leftColumns;
        int bufferYIndex = 0;
        while (n-- > 0) {
            this.fillBuffer(0, bufferYIndex, redBuffer, offset);
            this.fillBuffer(1, bufferYIndex, greenBuffer, offset);
            this.fillBuffer(2, bufferYIndex++, blueBuffer, offset);
            offset += this.newWidth;
        }
        int bufferLastRowOffset = offset - this.newWidth;
        int[] originalRgb = new int[3];
        int[] quantizedRgb = new int[3];
        int y = 0;
        while (y < HEIGHT) {
            int bufferIndex = this.leftColumns;
            int x = 0;
            while (x < WIDTH) {
                int errorPart;
                originalRgb[0] = ErrorDiffusionDithering.adjust(redBuffer[bufferIndex], 255);
                originalRgb[1] = ErrorDiffusionDithering.adjust(greenBuffer[bufferIndex], 255);
                originalRgb[2] = ErrorDiffusionDithering.adjust(blueBuffer[bufferIndex], 255);
                int paletteIndex = this.quantizer.map(originalRgb, quantizedRgb);
                out.putSample(0, x, y, paletteIndex);
                int error = originalRgb[0] - quantizedRgb[0];
                int i = 0;
                while (i < NUM_ERROR_PIXELS) {
                    errorPart = error * this.errorNum[i] / this.errorDen[i];
                    int n2 = bufferIndex + this.indexLut[i];
                    redBuffer[n2] = redBuffer[n2] + errorPart;
                    ++i;
                }
                error = originalRgb[1] - quantizedRgb[1];
                i = 0;
                while (i < NUM_ERROR_PIXELS) {
                    errorPart = error * this.errorNum[i] / this.errorDen[i];
                    int n3 = bufferIndex + this.indexLut[i];
                    greenBuffer[n3] = greenBuffer[n3] + errorPart;
                    ++i;
                }
                error = originalRgb[2] - quantizedRgb[2];
                i = 0;
                while (i < NUM_ERROR_PIXELS) {
                    errorPart = error * this.errorNum[i] / this.errorDen[i];
                    int n4 = bufferIndex + this.indexLut[i];
                    blueBuffer[n4] = blueBuffer[n4] + errorPart;
                    ++i;
                }
                ++bufferIndex;
                ++x;
            }
            System.arraycopy(redBuffer, this.newWidth, redBuffer, 0, redBuffer.length - this.newWidth);
            System.arraycopy(greenBuffer, this.newWidth, greenBuffer, 0, greenBuffer.length - this.newWidth);
            System.arraycopy(blueBuffer, this.newWidth, blueBuffer, 0, blueBuffer.length - this.newWidth);
            if (bufferYIndex < HEIGHT) {
                this.fillBuffer(0, bufferYIndex, redBuffer, bufferLastRowOffset);
                this.fillBuffer(1, bufferYIndex, greenBuffer, bufferLastRowOffset);
                this.fillBuffer(2, bufferYIndex++, blueBuffer, bufferLastRowOffset);
            }
            this.setProgress(y, HEIGHT);
            ++y;
        }
        this.setOutputImage(out);
    }

    private void process(RGB24Image in, RGB24Image out) {
        int HEIGHT = in.getHeight();
        int WIDTH = in.getWidth();
        int MAX = 255;
        if (out == null) {
            out = (RGB24Image)in.createCompatibleImage(WIDTH, HEIGHT);
        }
        int NUM_ERROR_PIXELS = this.errorNum.length;
        int[] redBuffer = new int[this.newWidth * this.numRows];
        int[] greenBuffer = new int[this.newWidth * this.numRows];
        int[] blueBuffer = new int[this.newWidth * this.numRows];
        int n = Math.min(this.numRows, HEIGHT);
        int offset = this.leftColumns;
        int bufferYIndex = 0;
        while (n-- > 0) {
            this.fillBuffer(0, bufferYIndex, redBuffer, offset);
            this.fillBuffer(1, bufferYIndex, greenBuffer, offset);
            this.fillBuffer(2, bufferYIndex++, blueBuffer, offset);
            offset += this.newWidth;
        }
        int bufferLastRowOffset = offset - this.newWidth;
        int[] originalRgb = new int[3];
        int[] quantizedRgb = new int[3];
        int y = 0;
        while (y < HEIGHT) {
            int bufferIndex = this.leftColumns;
            int x = 0;
            while (x < WIDTH) {
                int errorPart;
                originalRgb[0] = ErrorDiffusionDithering.adjust(redBuffer[bufferIndex], 255);
                originalRgb[1] = ErrorDiffusionDithering.adjust(greenBuffer[bufferIndex], 255);
                originalRgb[2] = ErrorDiffusionDithering.adjust(blueBuffer[bufferIndex], 255);
                out.putSample(0, x, y, quantizedRgb[0]);
                out.putSample(1, x, y, quantizedRgb[1]);
                out.putSample(2, x, y, quantizedRgb[2]);
                int error = originalRgb[0] - quantizedRgb[0];
                int i = 0;
                while (i < NUM_ERROR_PIXELS) {
                    errorPart = error * this.errorNum[i] / this.errorDen[i];
                    int n2 = bufferIndex + this.indexLut[i];
                    redBuffer[n2] = redBuffer[n2] + errorPart;
                    ++i;
                }
                error = originalRgb[1] - quantizedRgb[1];
                i = 0;
                while (i < NUM_ERROR_PIXELS) {
                    errorPart = error * this.errorNum[i] / this.errorDen[i];
                    int n3 = bufferIndex + this.indexLut[i];
                    greenBuffer[n3] = greenBuffer[n3] + errorPart;
                    ++i;
                }
                error = originalRgb[2] - quantizedRgb[2];
                i = 0;
                while (i < NUM_ERROR_PIXELS) {
                    errorPart = error * this.errorNum[i] / this.errorDen[i];
                    int n4 = bufferIndex + this.indexLut[i];
                    blueBuffer[n4] = blueBuffer[n4] + errorPart;
                    ++i;
                }
                ++bufferIndex;
                ++x;
            }
            System.arraycopy(redBuffer, this.newWidth, redBuffer, 0, redBuffer.length - this.newWidth);
            System.arraycopy(greenBuffer, this.newWidth, greenBuffer, 0, greenBuffer.length - this.newWidth);
            System.arraycopy(blueBuffer, this.newWidth, blueBuffer, 0, blueBuffer.length - this.newWidth);
            if (bufferYIndex < HEIGHT) {
                this.fillBuffer(0, bufferYIndex, redBuffer, bufferLastRowOffset);
                this.fillBuffer(1, bufferYIndex, greenBuffer, bufferLastRowOffset);
                this.fillBuffer(2, bufferYIndex++, blueBuffer, bufferLastRowOffset);
            }
            this.setProgress(y, HEIGHT);
            ++y;
        }
        this.setOutputImage(out);
    }

    public void setGrayscaleOutputBits(int numBits) {
        this.grayBits = numBits;
    }

    public void setQuantizer(RGBQuantizer q) {
        this.quantizer = q;
    }

    public void setTemplateData(int[][] data) {
        this.templateData = data;
    }

    public void setTruecolorOutput(boolean truecolor) {
        this.useTruecolorOutput = truecolor;
    }

    public void setTemplateType(int type) {
        switch (type) {
            case 0: {
                this.templateData = FLOYD_STEINBERG_DATA;
                break;
            }
            case 1: {
                this.templateData = STUCKI_DATA;
                break;
            }
            case 2: {
                this.templateData = BURKES_DATA;
                break;
            }
            case 3: {
                this.templateData = SIERRA_DATA;
                break;
            }
            case 4: {
                this.templateData = JARVIS_JUDICE_NINKE_DATA;
                break;
            }
            case 5: {
                this.templateData = STEVENSON_ARCE_DATA;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown template type: " + type + ".");
            }
        }
    }
}

