/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.dithering;

import net.sourceforge.jiu.color.dithering.SpotFunction;
import net.sourceforge.jiu.data.BilevelImage;
import net.sourceforge.jiu.data.GrayIntegerImage;
import net.sourceforge.jiu.data.MemoryBilevelImage;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.ops.ImageToImageOperation;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.WrongParameterException;
import net.sourceforge.jiu.util.ComparatorInterface;
import net.sourceforge.jiu.util.Sort;

public class ClusteredDotDither
extends ImageToImageOperation {
    private int ditherHeight;
    private int ditherWidth;
    private int[] ditherData;

    @Override
    public void process() throws MissingParameterException, WrongParameterException {
        if (this.ditherData == null) {
            this.setDefaults();
        }
        this.ensureInputImageIsAvailable();
        PixelImage in = this.getInputImage();
        if (!(in instanceof GrayIntegerImage)) {
            throw new WrongParameterException("Input image must implement GrayIntegerImage.");
        }
        PixelImage out = this.getOutputImage();
        if (out == null) {
            out = new MemoryBilevelImage(in.getWidth(), in.getHeight());
            this.setOutputImage(out);
        } else {
            if (!(out instanceof BilevelImage)) {
                throw new WrongParameterException("Output image must implement BilevelImage.");
            }
            this.ensureOutputImageResolution(in.getWidth(), in.getHeight());
        }
        this.process((GrayIntegerImage)in, (BilevelImage)out);
    }

    private void process(GrayIntegerImage in, BilevelImage out) {
        int maxTableValue = 1;
        int i = 0;
        while (i < this.ditherData.length) {
            if (this.ditherData[i] > maxTableValue) {
                maxTableValue = this.ditherData[i];
            }
            ++i;
        }
        ++maxTableValue;
        int MAX_SAMPLE = in.getMaxSample(0) + 1;
        int[] data = new int[this.ditherData.length];
        int i2 = 0;
        while (i2 < data.length) {
            data[i2] = this.ditherData[i2] * MAX_SAMPLE / maxTableValue;
            ++i2;
        }
        int HEIGHT = in.getHeight();
        int WIDTH = in.getWidth();
        int y = 0;
        while (y < HEIGHT) {
            int ditherOffset = y % this.ditherHeight * this.ditherWidth;
            int samplesLeft = this.ditherWidth;
            int x = 0;
            while (x < WIDTH) {
                if (in.getSample(0, x, y) >= data[ditherOffset++]) {
                    out.putWhite(x, y);
                } else {
                    out.putBlack(x, y);
                }
                if (--samplesLeft == 0) {
                    samplesLeft = this.ditherWidth;
                    ditherOffset -= this.ditherWidth;
                }
                ++x;
            }
            this.setProgress(y, HEIGHT);
            ++y;
        }
    }

    private void setDefaults() {
        this.setOrder3DitherMatrix();
    }

    public void setDitherMatrix(int width, int height, int[] data) {
        if (width < 1) {
            throw new IllegalArgumentException("Width must be one or larger.");
        }
        if (height < 1) {
            throw new IllegalArgumentException("Height must be one or larger.");
        }
        if (data == null) {
            throw new IllegalArgumentException("Data must not be null.");
        }
        if (data.length < width * height) {
            throw new IllegalArgumentException("Data must have at least width times height entries.");
        }
        this.ditherWidth = width;
        this.ditherHeight = height;
        this.ditherData = data;
    }

    public void setDitherMatrix(int width, int height, SpotFunction f) {
        int[] data = new int[width * height];
        class MatrixElement
        implements ComparatorInterface {
            int index;
            double value;

            MatrixElement() {
            }

            @Override
            public int compare(Object o1, Object o2) {
                MatrixElement e1 = (MatrixElement)o1;
                MatrixElement e2 = (MatrixElement)o2;
                if (e1.value < e2.value) {
                    return -1;
                }
                if (e1.value == e2.value) {
                    return 0;
                }
                return 1;
            }
        }
        Object[] matrixElements = new MatrixElement[data.length];
        int i = 0;
        while (i < data.length) {
            matrixElements[i] = new MatrixElement();
            matrixElements[i].index = i;
            ++i;
        }
        int index = 0;
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                double sx = ((double)x / (double)(width - 1) - 0.5) * 2.0;
                double sy = ((double)y / (double)(height - 1) - 0.5) * 2.0;
                double value = f.compute(sx, sy);
                if (value < -1.0) {
                    value = -1.0;
                } else if (value > 1.0) {
                    value = 1.0;
                }
                ((MatrixElement)matrixElements[index++]).value = value;
                ++x;
            }
            ++y;
        }
        boolean balanced = f.isBalanced();
        if (!balanced) {
            Sort.sort(matrixElements, matrixElements[0]);
        }
        int i2 = 0;
        while (i2 < data.length) {
            Object elem = matrixElements[i2];
            data[((MatrixElement)elem).index] = balanced ? (int)(((MatrixElement)elem).value * 254.0) : i2 * 255 / data.length;
            ++i2;
        }
        this.setDitherMatrix(width, height, data);
    }

    public void setOrder3DitherMatrix() {
        int[] nArray = new int[36];
        nArray[0] = 9;
        nArray[1] = 11;
        nArray[2] = 10;
        nArray[3] = 8;
        nArray[4] = 6;
        nArray[5] = 7;
        nArray[6] = 12;
        nArray[7] = 17;
        nArray[8] = 16;
        nArray[9] = 5;
        nArray[11] = 1;
        nArray[12] = 13;
        nArray[13] = 14;
        nArray[14] = 15;
        nArray[15] = 4;
        nArray[16] = 3;
        nArray[17] = 2;
        nArray[18] = 8;
        nArray[19] = 6;
        nArray[20] = 7;
        nArray[21] = 9;
        nArray[22] = 11;
        nArray[23] = 10;
        nArray[24] = 5;
        nArray[26] = 1;
        nArray[27] = 12;
        nArray[28] = 17;
        nArray[29] = 16;
        nArray[30] = 4;
        nArray[31] = 3;
        nArray[32] = 2;
        nArray[33] = 13;
        nArray[34] = 14;
        nArray[35] = 15;
        this.setDitherMatrix(6, 6, nArray);
    }

    public void setOrder4DitherMatrix() {
        int[] nArray = new int[64];
        nArray[0] = 18;
        nArray[1] = 20;
        nArray[2] = 19;
        nArray[3] = 16;
        nArray[4] = 13;
        nArray[5] = 11;
        nArray[6] = 12;
        nArray[7] = 15;
        nArray[8] = 27;
        nArray[9] = 28;
        nArray[10] = 29;
        nArray[11] = 22;
        nArray[12] = 4;
        nArray[13] = 3;
        nArray[14] = 2;
        nArray[15] = 9;
        nArray[16] = 26;
        nArray[17] = 31;
        nArray[18] = 30;
        nArray[19] = 21;
        nArray[20] = 5;
        nArray[22] = 1;
        nArray[23] = 10;
        nArray[24] = 23;
        nArray[25] = 25;
        nArray[26] = 24;
        nArray[27] = 17;
        nArray[28] = 8;
        nArray[29] = 6;
        nArray[30] = 7;
        nArray[31] = 14;
        nArray[32] = 13;
        nArray[33] = 11;
        nArray[34] = 12;
        nArray[35] = 15;
        nArray[36] = 18;
        nArray[37] = 20;
        nArray[38] = 19;
        nArray[39] = 16;
        nArray[40] = 4;
        nArray[41] = 3;
        nArray[42] = 2;
        nArray[43] = 9;
        nArray[44] = 27;
        nArray[45] = 28;
        nArray[46] = 29;
        nArray[47] = 22;
        nArray[48] = 5;
        nArray[50] = 1;
        nArray[51] = 10;
        nArray[52] = 26;
        nArray[53] = 31;
        nArray[54] = 30;
        nArray[55] = 21;
        nArray[56] = 8;
        nArray[57] = 6;
        nArray[58] = 7;
        nArray[59] = 14;
        nArray[60] = 23;
        nArray[61] = 25;
        nArray[62] = 24;
        nArray[63] = 17;
        this.setDitherMatrix(8, 8, nArray);
    }

    public void setOrder8DitherMatrix() {
        int[] nArray = new int[256];
        nArray[0] = 64;
        nArray[1] = 69;
        nArray[2] = 77;
        nArray[3] = 87;
        nArray[4] = 86;
        nArray[5] = 76;
        nArray[6] = 68;
        nArray[7] = 67;
        nArray[8] = 63;
        nArray[9] = 58;
        nArray[10] = 50;
        nArray[11] = 40;
        nArray[12] = 41;
        nArray[13] = 51;
        nArray[14] = 59;
        nArray[15] = 60;
        nArray[16] = 70;
        nArray[17] = 94;
        nArray[18] = 100;
        nArray[19] = 109;
        nArray[20] = 108;
        nArray[21] = 99;
        nArray[22] = 93;
        nArray[23] = 75;
        nArray[24] = 57;
        nArray[25] = 33;
        nArray[26] = 27;
        nArray[27] = 18;
        nArray[28] = 19;
        nArray[29] = 28;
        nArray[30] = 34;
        nArray[31] = 52;
        nArray[32] = 78;
        nArray[33] = 101;
        nArray[34] = 114;
        nArray[35] = 116;
        nArray[36] = 115;
        nArray[37] = 112;
        nArray[38] = 98;
        nArray[39] = 83;
        nArray[40] = 49;
        nArray[41] = 26;
        nArray[42] = 13;
        nArray[43] = 11;
        nArray[44] = 12;
        nArray[45] = 15;
        nArray[46] = 29;
        nArray[47] = 44;
        nArray[48] = 88;
        nArray[49] = 110;
        nArray[50] = 123;
        nArray[51] = 124;
        nArray[52] = 125;
        nArray[53] = 118;
        nArray[54] = 107;
        nArray[55] = 85;
        nArray[56] = 39;
        nArray[57] = 17;
        nArray[58] = 4;
        nArray[59] = 3;
        nArray[60] = 2;
        nArray[61] = 9;
        nArray[62] = 20;
        nArray[63] = 42;
        nArray[64] = 89;
        nArray[65] = 111;
        nArray[66] = 122;
        nArray[67] = 127;
        nArray[68] = 126;
        nArray[69] = 117;
        nArray[70] = 106;
        nArray[71] = 84;
        nArray[72] = 38;
        nArray[73] = 16;
        nArray[74] = 5;
        nArray[76] = 1;
        nArray[77] = 10;
        nArray[78] = 21;
        nArray[79] = 43;
        nArray[80] = 79;
        nArray[81] = 102;
        nArray[82] = 119;
        nArray[83] = 121;
        nArray[84] = 120;
        nArray[85] = 113;
        nArray[86] = 97;
        nArray[87] = 82;
        nArray[88] = 48;
        nArray[89] = 25;
        nArray[90] = 8;
        nArray[91] = 6;
        nArray[92] = 7;
        nArray[93] = 14;
        nArray[94] = 30;
        nArray[95] = 45;
        nArray[96] = 71;
        nArray[97] = 95;
        nArray[98] = 103;
        nArray[99] = 104;
        nArray[100] = 105;
        nArray[101] = 96;
        nArray[102] = 92;
        nArray[103] = 74;
        nArray[104] = 56;
        nArray[105] = 32;
        nArray[106] = 24;
        nArray[107] = 23;
        nArray[108] = 22;
        nArray[109] = 31;
        nArray[110] = 35;
        nArray[111] = 53;
        nArray[112] = 65;
        nArray[113] = 72;
        nArray[114] = 80;
        nArray[115] = 90;
        nArray[116] = 91;
        nArray[117] = 81;
        nArray[118] = 73;
        nArray[119] = 66;
        nArray[120] = 62;
        nArray[121] = 55;
        nArray[122] = 47;
        nArray[123] = 37;
        nArray[124] = 36;
        nArray[125] = 46;
        nArray[126] = 54;
        nArray[127] = 61;
        nArray[128] = 63;
        nArray[129] = 58;
        nArray[130] = 50;
        nArray[131] = 40;
        nArray[132] = 41;
        nArray[133] = 51;
        nArray[134] = 59;
        nArray[135] = 60;
        nArray[136] = 64;
        nArray[137] = 69;
        nArray[138] = 77;
        nArray[139] = 87;
        nArray[140] = 86;
        nArray[141] = 76;
        nArray[142] = 68;
        nArray[143] = 67;
        nArray[144] = 57;
        nArray[145] = 33;
        nArray[146] = 27;
        nArray[147] = 18;
        nArray[148] = 19;
        nArray[149] = 28;
        nArray[150] = 34;
        nArray[151] = 52;
        nArray[152] = 70;
        nArray[153] = 94;
        nArray[154] = 100;
        nArray[155] = 109;
        nArray[156] = 108;
        nArray[157] = 99;
        nArray[158] = 93;
        nArray[159] = 75;
        nArray[160] = 49;
        nArray[161] = 26;
        nArray[162] = 13;
        nArray[163] = 11;
        nArray[164] = 12;
        nArray[165] = 15;
        nArray[166] = 29;
        nArray[167] = 44;
        nArray[168] = 78;
        nArray[169] = 101;
        nArray[170] = 114;
        nArray[171] = 116;
        nArray[172] = 115;
        nArray[173] = 112;
        nArray[174] = 98;
        nArray[175] = 83;
        nArray[176] = 39;
        nArray[177] = 17;
        nArray[178] = 4;
        nArray[179] = 3;
        nArray[180] = 2;
        nArray[181] = 9;
        nArray[182] = 20;
        nArray[183] = 42;
        nArray[184] = 88;
        nArray[185] = 110;
        nArray[186] = 123;
        nArray[187] = 124;
        nArray[188] = 125;
        nArray[189] = 118;
        nArray[190] = 107;
        nArray[191] = 85;
        nArray[192] = 38;
        nArray[193] = 16;
        nArray[194] = 5;
        nArray[196] = 1;
        nArray[197] = 10;
        nArray[198] = 21;
        nArray[199] = 43;
        nArray[200] = 89;
        nArray[201] = 111;
        nArray[202] = 122;
        nArray[203] = 127;
        nArray[204] = 126;
        nArray[205] = 117;
        nArray[206] = 106;
        nArray[207] = 84;
        nArray[208] = 48;
        nArray[209] = 25;
        nArray[210] = 8;
        nArray[211] = 6;
        nArray[212] = 7;
        nArray[213] = 14;
        nArray[214] = 30;
        nArray[215] = 45;
        nArray[216] = 79;
        nArray[217] = 102;
        nArray[218] = 119;
        nArray[219] = 121;
        nArray[220] = 120;
        nArray[221] = 113;
        nArray[222] = 97;
        nArray[223] = 82;
        nArray[224] = 56;
        nArray[225] = 32;
        nArray[226] = 24;
        nArray[227] = 23;
        nArray[228] = 22;
        nArray[229] = 31;
        nArray[230] = 35;
        nArray[231] = 53;
        nArray[232] = 71;
        nArray[233] = 95;
        nArray[234] = 103;
        nArray[235] = 104;
        nArray[236] = 105;
        nArray[237] = 96;
        nArray[238] = 92;
        nArray[239] = 74;
        nArray[240] = 62;
        nArray[241] = 55;
        nArray[242] = 47;
        nArray[243] = 37;
        nArray[244] = 36;
        nArray[245] = 46;
        nArray[246] = 54;
        nArray[247] = 61;
        nArray[248] = 65;
        nArray[249] = 72;
        nArray[250] = 80;
        nArray[251] = 90;
        nArray[252] = 91;
        nArray[253] = 81;
        nArray[254] = 73;
        nArray[255] = 66;
        this.setDitherMatrix(16, 16, nArray);
    }
}

