/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.analysis;

import net.sourceforge.jiu.color.data.Histogram3D;
import net.sourceforge.jiu.color.data.NaiveHistogram3D;
import net.sourceforge.jiu.color.data.OnDemandHistogram3D;
import net.sourceforge.jiu.data.IntegerImage;
import net.sourceforge.jiu.data.RGBIntegerImage;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.Operation;
import net.sourceforge.jiu.ops.WrongParameterException;

public class Histogram3DCreator
extends Operation {
    private Histogram3D hist;
    private IntegerImage image;
    private int index1;
    private int index2;
    private int index3;
    private boolean naive;

    public static Integer count(IntegerImage image) {
        if (image.getNumChannels() == 3) {
            try {
                Histogram3DCreator hc = new Histogram3DCreator();
                hc.setImage((RGBIntegerImage)image);
                hc.process();
                Histogram3D hist = hc.getHistogram();
                return new Integer(hist.getNumUsedEntries());
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private void createHistogramIfNecessary() {
        if (this.hist == null) {
            this.hist = this.naive ? new NaiveHistogram3D(this.image.getMaxSample(this.index1) + 1, this.image.getMaxSample(this.index2) + 1, this.image.getMaxSample(this.index3) + 1) : new OnDemandHistogram3D(this.image.getMaxSample(this.index1) + 1, this.image.getMaxSample(this.index2) + 1, this.image.getMaxSample(this.index3) + 1);
        }
    }

    public Histogram3D getHistogram() {
        return this.hist;
    }

    @Override
    public void process() throws MissingParameterException, WrongParameterException {
        if (this.image == null) {
            throw new MissingParameterException("Image parameter missing.");
        }
        this.createHistogramIfNecessary();
        if (this.hist.getMaxValue(0) < this.image.getMaxSample(this.index1) || this.hist.getMaxValue(1) < this.image.getMaxSample(this.index2) || this.hist.getMaxValue(2) < this.image.getMaxSample(this.index3)) {
            throw new WrongParameterException("Histogram is not large enough for image (hist max value / image max samples).");
        }
        this.hist.clear();
        int WIDTH = this.image.getWidth();
        int HEIGHT = this.image.getHeight();
        int y = 0;
        while (y < HEIGHT) {
            int x = 0;
            while (x < WIDTH) {
                this.hist.increaseEntry(this.image.getSample(this.index1, x, y), this.image.getSample(this.index2, x, y), this.image.getSample(this.index3, x, y));
                ++x;
            }
            this.setProgress(y, HEIGHT);
            ++y;
        }
    }

    public void setHistogram3D(Histogram3D histogram) {
        this.hist = histogram;
    }

    public void setImage(IntegerImage newImage) {
        this.setImage(newImage, 0, 1, 2);
    }

    public void setImage(IntegerImage newImage, int channelIndex1, int channelIndex2, int channelIndex3) {
        if (newImage == null) {
            throw new IllegalArgumentException("Image argument must not be null.");
        }
        if (channelIndex1 < 0 || channelIndex1 >= newImage.getNumChannels() || channelIndex2 < 0 || channelIndex2 >= newImage.getNumChannels() || channelIndex3 < 0 || channelIndex3 >= newImage.getNumChannels()) {
            throw new IllegalArgumentException("The three index arguments must be >= 0 and < the number of channels.");
        }
        if (channelIndex1 == channelIndex2 || channelIndex2 == channelIndex3 || channelIndex1 == channelIndex3) {
            throw new IllegalArgumentException("The three index arguments must be different from each other.");
        }
        this.image = newImage;
        this.index1 = channelIndex1;
        this.index2 = channelIndex2;
        this.index3 = channelIndex3;
    }
}

