/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.analysis;

import net.sourceforge.jiu.color.data.ArrayHistogram1D;
import net.sourceforge.jiu.color.data.Histogram1D;
import net.sourceforge.jiu.data.IntegerImage;
import net.sourceforge.jiu.data.RGBIntegerImage;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.Operation;
import net.sourceforge.jiu.ops.WrongParameterException;

public class Histogram1DCreator
extends Operation {
    private Histogram1D hist;
    private int channelIndex;
    private IntegerImage image;

    public static Integer count(IntegerImage image) {
        return Histogram1DCreator.count(image, 0);
    }

    public static Integer count(IntegerImage image, int channelIndex) {
        if (image != null && channelIndex >= 0 && channelIndex < image.getNumChannels()) {
            try {
                Histogram1DCreator hc = new Histogram1DCreator();
                hc.setImage((RGBIntegerImage)image);
                hc.process();
                Histogram1D hist = hc.getHistogram();
                return new Integer(hist.getNumUsedEntries());
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private void createHistogramIfNecessary() {
        if (this.hist == null) {
            this.hist = new ArrayHistogram1D(this.image.getMaxSample(0) + 1);
        }
    }

    public Histogram1D getHistogram() {
        return this.hist;
    }

    @Override
    public void process() throws MissingParameterException, WrongParameterException {
        if (this.image == null) {
            throw new MissingParameterException("Image parameter missing.");
        }
        this.createHistogramIfNecessary();
        if (this.hist.getMaxValue() < this.image.getMaxSample(this.channelIndex)) {
            throw new WrongParameterException("Histogram does not have enough entries.");
        }
        this.hist.clear();
        int WIDTH = this.image.getWidth();
        int HEIGHT = this.image.getHeight();
        int y = 0;
        while (y < HEIGHT) {
            int x = 0;
            while (x < WIDTH) {
                this.hist.increaseEntry(this.image.getSample(this.channelIndex, x, y));
                ++x;
            }
            this.setProgress(y, HEIGHT);
            ++y;
        }
    }

    public void setHistogram(Histogram1D histogram) {
        this.hist = histogram;
    }

    public void setImage(IntegerImage newImage) {
        this.setImage(newImage, 0);
    }

    public void setImage(IntegerImage newImage, int imageChannelIndex) {
        if (newImage == null) {
            throw new IllegalArgumentException("Image argument must be non-null.");
        }
        if (imageChannelIndex < 0 || imageChannelIndex >= newImage.getNumChannels()) {
            throw new IllegalArgumentException("Invalid channel for given image.");
        }
        this.image = newImage;
        this.channelIndex = imageChannelIndex;
    }
}

