/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color;

import net.sourceforge.jiu.data.IntegerImage;
import net.sourceforge.jiu.data.Palette;
import net.sourceforge.jiu.data.Paletted8Image;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.ops.ImageToImageOperation;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.OperationFailedException;
import net.sourceforge.jiu.ops.WrongParameterException;

public class Invert
extends ImageToImageOperation {
    public static PixelImage invert(PixelImage inputImage) throws OperationFailedException {
        Invert invert = new Invert();
        invert.setInputImage(inputImage);
        invert.process();
        return invert.getOutputImage();
    }

    private void prepare(PixelImage in) throws MissingParameterException, WrongParameterException {
        if (in == null) {
            throw new MissingParameterException("Missing input image.");
        }
        PixelImage out = this.getOutputImage();
        if (out == null) {
            this.setOutputImage(in.createCompatibleImage(in.getWidth(), in.getHeight()));
        } else {
            if (in.getClass() != out.getClass()) {
                throw new WrongParameterException("Specified output image type must be the same as input image type.");
            }
            if (in.getWidth() != out.getWidth()) {
                throw new WrongParameterException("Specified output image must have same width as input image.");
            }
            if (in.getHeight() != out.getHeight()) {
                throw new WrongParameterException("Specified output image must have same height as input image.");
            }
        }
    }

    private void process(Paletted8Image in) {
        Paletted8Image out = (Paletted8Image)this.getOutputImage();
        Palette pal = out.getPalette();
        int MAX = pal.getMaxValue();
        int entryIndex = 0;
        while (entryIndex < pal.getNumEntries()) {
            int channelIndex = 0;
            while (channelIndex < 3) {
                pal.putSample(channelIndex, entryIndex, MAX - pal.getSample(channelIndex, entryIndex));
                ++channelIndex;
            }
            ++entryIndex;
        }
        int WIDTH = in.getWidth();
        int HEIGHT = in.getHeight();
        int y = 0;
        while (y < HEIGHT) {
            int x = 0;
            while (x < WIDTH) {
                out.putSample(0, x, y, in.getSample(0, x, y));
                ++x;
            }
            this.setProgress(y, HEIGHT);
            ++y;
        }
    }

    private void process(IntegerImage in) {
        IntegerImage out = (IntegerImage)this.getOutputImage();
        int WIDTH = in.getWidth();
        int HEIGHT = in.getHeight();
        int CHANNELS = in.getNumChannels();
        int TOTAL_ITEMS = CHANNELS * HEIGHT;
        int processedItems = 0;
        int channel = 0;
        while (channel < CHANNELS) {
            int MAX = in.getMaxSample(channel);
            int y = 0;
            while (y < HEIGHT) {
                int x = 0;
                while (x < WIDTH) {
                    out.putSample(channel, x, y, MAX - in.getSample(channel, x, y));
                    ++x;
                }
                this.setProgress(processedItems++, TOTAL_ITEMS);
                ++y;
            }
            ++channel;
        }
    }

    @Override
    public void process() throws MissingParameterException, WrongParameterException {
        PixelImage in = this.getInputImage();
        this.prepare(in);
        if (in instanceof Paletted8Image) {
            this.process((Paletted8Image)in);
        } else if (in instanceof IntegerImage) {
            this.process((IntegerImage)in);
        } else {
            throw new WrongParameterException("Input image type unsupported: " + in.toString());
        }
    }
}

