/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.codecs.tiff;

import java.io.DataInput;
import java.io.IOException;
import net.sourceforge.jiu.codecs.InvalidFileStructureException;
import net.sourceforge.jiu.codecs.tiff.TIFFDecoder;

public class TIFFDecoderPackbits
extends TIFFDecoder {
    @Override
    public void decode() throws InvalidFileStructureException, IOException {
        DataInput in = this.getInput();
        byte[] row = new byte[this.getBytesPerRow()];
        int y = this.getY1();
        while (y <= this.getY2()) {
            int index = 0;
            do {
                int numSamples;
                byte value;
                if ((value = in.readByte()) >= 0) {
                    numSamples = value + 1;
                    in.readFully(row, index, numSamples);
                    index += numSamples;
                    continue;
                }
                if (value == -128) continue;
                numSamples = -value + 1;
                byte sample = in.readByte();
                while (numSamples-- != 0) {
                    row[index++] = sample;
                }
            } while (index != row.length);
            this.putBytes(row, 0, row.length);
            ++y;
        }
    }

    @Override
    public Integer[] getCompressionTypes() {
        return new Integer[]{new Integer(32773)};
    }
}

