/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.codecs;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Deflater;
import java.util.zip.InflaterInputStream;
import net.sourceforge.jiu.codecs.CodecMode;
import net.sourceforge.jiu.codecs.ImageCodec;
import net.sourceforge.jiu.codecs.InvalidFileStructureException;
import net.sourceforge.jiu.codecs.InvalidImageIndexException;
import net.sourceforge.jiu.codecs.PngIdatInputStream;
import net.sourceforge.jiu.codecs.UnsupportedCodecModeException;
import net.sourceforge.jiu.codecs.UnsupportedTypeException;
import net.sourceforge.jiu.codecs.WrongFileFormatException;
import net.sourceforge.jiu.data.BilevelImage;
import net.sourceforge.jiu.data.Gray16Image;
import net.sourceforge.jiu.data.Gray8Image;
import net.sourceforge.jiu.data.IntegerImage;
import net.sourceforge.jiu.data.MemoryBilevelImage;
import net.sourceforge.jiu.data.MemoryGray16Image;
import net.sourceforge.jiu.data.MemoryGray8Image;
import net.sourceforge.jiu.data.MemoryPaletted8Image;
import net.sourceforge.jiu.data.MemoryRGB24Image;
import net.sourceforge.jiu.data.MemoryRGB48Image;
import net.sourceforge.jiu.data.Palette;
import net.sourceforge.jiu.data.Paletted8Image;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.data.RGB24Image;
import net.sourceforge.jiu.data.RGB48Image;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.OperationFailedException;
import net.sourceforge.jiu.util.ArrayConverter;

public class PNGCodec
extends ImageCodec {
    private final int CHUNK_CRC32_IEND = -1371381630;
    private final int CHUNK_SIZE_IHDR = 13;
    private final int CHUNK_TYPE_IDAT = 1229209940;
    private final int CHUNK_TYPE_IEND = 1229278788;
    private final int CHUNK_TYPE_IHDR = 1229472850;
    private final int CHUNK_TYPE_PHYS = 1883789683;
    private final int CHUNK_TYPE_PLTE = 1347179589;
    private final int CHUNK_TYPE_TEXT = 1950701684;
    private final int CHUNK_TYPE_TIME = 1950960965;
    private final int COLOR_TYPE_GRAY = 0;
    private final int COLOR_TYPE_GRAY_ALPHA = 4;
    private final int COLOR_TYPE_INDEXED = 3;
    private final int COLOR_TYPE_RGB = 2;
    private final int COLOR_TYPE_RGB_ALPHA = 6;
    private final int COLOR_TYPE_ALPHA = 4;
    private final int FILTER_TYPE_NONE = 0;
    private final int FILTER_TYPE_SUB = 1;
    private final int FILTER_TYPE_UP = 2;
    private final int FILTER_TYPE_AVERAGE = 3;
    private final int FILTER_TYPE_PAETH = 4;
    private final int COMPRESSION_DEFLATE = 0;
    private final int INTERLACING_NONE = 0;
    private final int INTERLACING_ADAM7 = 1;
    private final int FILTERING_ADAPTIVE = 0;
    private final int MAX_TEXT_SIZE = 512;
    private final int ADAM7_NUM_PASSES = 7;
    private final int DEFAULT_ENCODING_MIN_IDAT_SIZE = 32768;
    private final int[] ADAM7_COLUMN_INCREMENT = new int[]{8, 8, 4, 4, 2, 2, 1};
    private final int[] ADAM7_FIRST_COLUMN;
    private final int[] ADAM7_FIRST_ROW;
    private final int[] ADAM7_ROW_INCREMENT;
    private final byte[] MAGIC_BYTES;
    private boolean alpha;
    private byte[][] buffers;
    private int bpp;
    private CRC32 checksum;
    private CheckedInputStream checkedIn;
    private int chunkCounter;
    private int colorType;
    private int compressionType;
    private int currentBufferIndex;
    private int deflateLevel;
    private int deflateStrategy;
    private int encodingMinIdatSize;
    private int filterType;
    private boolean hasIhdr;
    private int height;
    private IntegerImage image;
    private DataInputStream in;
    private InflaterInputStream infl;
    private int interlaceType;
    private Calendar modification;
    private int numChannels;
    private DataOutput out;
    private Palette palette;
    private int precision;
    private int previousBufferIndex;
    private int width;

    public PNGCodec() {
        int[] nArray = new int[7];
        nArray[1] = 4;
        nArray[3] = 2;
        nArray[5] = 1;
        this.ADAM7_FIRST_COLUMN = nArray;
        int[] nArray2 = new int[7];
        nArray2[2] = 4;
        nArray2[4] = 2;
        nArray2[6] = 1;
        this.ADAM7_FIRST_ROW = nArray2;
        this.ADAM7_ROW_INCREMENT = new int[]{8, 8, 8, 4, 4, 2, 2};
        this.MAGIC_BYTES = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        this.deflateLevel = -1;
        this.deflateStrategy = 0;
        this.encodingMinIdatSize = 32768;
    }

    private void allocateImage() throws InvalidFileStructureException, UnsupportedTypeException {
        this.setBoundsIfNecessary(this.width, this.height);
        int w = this.getBoundsWidth();
        int h = this.getBoundsHeight();
        if (this.colorType == 0 || this.colorType == 4) {
            if (this.precision == 1) {
                this.image = new MemoryBilevelImage(w, h);
            } else if (this.precision <= 8) {
                this.image = new MemoryGray8Image(w, h);
            } else if (this.precision == 16) {
                this.image = new MemoryGray16Image(w, h);
            }
        } else if (this.colorType == 3) {
            if (this.palette == null) {
                throw new InvalidFileStructureException("No palette found when trying to load indexed image.");
            }
            this.image = new MemoryPaletted8Image(w, h, this.palette);
        } else if (this.colorType == 2 || this.colorType == 6) {
            this.image = this.precision == 8 ? new MemoryRGB24Image(w, h) : new MemoryRGB48Image(w, h);
        } else {
            throw new UnsupportedTypeException("Unsupported image type encountered");
        }
    }

    private void checkColorTypeAndPrecision() throws UnsupportedTypeException {
        if (this.colorType != 0 && this.colorType != 2 && this.colorType != 3 && this.colorType != 4 && this.colorType != 6) {
            throw new UnsupportedTypeException("Not a valid color type: " + this.colorType);
        }
        if (this.precision != 1 && this.precision != 2 && this.precision != 4 && this.precision != 8 && this.precision != 16) {
            throw new UnsupportedTypeException("Invalid precision value: " + this.precision);
        }
        if (this.colorType == 3 && this.precision > 8) {
            throw new UnsupportedTypeException("More than eight bits of precision are not allowed for indexed images.");
        }
        if (this.colorType == 2 && this.precision < 8) {
            throw new UnsupportedTypeException("Less than eight bits of precision are not allowed for RGB images.");
        }
        this.alpha = (this.colorType & 4) != 0;
        this.numChannels = this.colorType == 2 || this.colorType == 6 ? 3 : 1;
        this.bpp = this.computeBytesPerRow(1);
    }

    private int computeBytesPerRow(int numPixels) {
        if (this.precision < 8) {
            return (numPixels + (8 / this.precision - 1)) / (8 / this.precision);
        }
        return (this.numChannels + (this.alpha ? 1 : 0)) * (this.precision / 8) * numPixels;
    }

    private int computeColumnsAdam7(int pass) {
        switch (pass) {
            case 0: {
                return (this.width + 7) / 8;
            }
            case 1: {
                return (this.width + 3) / 8;
            }
            case 2: {
                return (this.width + 3) / 4;
            }
            case 3: {
                return (this.width + 1) / 4;
            }
            case 4: {
                return (this.width + 1) / 2;
            }
            case 5: {
                return this.width / 2;
            }
            case 6: {
                return this.width;
            }
        }
        throw new IllegalArgumentException("Not a valid pass index: " + pass);
    }

    private void fillRowBuffer(int y, byte[] row, int offs) {
        block4: {
            int w;
            int x1;
            PixelImage image;
            block8: {
                block7: {
                    block6: {
                        block5: {
                            block3: {
                                image = this.getImage();
                                x1 = this.getBoundsX1();
                                w = this.getBoundsWidth();
                                if (!(image instanceof BilevelImage)) break block3;
                                BilevelImage bilevelImage = (BilevelImage)image;
                                bilevelImage.getPackedBytes(x1, y, w, row, offs, 0);
                                break block4;
                            }
                            if (!(image instanceof Gray16Image)) break block5;
                            Gray16Image grayImage = (Gray16Image)image;
                            while (w-- > 0) {
                                short sample = grayImage.getShortSample(x1++, y);
                                ArrayConverter.setShortBE(row, offs, sample);
                                offs += 2;
                            }
                            break block4;
                        }
                        if (!(image instanceof Gray8Image)) break block6;
                        Gray8Image grayImage = (Gray8Image)image;
                        grayImage.getByteSamples(0, this.getBoundsX1(), y, this.getBoundsWidth(), 1, row, offs);
                        break block4;
                    }
                    if (!(image instanceof Paletted8Image)) break block7;
                    Paletted8Image palImage = (Paletted8Image)image;
                    palImage.getByteSamples(0, this.getBoundsX1(), y, this.getBoundsWidth(), 1, row, offs);
                    break block4;
                }
                if (!(image instanceof RGB24Image)) break block8;
                RGB24Image rgbImage = (RGB24Image)image;
                while (w-- > 0) {
                    row[offs++] = rgbImage.getByteSample(0, x1, y);
                    row[offs++] = rgbImage.getByteSample(1, x1, y);
                    row[offs++] = rgbImage.getByteSample(2, x1, y);
                    ++x1;
                }
                break block4;
            }
            if (!(image instanceof RGB48Image)) break block4;
            RGB48Image rgbImage = (RGB48Image)image;
            while (w-- > 0) {
                short sample = rgbImage.getShortSample(0, x1, y);
                ArrayConverter.setShortBE(row, offs, sample);
                sample = rgbImage.getShortSample(1, x1, y);
                ArrayConverter.setShortBE(row, offs += 2, sample);
                sample = rgbImage.getShortSample(2, x1, y);
                ArrayConverter.setShortBE(row, offs += 2, sample);
                offs += 2;
                ++x1;
            }
        }
    }

    private static String getChunkName(int chunk) {
        StringBuffer result = new StringBuffer(4);
        int i = 24;
        while (i >= 0) {
            result.append((char)(chunk >> i & 0xFF));
            i -= 8;
        }
        return result.toString();
    }

    @Override
    public String getFormatName() {
        return "Portable Network Graphics (PNG)";
    }

    @Override
    public String[] getMimeTypes() {
        return new String[]{"image/png"};
    }

    private static int getPaeth(byte l, byte u, byte nw) {
        int pc;
        int pb;
        int a = l & 0xFF;
        int b = u & 0xFF;
        int c = nw & 0xFF;
        int p = a + b - c;
        int pa = p - a;
        if (pa < 0) {
            pa = -pa;
        }
        if ((pb = p - b) < 0) {
            pb = -pb;
        }
        if ((pc = p - c) < 0) {
            pc = -pc;
        }
        if (pa <= pb && pa <= pc) {
            return a;
        }
        if (pb <= pc) {
            return b;
        }
        return c;
    }

    private void inflateBytes(byte[] buffer, int numBytes) throws InvalidFileStructureException, IOException {
        int numRead;
        int offset = 0;
        do {
            try {
                int toRead = numBytes - offset;
                numRead = this.infl.read(buffer, offset, toRead);
                if (numRead < 0) {
                    throw new InvalidFileStructureException("Cannot fill buffer");
                }
            }
            catch (IOException ioe) {
                throw new InvalidFileStructureException("Stopped decompressing " + ioe.toString());
            }
        } while ((offset += numRead) != numBytes);
    }

    @Override
    public boolean isLoadingSupported() {
        return true;
    }

    @Override
    public boolean isSavingSupported() {
        return true;
    }

    private void load() throws InvalidFileStructureException, IOException, UnsupportedTypeException, WrongFileFormatException {
        byte[] magic = new byte[this.MAGIC_BYTES.length];
        this.in.readFully(magic);
        int i = 0;
        while (i < this.MAGIC_BYTES.length) {
            if (magic[i] != this.MAGIC_BYTES[i]) {
                throw new WrongFileFormatException("Not a valid PNG input stream, wrong magic byte sequence.");
            }
            ++i;
        }
        this.chunkCounter = 0;
        do {
            this.loadChunk();
            ++this.chunkCounter;
        } while (this.image == null);
        this.close();
        this.setImage(this.image);
    }

    private void loadChunk() throws InvalidFileStructureException, IOException, UnsupportedTypeException {
        int chunkChecksum;
        long chunkSize = (long)this.in.readInt() & 0xFFFFFFFFL;
        this.checksum.reset();
        int chunkName = this.in.readInt();
        if (this.chunkCounter == 0 && chunkName != 1229472850) {
            throw new InvalidFileStructureException("First chunk was not IHDR but " + PNGCodec.getChunkName(chunkName));
        }
        block0 : switch (chunkName) {
            case 1229209940: {
                this.loadImage(chunkSize);
                break;
            }
            case 1229278788: {
                throw new InvalidFileStructureException("Reached IEND chunk but could not load image.");
            }
            case 1229472850: {
                if (this.hasIhdr) {
                    throw new InvalidFileStructureException("More than one IHDR chunk found.");
                }
                if (this.chunkCounter != 0) {
                    throw new InvalidFileStructureException("IHDR chunk must be first; found to be chunk #" + (this.chunkCounter + 1));
                }
                if (chunkSize != 13L) {
                    throw new InvalidFileStructureException("Expected PNG IHDR chunk length to be 13, got " + chunkSize + ".");
                }
                this.hasIhdr = true;
                this.loadImageHeader();
                break;
            }
            case 1883789683: {
                if (chunkSize == 9L) {
                    byte[] phys = new byte[9];
                    this.in.readFully(phys);
                    int x = ArrayConverter.getIntBE(phys, 0);
                    int y = ArrayConverter.getIntBE(phys, 4);
                    if (phys[8] != 1) break;
                    double INCHES_PER_METER = 39.37007874015748;
                    this.setDpi((int)((double)x / 39.37007874015748), (int)((double)y / 39.37007874015748));
                    break;
                }
                this.skip(chunkSize);
                break;
            }
            case 1347179589: {
                if (chunkSize % 3L != 0L) {
                    throw new InvalidFileStructureException("Not a valid palette chunk size: " + chunkSize);
                }
                this.loadPalette(chunkSize / 3L);
                break;
            }
            case 1950701684: {
                if (chunkSize == 0L) break;
                if (chunkSize > 512L) {
                    this.skip(chunkSize);
                    break;
                }
                StringBuffer text = new StringBuffer((int)chunkSize);
                int i = 0;
                do {
                    char c;
                    if ((c = (char)this.in.read()) == '\u0000') {
                        this.skip(chunkSize - (long)i - 1L);
                        break block0;
                    }
                    text.append(c);
                } while ((long)(++i) < chunkSize);
                break;
            }
            default: {
                this.skip(chunkSize);
            }
        }
        int createdChecksum = (int)this.checksum.getValue();
        if (this.image == null && createdChecksum != (chunkChecksum = this.in.readInt())) {
            throw new InvalidFileStructureException("Checksum created on chunk " + PNGCodec.getChunkName(chunkName) + " " + Integer.toHexString(createdChecksum) + " is not equal to checksum read from stream " + Integer.toHexString(chunkChecksum) + "; file is corrupted.");
        }
    }

    private void loadImage(long chunkSize) throws InvalidFileStructureException, IOException, UnsupportedTypeException {
        this.buffers = new byte[2][];
        int numBytes = this.computeBytesPerRow(this.width);
        this.currentBufferIndex = 0;
        this.previousBufferIndex = 1;
        this.buffers[this.currentBufferIndex] = new byte[numBytes];
        this.buffers[this.previousBufferIndex] = new byte[numBytes];
        int i = 0;
        while (i < this.buffers[this.previousBufferIndex].length) {
            this.buffers[this.previousBufferIndex][i] = 0;
            ++i;
        }
        this.allocateImage();
        this.infl = new InflaterInputStream(new PngIdatInputStream(this.in, chunkSize));
        switch (this.interlaceType) {
            case 0: {
                this.loadImageNonInterlaced();
                break;
            }
            case 1: {
                this.loadImageInterlacedAdam7();
            }
        }
    }

    private void loadImageHeader() throws IOException, InvalidFileStructureException, UnsupportedTypeException {
        this.width = this.in.readInt();
        if (this.width < 1) {
            throw new InvalidFileStructureException("Width must be larger than 0; got " + this.width);
        }
        this.height = this.in.readInt();
        if (this.height < 1) {
            throw new InvalidFileStructureException("Height must be larger than 0; got " + this.height);
        }
        this.precision = this.in.read();
        this.colorType = this.in.read();
        this.checkColorTypeAndPrecision();
        this.compressionType = this.in.read();
        if (this.compressionType != 0) {
            throw new UnsupportedTypeException("Unsupported compression type: " + this.compressionType + ".");
        }
        this.filterType = this.in.read();
        if (this.filterType != 0) {
            throw new UnsupportedTypeException("Only 'adaptive filtering' is supported right now; got " + this.filterType);
        }
        this.interlaceType = this.in.read();
        if (this.interlaceType != 0 && this.interlaceType != 1) {
            throw new UnsupportedTypeException("Only 'no interlacing' and 'Adam7 interlacing' are supported; got " + this.interlaceType);
        }
    }

    private void loadImageInterlacedAdam7() throws InvalidFileStructureException, IOException, UnsupportedTypeException {
        int TOTAL_LINES = 7 * this.height;
        int pass = 0;
        while (pass < 7) {
            this.currentBufferIndex = 0;
            this.previousBufferIndex = 1;
            byte[] previousBuffer = this.buffers[this.previousBufferIndex];
            int x = 0;
            while (x < previousBuffer.length) {
                previousBuffer[x] = 0;
                ++x;
            }
            int y = this.ADAM7_FIRST_ROW[pass];
            int destY = y - this.getBoundsY1();
            int numColumns = this.computeColumnsAdam7(pass);
            if (numColumns == 0) {
                this.setProgress((pass + 1) * this.height, TOTAL_LINES);
            } else {
                int numBytes = this.computeBytesPerRow(numColumns);
                while (y < this.height) {
                    previousBuffer = this.buffers[this.previousBufferIndex];
                    byte[] currentBuffer = this.buffers[this.currentBufferIndex];
                    int rowFilterType = this.readFilterType();
                    this.inflateBytes(currentBuffer, numBytes);
                    this.reverseFilter(rowFilterType, currentBuffer, previousBuffer, numBytes);
                    if (this.isRowRequired(y)) {
                        this.storeInterlacedAdam7(pass, destY, currentBuffer);
                    }
                    int progressY = y;
                    if (pass > 0) {
                        progressY += pass * this.height;
                    }
                    this.setProgress(progressY, TOTAL_LINES);
                    y += this.ADAM7_ROW_INCREMENT[pass];
                    destY += this.ADAM7_ROW_INCREMENT[pass];
                    this.currentBufferIndex = 1 - this.currentBufferIndex;
                    this.previousBufferIndex = 1 - this.previousBufferIndex;
                }
            }
            ++pass;
        }
    }

    private void loadImageNonInterlaced() throws InvalidFileStructureException, IOException, UnsupportedTypeException {
        int linesToRead = this.getBoundsY2() + 1;
        int rowLength = this.computeBytesPerRow(this.width);
        int y = 0;
        int destY = -this.getBoundsY1();
        while (y <= this.getBoundsY2()) {
            byte[] currentBuffer = this.buffers[this.currentBufferIndex];
            byte[] previousBuffer = this.buffers[this.previousBufferIndex];
            int rowFilterType = this.readFilterType();
            this.inflateBytes(currentBuffer, rowLength);
            this.reverseFilter(rowFilterType, currentBuffer, previousBuffer, rowLength);
            if (this.isRowRequired(y)) {
                this.storeNonInterlaced(destY, currentBuffer);
            }
            this.setProgress(y, linesToRead);
            this.previousBufferIndex = 1 - this.previousBufferIndex;
            this.currentBufferIndex = 1 - this.currentBufferIndex;
            ++y;
            ++destY;
        }
    }

    private void loadPalette(long numEntries) throws InvalidFileStructureException, IOException {
        if (this.palette != null) {
            throw new InvalidFileStructureException("More than one palette in input stream.");
        }
        if (numEntries < 1L) {
            throw new InvalidFileStructureException("Number of palette entries must be at least 1.");
        }
        if (numEntries > 256L) {
            throw new InvalidFileStructureException("Number of palette entries larger than 256: " + numEntries);
        }
        this.palette = new Palette((int)numEntries);
        int index = 0;
        do {
            this.palette.putSample(0, index, this.in.read() & 0xFF);
            this.palette.putSample(1, index, this.in.read() & 0xFF);
            this.palette.putSample(2, index, this.in.read() & 0xFF);
        } while ((long)(++index) != numEntries);
    }

    public static void main(String[] args) throws Exception {
        PNGCodec codec = new PNGCodec();
        codec.setFile(args[0], CodecMode.LOAD);
        codec.process();
        codec.close();
        PixelImage image = codec.getImage();
        codec = new PNGCodec();
        codec.setFile(args[1], CodecMode.SAVE);
        codec.setImage(image);
        codec.setDpi(300, 300);
        codec.appendComment("Test comment #1.");
        codec.appendComment("And test comment #2.");
        codec.setModification(new GregorianCalendar(new SimpleTimeZone(0, "UTC")));
        codec.process();
        codec.close();
    }

    @Override
    public void process() throws InvalidFileStructureException, MissingParameterException, OperationFailedException, UnsupportedTypeException, WrongFileFormatException {
        this.initModeFromIOObjects();
        if (this.getMode() == CodecMode.LOAD) {
            try {
                if (this.getImageIndex() != 0) {
                    throw new InvalidImageIndexException("PNG streams can only store one image; index " + this.getImageIndex() + " is thus not valid.");
                }
                InputStream input = this.getInputStream();
                if (input == null) {
                    throw new MissingParameterException("InputStream object missing.");
                }
                this.checksum = new CRC32();
                this.checkedIn = new CheckedInputStream(input, this.checksum);
                this.in = new DataInputStream(this.checkedIn);
                this.load();
            }
            catch (IOException ioe) {
                throw new OperationFailedException("I/O failure: " + ioe.toString());
            }
        } else if (this.getMode() == CodecMode.SAVE) {
            try {
                PixelImage image = this.getImage();
                if (image == null) {
                    throw new MissingParameterException("Need image for saving.");
                }
                this.out = this.getOutputAsDataOutput();
                if (this.out == null) {
                    throw new MissingParameterException("Could not retrieve non-null DataOutput object for saving.");
                }
                this.setBoundsIfNecessary(image.getWidth(), image.getHeight());
                this.save();
            }
            catch (IOException ioe) {
                throw new OperationFailedException("I/O failure: " + ioe.toString());
            }
        } else {
            throw new OperationFailedException("Unknown codec mode: " + this.getMode());
        }
    }

    private int readFilterType() throws InvalidFileStructureException, IOException {
        int filterType = this.infl.read();
        if (filterType >= 0 && filterType <= 4) {
            return filterType;
        }
        throw new InvalidFileStructureException("Valid filter types are from 0 to 4; got " + filterType);
    }

    private void reverseFilter(int rowFilterType, byte[] buffer, byte[] prev, int numBytes) throws UnsupportedTypeException {
        switch (rowFilterType) {
            case 0: {
                break;
            }
            case 1: {
                int x = 0;
                int px = -this.bpp;
                while (x < numBytes) {
                    byte currXMinusBpp = px < 0 ? (byte)0 : buffer[px];
                    buffer[x] = (byte)(buffer[x] + currXMinusBpp);
                    ++x;
                    ++px;
                }
                break;
            }
            case 2: {
                int x = 0;
                while (x < numBytes) {
                    buffer[x] = (byte)(buffer[x] + prev[x]);
                    ++x;
                }
                break;
            }
            case 3: {
                int x = 0;
                int px = -this.bpp;
                while (x < numBytes) {
                    byte byteResult;
                    int currX = buffer[x] & 0xFF;
                    int currXMinus1 = px < 0 ? 0 : buffer[px] & 0xFF;
                    int prevX = prev[x] & 0xFF;
                    int result = currX + (currXMinus1 + prevX) / 2;
                    buffer[x] = byteResult = (byte)result;
                    ++x;
                    ++px;
                }
                break;
            }
            case 4: {
                int x = 0;
                int px = -this.bpp;
                while (x < numBytes) {
                    byte prevXMinusBpp;
                    byte currXMinusBpp;
                    if (px < 0) {
                        currXMinusBpp = 0;
                        prevXMinusBpp = 0;
                    } else {
                        currXMinusBpp = buffer[px];
                        prevXMinusBpp = prev[px];
                    }
                    buffer[x] = (byte)(buffer[x] + PNGCodec.getPaeth(currXMinusBpp, prev[x], prevXMinusBpp));
                    ++x;
                    ++px;
                }
                break;
            }
            default: {
                throw new UnsupportedTypeException("Unknown filter type: " + rowFilterType);
            }
        }
    }

    private void save() throws IOException {
        this.out.write(this.MAGIC_BYTES);
        this.saveIhdrChunk();
        this.savePhysChunk();
        this.saveTextChunks();
        this.saveTimeChunk();
        this.savePlteChunk();
        this.saveImage();
        this.saveIendChunk();
        this.close();
    }

    private void saveChunk(int chunkType, int chunkSize, byte[] data) throws IOException {
        byte[] intArray = new byte[8];
        ArrayConverter.setIntBE(intArray, 0, chunkSize);
        ArrayConverter.setIntBE(intArray, 4, chunkType);
        this.out.write(intArray, 0, 8);
        this.out.write(data, 0, chunkSize);
        CRC32 checksum = new CRC32();
        checksum.reset();
        checksum.update(intArray, 4, 4);
        checksum.update(data, 0, chunkSize);
        ArrayConverter.setIntBE(intArray, 0, (int)checksum.getValue());
        this.out.write(intArray, 0, 4);
    }

    private void saveIendChunk() throws IOException {
        this.out.writeInt(0);
        this.out.writeInt(1229278788);
        this.out.writeInt(-1371381630);
    }

    private void saveIhdrChunk() throws IOException {
        byte[] buffer = new byte[13];
        this.width = this.getBoundsWidth();
        ArrayConverter.setIntBE(buffer, 0, this.width);
        this.height = this.getBoundsHeight();
        ArrayConverter.setIntBE(buffer, 4, this.height);
        PixelImage image = this.getImage();
        this.alpha = false;
        this.numChannels = 1;
        if (image instanceof BilevelImage) {
            this.precision = 1;
            this.colorType = 0;
        } else if (image instanceof Gray16Image) {
            this.precision = 16;
            this.colorType = 0;
        } else if (image instanceof Gray8Image) {
            this.precision = 8;
            this.colorType = 0;
        } else if (image instanceof Paletted8Image) {
            this.precision = 8;
            this.colorType = 3;
        } else if (image instanceof RGB24Image) {
            this.numChannels = 3;
            this.precision = 8;
            this.colorType = 2;
        } else if (image instanceof RGB48Image) {
            this.numChannels = 3;
            this.precision = 16;
            this.colorType = 2;
        }
        buffer[8] = (byte)this.precision;
        buffer[9] = (byte)this.colorType;
        this.compressionType = 0;
        buffer[10] = (byte)this.compressionType;
        this.filterType = 0;
        buffer[11] = (byte)this.filterType;
        this.interlaceType = 0;
        buffer[12] = (byte)this.interlaceType;
        this.saveChunk(1229472850, 13, buffer);
    }

    private void saveImage() throws IOException {
        switch (this.interlaceType) {
            case 0: {
                this.saveImageNonInterlaced();
            }
        }
    }

    private void saveImageNonInterlaced() throws IOException {
        int numDeflated;
        int bytesPerRow = this.computeBytesPerRow(this.getBoundsWidth());
        byte[] rowBuffer = new byte[bytesPerRow + 1];
        byte[] outBuffer = new byte[Math.max(this.encodingMinIdatSize, bytesPerRow + 1)];
        int outOffset = 0;
        Deflater defl = new Deflater(this.deflateLevel);
        defl.setStrategy(this.deflateStrategy);
        int y = this.getBoundsY1();
        while (y <= this.getBoundsY2()) {
            rowBuffer[0] = 0;
            this.fillRowBuffer(y, rowBuffer, 1);
            defl.setInput(rowBuffer);
            do {
                if ((outOffset += (numDeflated = defl.deflate(outBuffer, outOffset, outBuffer.length - outOffset))) != outBuffer.length) continue;
                this.saveChunk(1229209940, outOffset, outBuffer);
                outOffset = 0;
            } while (numDeflated > 0);
            this.setProgress(y - this.getBoundsY1(), this.getBoundsHeight());
            ++y;
        }
        defl.finish();
        do {
            if ((outOffset += (numDeflated = defl.deflate(outBuffer, outOffset, outBuffer.length - outOffset))) != outBuffer.length) continue;
            this.saveChunk(1229209940, outOffset, outBuffer);
            outOffset = 0;
        } while (numDeflated > 0);
        if (outOffset > 0) {
            this.saveChunk(1229209940, outOffset, outBuffer);
        }
    }

    private void savePhysChunk() throws IOException {
        int dpiX = this.getDpiX();
        int dpiY = this.getDpiY();
        if (dpiX < 1 || dpiY < 1) {
            return;
        }
        byte[] data = new byte[9];
        int ppuX = (int)((double)dpiX * 39.37007874015748);
        int ppuY = (int)((double)dpiY * 39.37007874015748);
        ArrayConverter.setIntBE(data, 0, ppuX);
        ArrayConverter.setIntBE(data, 4, ppuY);
        data[8] = 1;
        this.saveChunk(1883789683, data.length, data);
    }

    private void savePlteChunk() throws IOException {
        if (this.colorType != 3) {
            return;
        }
        Paletted8Image image = (Paletted8Image)this.getImage();
        Palette pal = image.getPalette();
        int numEntries = pal.getNumEntries();
        byte[] data = new byte[numEntries * 3];
        int i = 0;
        int j = 0;
        while (i < numEntries) {
            data[j] = (byte)pal.getSample(0, i);
            data[j + 1] = (byte)pal.getSample(1, i);
            data[j + 2] = (byte)pal.getSample(2, i);
            ++i;
            j += 3;
        }
        this.saveChunk(1347179589, data.length, data);
    }

    private void saveTextChunks() throws IOException {
        int index = 0;
        while (index < this.getNumComments()) {
            String comment = this.getComment(index++);
            comment = "Comment\u0000" + comment;
            byte[] data = comment.getBytes("ISO-8859-1");
            this.saveChunk(1950701684, data.length, data);
        }
    }

    private void saveTimeChunk() throws IOException {
        if (this.modification == null) {
            return;
        }
        byte[] data = new byte[7];
        ArrayConverter.setShortBE(data, 0, (short)this.modification.get(1));
        data[2] = (byte)(this.modification.get(2) + 1);
        data[3] = (byte)this.modification.get(5);
        data[4] = (byte)this.modification.get(11);
        data[5] = (byte)this.modification.get(12);
        data[6] = (byte)this.modification.get(13);
        this.saveChunk(1950960965, data.length, data);
    }

    public void setCompressionLevel(int newLevel) {
        if (newLevel < 0 || newLevel > 9) {
            throw new IllegalArgumentException("Compression level must be from 0..9; got " + newLevel);
        }
        this.deflateLevel = newLevel;
    }

    public void setCompressionStrategy(int newStrategy) {
        if (newStrategy != 1 && newStrategy != 0 && newStrategy != 2) {
            throw new IllegalArgumentException("Unknown compression strategy: " + newStrategy);
        }
        this.deflateStrategy = newStrategy;
    }

    public void setEncodingIdatSize(int newSize) {
        if (newSize < 1) {
            throw new IllegalArgumentException("Minimum IDAT chunk size must be 1 or larger.");
        }
        this.encodingMinIdatSize = newSize;
    }

    @Override
    public void setFile(String fileName, CodecMode codecMode) throws IOException, UnsupportedCodecModeException {
        if (codecMode == CodecMode.LOAD) {
            this.setInputStream(new BufferedInputStream(new FileInputStream(fileName)));
        } else {
            super.setFile(fileName, codecMode);
        }
    }

    public void setModification(Calendar time) {
        this.modification = time;
    }

    private void skip(long num) throws IOException {
        while (num > 0L) {
            long numSkipped = this.in.skip(num);
            if (numSkipped <= 0L) continue;
            num -= numSkipped;
        }
    }

    private void storeInterlacedAdam7(int pass, int y, byte[] buffer) {
        switch (this.colorType) {
            case 0: {
                this.storeInterlacedAdam7Gray(pass, y, buffer);
                break;
            }
            case 2: {
                this.storeInterlacedAdam7Rgb(pass, y, buffer);
                break;
            }
            case 6: {
                this.storeInterlacedAdam7RgbAlpha(pass, y, buffer);
                break;
            }
            case 4: {
                this.storeInterlacedAdam7GrayAlpha(pass, y, buffer);
                break;
            }
            case 3: {
                this.storeInterlacedAdam7Indexed(pass, y, buffer);
            }
        }
    }

    private void storeInterlacedAdam7Gray(int pass, int y, byte[] buffer) {
        int x = this.ADAM7_FIRST_COLUMN[pass];
        int incr = this.ADAM7_COLUMN_INCREMENT[pass];
        int x1 = this.getBoundsX1();
        int x2 = this.getBoundsX2();
        int offset = 0;
        int numColumns = this.computeColumnsAdam7(pass);
        int numPackedBytes = this.computeBytesPerRow(numColumns);
        byte[] dest = new byte[numColumns + 7];
        switch (this.precision) {
            case 1: {
                BilevelImage bilevelImage = (BilevelImage)this.image;
                ArrayConverter.decodePacked1Bit(buffer, 0, dest, 0, numPackedBytes);
                while (x <= x2) {
                    if (x >= x1) {
                        if (dest[offset] == 0) {
                            bilevelImage.putBlack(x - x1, y);
                        } else {
                            bilevelImage.putWhite(x - x1, y);
                        }
                    }
                    x += incr;
                    ++offset;
                }
                break;
            }
            case 2: {
                Gray8Image grayImage = (Gray8Image)this.image;
                ArrayConverter.convertPacked2BitIntensityTo8Bit(buffer, 0, dest, 0, numPackedBytes);
                while (x <= x2) {
                    if (x >= x1) {
                        grayImage.putByteSample(x - x1, y, dest[offset]);
                    }
                    x += incr;
                    ++offset;
                }
                break;
            }
            case 4: {
                Gray8Image grayImage = (Gray8Image)this.image;
                ArrayConverter.convertPacked4BitIntensityTo8Bit(buffer, 0, dest, 0, numPackedBytes);
                while (x <= x2) {
                    if (x >= x1) {
                        grayImage.putByteSample(x - x1, y, dest[offset]);
                    }
                    x += incr;
                    ++offset;
                }
                break;
            }
            case 8: {
                Gray8Image grayImage = (Gray8Image)this.image;
                while (x <= x2) {
                    if (x >= x1) {
                        grayImage.putSample(x - x1, y, buffer[offset]);
                    }
                    x += incr;
                    ++offset;
                }
                break;
            }
            case 16: {
                Gray16Image grayImage = (Gray16Image)this.image;
                while (x <= x2) {
                    if (x >= x1) {
                        int sample = (buffer[offset] & 0xFF) << 8;
                        grayImage.putSample(x, y, sample |= buffer[offset + 1] & 0xFF);
                    }
                    x += incr;
                    offset += 2;
                }
                break;
            }
        }
    }

    private void storeInterlacedAdam7GrayAlpha(int pass, int y, byte[] buffer) {
        int x = this.ADAM7_FIRST_COLUMN[pass];
        int incr = this.ADAM7_COLUMN_INCREMENT[pass];
        int x1 = this.getBoundsX1();
        int x2 = this.getBoundsX2();
        int offset = 0;
        switch (this.precision) {
            case 8: {
                Gray8Image grayImage = (Gray8Image)this.image;
                while (x <= x2) {
                    if (x >= x1) {
                        grayImage.putSample(x - x1, y, buffer[offset]);
                    }
                    x += incr;
                    offset += 2;
                }
                break;
            }
            case 16: {
                Gray16Image grayImage = (Gray16Image)this.image;
                while (x <= x2) {
                    if (x >= x1) {
                        int sample = (buffer[offset] & 0xFF) << 8;
                        grayImage.putSample(x, y, sample |= buffer[offset + 1] & 0xFF);
                    }
                    x += incr;
                    offset += 4;
                }
                break;
            }
        }
    }

    private void storeInterlacedAdam7Indexed(int pass, int y, byte[] buffer) {
        Paletted8Image palImage = (Paletted8Image)this.image;
        int x = this.ADAM7_FIRST_COLUMN[pass];
        int incr = this.ADAM7_COLUMN_INCREMENT[pass];
        int x1 = this.getBoundsX1();
        int x2 = this.getBoundsX2();
        int offset = 0;
        int numColumns = this.computeColumnsAdam7(pass);
        int numPackedBytes = this.computeBytesPerRow(numColumns);
        byte[] dest = new byte[numColumns + 7];
        switch (this.precision) {
            case 1: {
                ArrayConverter.decodePacked1Bit(buffer, 0, dest, 0, numPackedBytes);
                while (x <= x2) {
                    if (x >= x1) {
                        palImage.putByteSample(x - x1, y, dest[offset]);
                    }
                    x += incr;
                    ++offset;
                }
                break;
            }
            case 2: {
                ArrayConverter.decodePacked2Bit(buffer, 0, dest, 0, numPackedBytes);
                while (x <= x2) {
                    if (x >= x1) {
                        palImage.putByteSample(x - x1, y, dest[offset]);
                    }
                    x += incr;
                    ++offset;
                }
                break;
            }
            case 4: {
                ArrayConverter.decodePacked4Bit(buffer, 0, dest, 0, numPackedBytes);
                while (x <= x2) {
                    if (x >= x1) {
                        palImage.putByteSample(x - x1, y, dest[offset]);
                    }
                    x += incr;
                    ++offset;
                }
                break;
            }
            case 8: {
                while (x <= x2) {
                    if (x >= x1) {
                        palImage.putSample(x - x1, y, buffer[offset]);
                    }
                    x += incr;
                    ++offset;
                }
                break;
            }
        }
    }

    private void storeInterlacedAdam7Rgb(int pass, int y, byte[] buffer) {
        block5: {
            int offset;
            int incr;
            int x2;
            int x1;
            int x;
            block4: {
                x = this.ADAM7_FIRST_COLUMN[pass];
                x1 = this.getBoundsX1();
                x2 = this.getBoundsX2();
                incr = this.ADAM7_COLUMN_INCREMENT[pass];
                offset = 0;
                if (this.precision != 8) break block4;
                RGB24Image rgbImage = (RGB24Image)this.image;
                while (x <= x2) {
                    if (x >= x1) {
                        rgbImage.putSample(0, x, y, buffer[offset]);
                        rgbImage.putSample(1, x, y, buffer[offset + 1]);
                        rgbImage.putSample(2, x, y, buffer[offset + 2]);
                    }
                    x += incr;
                    offset += 3;
                }
                break block5;
            }
            if (this.precision != 16) break block5;
            RGB48Image rgbImage = (RGB48Image)this.image;
            while (x <= x2) {
                if (x >= x1) {
                    int red = (buffer[offset] & 0xFF) << 8;
                    rgbImage.putSample(0, x, y, red |= buffer[offset + 1] & 0xFF);
                    int green = (buffer[offset + 2] & 0xFF) << 8;
                    rgbImage.putSample(1, x, y, green |= buffer[offset + 3] & 0xFF);
                    int blue = (buffer[offset + 4] & 0xFF) << 8;
                    rgbImage.putSample(2, x, y, blue |= buffer[offset + 5] & 0xFF);
                }
                x += incr;
                offset += 6;
            }
        }
    }

    private void storeInterlacedAdam7RgbAlpha(int pass, int y, byte[] buffer) {
        block5: {
            int offset;
            int incr;
            int x2;
            int x1;
            int x;
            block4: {
                x = this.ADAM7_FIRST_COLUMN[pass];
                x1 = this.getBoundsX1();
                x2 = this.getBoundsX2();
                incr = this.ADAM7_COLUMN_INCREMENT[pass];
                offset = 0;
                if (this.precision != 8) break block4;
                RGB24Image rgbImage = (RGB24Image)this.image;
                while (x <= x2) {
                    if (x >= x1) {
                        rgbImage.putSample(0, x, y, buffer[offset]);
                        rgbImage.putSample(1, x, y, buffer[offset + 1]);
                        rgbImage.putSample(2, x, y, buffer[offset + 2]);
                    }
                    x += incr;
                    offset += 4;
                }
                break block5;
            }
            if (this.precision != 16) break block5;
            RGB48Image rgbImage = (RGB48Image)this.image;
            while (x <= x2) {
                if (x >= x1) {
                    int red = (buffer[offset] & 0xFF) << 8;
                    rgbImage.putSample(0, x, y, red |= buffer[offset + 1] & 0xFF);
                    int green = (buffer[offset + 2] & 0xFF) << 8;
                    rgbImage.putSample(1, x, y, green |= buffer[offset + 3] & 0xFF);
                    int blue = (buffer[offset + 4] & 0xFF) << 8;
                    rgbImage.putSample(2, x, y, blue |= buffer[offset + 5] & 0xFF);
                }
                x += incr;
                offset += 8;
            }
        }
    }

    private void storeNonInterlaced(int y, byte[] buffer) {
        switch (this.colorType) {
            case 0: {
                this.storeNonInterlacedGray(y, buffer);
                break;
            }
            case 4: {
                this.storeNonInterlacedGrayAlpha(y, buffer);
                break;
            }
            case 3: {
                this.storeNonInterlacedIndexed(y, buffer);
                break;
            }
            case 2: {
                this.storeNonInterlacedRgb(y, buffer);
                break;
            }
            case 6: {
                this.storeNonInterlacedRgbAlpha(y, buffer);
            }
        }
    }

    private void storeNonInterlacedGray(int y, byte[] buffer) {
        switch (this.precision) {
            case 1: {
                BilevelImage bilevelImage = (BilevelImage)this.image;
                int x1 = this.getBoundsX1();
                bilevelImage.putPackedBytes(0, y, this.getBoundsWidth(), buffer, x1 / 8, x1 % 8);
                break;
            }
            case 2: {
                Gray8Image grayImage = (Gray8Image)this.image;
                byte[] dest = new byte[this.width + 3];
                ArrayConverter.convertPacked2BitIntensityTo8Bit(buffer, 0, dest, 0, buffer.length);
                grayImage.putByteSamples(0, 0, y, this.getBoundsWidth(), 1, dest, this.getBoundsX1());
                break;
            }
            case 4: {
                Gray8Image grayImage = (Gray8Image)this.image;
                byte[] dest = new byte[this.width + 1];
                ArrayConverter.convertPacked4BitIntensityTo8Bit(buffer, 0, dest, 0, buffer.length);
                grayImage.putByteSamples(0, 0, y, this.getBoundsWidth(), 1, dest, this.getBoundsX1());
                break;
            }
            case 8: {
                Gray8Image grayImage = (Gray8Image)this.image;
                int offset = this.getBoundsX1();
                int x = 0;
                int k = this.getBoundsWidth();
                while (k > 0) {
                    grayImage.putSample(0, x++, y, buffer[offset++]);
                    --k;
                }
                break;
            }
            case 16: {
                Gray16Image grayImage = (Gray16Image)this.image;
                int offset = this.getBoundsX1();
                int x = 0;
                int k = this.getBoundsWidth();
                while (k > 0) {
                    int sample = (buffer[offset++] & 0xFF) << 8;
                    grayImage.putSample(x++, y, sample |= buffer[offset++] & 0xFF);
                    --k;
                }
                break;
            }
        }
    }

    private void storeNonInterlacedGrayAlpha(int y, byte[] buffer) {
        switch (this.precision) {
            case 8: {
                Gray8Image grayImage = (Gray8Image)this.image;
                int offset = this.getBoundsX1();
                int x = 0;
                int k = this.getBoundsWidth();
                while (k > 0) {
                    grayImage.putSample(0, x++, y, buffer[offset++]);
                    ++offset;
                    --k;
                }
                break;
            }
            case 16: {
                Gray16Image grayImage = (Gray16Image)this.image;
                int offset = this.getBoundsX1();
                int x = 0;
                int k = this.getBoundsWidth();
                while (k > 0) {
                    int sample = (buffer[offset++] & 0xFF) << 8;
                    grayImage.putSample(x++, y, sample |= buffer[offset++] & 0xFF);
                    offset += 2;
                    --k;
                }
                break;
            }
        }
    }

    private void storeNonInterlacedIndexed(int y, byte[] buffer) {
        Paletted8Image palImage = (Paletted8Image)this.image;
        switch (this.precision) {
            case 1: {
                byte[] dest = new byte[this.width + 7];
                ArrayConverter.decodePacked1Bit(buffer, 0, dest, 0, buffer.length);
                palImage.putByteSamples(0, 0, y, this.getBoundsWidth(), 1, dest, this.getBoundsX1());
                break;
            }
            case 2: {
                byte[] dest = new byte[this.width + 3];
                ArrayConverter.decodePacked2Bit(buffer, 0, dest, 0, buffer.length);
                palImage.putByteSamples(0, 0, y, this.getBoundsWidth(), 1, dest, this.getBoundsX1());
                break;
            }
            case 4: {
                byte[] dest = new byte[this.width + 1];
                ArrayConverter.decodePacked4Bit(buffer, 0, dest, 0, buffer.length);
                palImage.putByteSamples(0, 0, y, this.getBoundsWidth(), 1, dest, this.getBoundsX1());
                break;
            }
            case 8: {
                int offset = this.getBoundsX1();
                int x = 0;
                int k = this.getBoundsWidth();
                while (k > 0) {
                    palImage.putSample(0, x++, y, buffer[offset++]);
                    --k;
                }
                break;
            }
        }
    }

    private void storeNonInterlacedRgb(int y, byte[] buffer) {
        block3: {
            block2: {
                if (this.precision != 8) break block2;
                RGB24Image rgbImage = (RGB24Image)this.image;
                int offset = this.getBoundsX1() * 3;
                int x = 0;
                int k = this.getBoundsWidth();
                while (k > 0) {
                    rgbImage.putSample(0, x, y, buffer[offset++]);
                    rgbImage.putSample(1, x, y, buffer[offset++]);
                    rgbImage.putSample(2, x, y, buffer[offset++]);
                    ++x;
                    --k;
                }
                break block3;
            }
            if (this.precision != 16) break block3;
            RGB48Image rgbImage = (RGB48Image)this.image;
            int offset = this.getBoundsX1() * 6;
            int x = 0;
            int k = this.getBoundsWidth();
            while (k > 0) {
                int red = (buffer[offset++] & 0xFF) << 8;
                rgbImage.putSample(0, x, y, red |= buffer[offset++] & 0xFF);
                int green = (buffer[offset++] & 0xFF) << 8;
                rgbImage.putSample(1, x, y, green |= buffer[offset++] & 0xFF);
                int blue = (buffer[offset++] & 0xFF) << 8;
                rgbImage.putSample(2, x, y, blue |= buffer[offset++] & 0xFF);
                ++x;
                --k;
            }
        }
    }

    private void storeNonInterlacedRgbAlpha(int y, byte[] buffer) {
        switch (this.precision) {
            case 8: {
                RGB24Image rgbImage = (RGB24Image)this.image;
                int offset = this.getBoundsX1() * 3;
                int x = 0;
                int k = this.getBoundsWidth();
                while (k > 0) {
                    rgbImage.putSample(0, x, y, buffer[offset++]);
                    rgbImage.putSample(1, x, y, buffer[offset++]);
                    rgbImage.putSample(2, x, y, buffer[offset++]);
                    ++offset;
                    ++x;
                    --k;
                }
                break;
            }
            case 16: {
                RGB48Image rgbImage = (RGB48Image)this.image;
                int offset = this.getBoundsX1() * 8;
                int x = 0;
                int k = this.getBoundsWidth();
                while (k > 0) {
                    int red = (buffer[offset++] & 0xFF) << 8;
                    rgbImage.putSample(0, x, y, red |= buffer[offset++] & 0xFF);
                    int green = (buffer[offset++] & 0xFF) << 8;
                    rgbImage.putSample(1, x, y, green |= buffer[offset++] & 0xFF);
                    int blue = (buffer[offset++] & 0xFF) << 8;
                    rgbImage.putSample(2, x, y, blue |= buffer[offset++] & 0xFF);
                    offset += 2;
                    ++x;
                    --k;
                }
                break;
            }
        }
    }

    @Override
    public String suggestFileExtension(PixelImage image) {
        return ".png";
    }
}

