/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.codecs;

import java.io.DataOutput;
import java.io.IOException;
import net.sourceforge.jiu.codecs.CodecMode;
import net.sourceforge.jiu.codecs.ImageCodec;
import net.sourceforge.jiu.codecs.UnsupportedTypeException;
import net.sourceforge.jiu.data.BilevelImage;
import net.sourceforge.jiu.data.Gray8Image;
import net.sourceforge.jiu.data.IntegerImage;
import net.sourceforge.jiu.data.Palette;
import net.sourceforge.jiu.data.Paletted8Image;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.OperationFailedException;
import net.sourceforge.jiu.ops.WrongParameterException;

public class GIFCodec
extends ImageCodec {
    private static final int CODE_ARRAY_LENGTH = 5020;
    private static final int[] INTERLACING_FIRST_ROW;
    private static final int[] INTERLACING_INCREMENT;
    private static final int NUM_INTERLACING_PASSES = 4;
    private static final byte[] MAGIC_GIF87A;
    private static final byte[] MAGIC_GIF89A;
    private int backgroundColor;
    private byte[] block;
    private int bitOffset;
    private int bitsPerPixel;
    private int blockLength;
    private int clearCode;
    private int codeSize;
    private int[] currentCode;
    private int currentColumn;
    private int currentInterlacingPass;
    private int currentRow;
    private int endOfInformationCode;
    private boolean notFinished;
    private int freeCode;
    private IntegerImage imageToBeSaved;
    private int initialCodeSize;
    private boolean interlaced;
    private int height;
    private int maxCode;
    private int[] newCode;
    private int[] oldCode;
    private DataOutput out;
    private int processedRows;
    private int width;

    static {
        int[] nArray = new int[4];
        nArray[1] = 4;
        nArray[2] = 2;
        nArray[3] = 1;
        INTERLACING_FIRST_ROW = nArray;
        INTERLACING_INCREMENT = new int[]{8, 8, 4, 2};
        MAGIC_GIF87A = new byte[]{71, 73, 70, 56, 55, 97};
        MAGIC_GIF89A = new byte[]{71, 73, 70, 56, 57, 97};
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    public String[] getFileExtensions() {
        return new String[]{".gif"};
    }

    @Override
    public String getFormatName() {
        return "Compuserve GIF";
    }

    @Override
    public String[] getMimeTypes() {
        return new String[]{"image/gif"};
    }

    private int getNextSample() {
        int result = this.imageToBeSaved.getSample(this.currentColumn++, this.currentRow);
        if (this.currentColumn > this.getBoundsX2()) {
            this.setProgress(this.processedRows++, this.getBoundsHeight());
            this.currentColumn = this.getBoundsX1();
            if (this.isInterlaced()) {
                boolean done;
                this.currentRow += INTERLACING_INCREMENT[this.currentInterlacingPass];
                do {
                    if (this.currentRow <= this.getBoundsY2()) continue;
                    ++this.currentInterlacingPass;
                    if (this.currentInterlacingPass >= 4) continue;
                    this.currentRow = this.getBoundsY1() + INTERLACING_FIRST_ROW[this.currentInterlacingPass];
                } while (!(done = this.currentRow <= this.getBoundsY2() || this.currentInterlacingPass > 4));
            } else {
                ++this.currentRow;
            }
            this.notFinished = this.processedRows < this.getBoundsHeight();
        }
        return result;
    }

    private void initEncoding() throws IOException {
        this.imageToBeSaved = (IntegerImage)this.getImage();
        this.currentColumn = this.getBoundsX1();
        this.currentRow = this.getBoundsY1();
        this.processedRows = 0;
        this.currentInterlacingPass = 0;
        this.notFinished = true;
        this.block = new byte[255];
        this.currentCode = new int[5020];
        this.newCode = new int[5020];
        this.oldCode = new int[5020];
        this.initialCodeSize = this.bitsPerPixel == 1 ? 2 : this.bitsPerPixel;
    }

    public boolean isInterlaced() {
        return this.interlaced;
    }

    @Override
    public boolean isLoadingSupported() {
        return false;
    }

    @Override
    public boolean isSavingSupported() {
        return true;
    }

    @Override
    public void process() throws MissingParameterException, OperationFailedException {
        this.initModeFromIOObjects();
        if (this.getMode() == CodecMode.LOAD) {
            throw new OperationFailedException("Loading is not supported.");
        }
        this.save();
    }

    private void resetBlock() {
        int i = 0;
        while (i < this.block.length) {
            this.block[i] = 0;
            ++i;
        }
        this.blockLength = 0;
        this.bitOffset = 0;
    }

    private void resetEncoder() {
        this.codeSize = this.initialCodeSize + 1;
        this.clearCode = 1 << this.initialCodeSize;
        this.endOfInformationCode = this.clearCode + 1;
        this.freeCode = this.endOfInformationCode + 1;
        this.maxCode = (1 << this.codeSize) - 1;
        int i = 0;
        while (i < this.currentCode.length) {
            this.currentCode[i] = 0;
            ++i;
        }
    }

    private void save() throws MissingParameterException, OperationFailedException, UnsupportedTypeException, WrongParameterException {
        PixelImage image = this.getImage();
        if (image == null) {
            throw new MissingParameterException("No image available for saving.");
        }
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.setBoundsIfNecessary(this.width, this.height);
        this.width = this.getBoundsWidth();
        this.height = this.getBoundsHeight();
        if (image instanceof Paletted8Image) {
            Palette palette = ((Paletted8Image)image).getPalette();
            int numEntries = palette.getNumEntries();
            if (numEntries < 1 || numEntries > 256) {
                throw new WrongParameterException("Palette of image to be saved must have 1..256 entries.");
            }
            this.bitsPerPixel = 8;
            int i = 1;
            while (i <= 8) {
                if (1 << i >= numEntries) {
                    this.bitsPerPixel = i;
                    break;
                }
                ++i;
            }
        } else if (image instanceof Gray8Image) {
            this.bitsPerPixel = 8;
        } else if (image instanceof BilevelImage) {
            this.bitsPerPixel = 1;
        } else {
            throw new UnsupportedTypeException("Unsupported image type: " + image.getClass().getName());
        }
        this.out = this.getOutputAsDataOutput();
        if (this.out == null) {
            throw new MissingParameterException("Output stream / random access file parameter missing.");
        }
        try {
            this.writeStream();
        }
        catch (IOException ioe) {
            throw new OperationFailedException("I/O failure: " + ioe.toString());
        }
    }

    public void setBackgroundColor(int colorIndex) {
        this.backgroundColor = colorIndex;
    }

    public void setInterlacing(boolean useInterlacing) {
        this.interlaced = useInterlacing;
    }

    private void writeBlock() throws IOException {
        if (this.bitOffset > 0) {
            ++this.blockLength;
        }
        if (this.blockLength == 0) {
            return;
        }
        this.out.write(this.blockLength);
        this.out.write(this.block, 0, this.blockLength);
        this.resetBlock();
    }

    private void writeCode(int code) throws IOException {
        int bits;
        int remainingBits = this.codeSize;
        do {
            int bitsFree;
            bits = (bitsFree = 8 - this.bitOffset) < remainingBits ? bitsFree : remainingBits;
            int value = this.block[this.blockLength] & 0xFF;
            this.block[this.blockLength] = (byte)(value += (code & (1 << bits) - 1) << this.bitOffset);
            this.bitOffset += bits;
            if (this.bitOffset == 8) {
                ++this.blockLength;
                this.bitOffset = 0;
                if (this.blockLength == 255) {
                    this.writeBlock();
                }
            }
            code >>= bits;
        } while ((remainingBits -= bits) != 0);
    }

    private void writeComments() throws IOException {
        if (this.getNumComments() < 1) {
            return;
        }
        int commentIndex = 0;
        while (commentIndex < this.getNumComments()) {
            String comment = this.getComment(commentIndex);
            byte[] data = comment.getBytes();
            this.out.write(33);
            this.out.write(254);
            int offset = 0;
            while (offset < data.length) {
                int number = Math.min(data.length - offset, 255);
                this.out.write(number);
                this.out.write(data, offset, number);
                offset += number;
            }
            this.out.write(0);
            ++commentIndex;
        }
    }

    private void writeHeader() throws IOException {
        byte[] magic = this.getNumComments() > 0 ? MAGIC_GIF89A : MAGIC_GIF87A;
        this.out.write(magic);
        this.writeShort(this.width);
        this.writeShort(this.height);
        int depth = this.bitsPerPixel - 1;
        int packed = 0x80 | depth << 4 | depth;
        this.out.write(packed);
        this.out.write(this.backgroundColor);
        int pixelAspectRatio = 0;
        this.out.write(pixelAspectRatio);
        this.writePalette();
        this.writeComments();
        this.out.write(44);
        this.writeShort(0);
        this.writeShort(0);
        this.writeShort(this.width);
        this.writeShort(this.height);
        packed = 0;
        if (this.isInterlaced()) {
            packed |= 0x40;
        }
        this.out.write(packed);
    }

    private void writeImage() throws IOException {
        int suffixChar;
        this.out.write(this.initialCodeSize);
        this.resetBlock();
        this.resetEncoder();
        this.writeCode(this.clearCode);
        int prefixCode = suffixChar = this.getNextSample();
        block0: do {
            boolean endInnerLoop;
            suffixChar = this.getNextSample();
            int d = 1;
            int hashIndex = (prefixCode ^ suffixChar << 5) % 5003;
            do {
                if (this.currentCode[hashIndex] == 0) {
                    this.writeCode(prefixCode);
                    d = this.freeCode;
                    if (this.freeCode <= 4095) {
                        this.oldCode[hashIndex] = prefixCode;
                        this.newCode[hashIndex] = suffixChar;
                        this.currentCode[hashIndex] = this.freeCode++;
                    }
                    if (d > this.maxCode) {
                        if (this.codeSize < 12) {
                            ++this.codeSize;
                            this.maxCode = (1 << this.codeSize) - 1;
                        } else {
                            this.writeCode(this.clearCode);
                            this.resetEncoder();
                        }
                    }
                    prefixCode = suffixChar;
                    continue block0;
                }
                if (this.oldCode[hashIndex] == prefixCode && this.newCode[hashIndex] == suffixChar) {
                    prefixCode = this.currentCode[hashIndex];
                    endInnerLoop = true;
                    continue;
                }
                if ((hashIndex += (d += 2)) > 5003) {
                    hashIndex -= 5003;
                }
                endInnerLoop = false;
            } while (!endInnerLoop);
        } while (this.notFinished);
        this.writeCode(prefixCode);
        this.writeCode(this.endOfInformationCode);
        this.writeBlock();
    }

    private void writePalette() throws IOException {
        PixelImage image = this.getImage();
        if (image instanceof Paletted8Image) {
            Palette palette = ((Paletted8Image)image).getPalette();
            int numEntries = 1 << this.bitsPerPixel;
            int i = 0;
            while (i < numEntries) {
                if (i < palette.getNumEntries()) {
                    this.out.write(palette.getSample(0, i));
                    this.out.write(palette.getSample(1, i));
                    this.out.write(palette.getSample(2, i));
                } else {
                    this.out.write(0);
                    this.out.write(0);
                    this.out.write(0);
                }
                ++i;
            }
        } else if (image instanceof Gray8Image) {
            int i = 0;
            while (i < 256) {
                this.out.write(i);
                this.out.write(i);
                this.out.write(i);
                ++i;
            }
        } else if (image instanceof BilevelImage) {
            this.out.write(0);
            this.out.write(0);
            this.out.write(0);
            this.out.write(255);
            this.out.write(255);
            this.out.write(255);
        }
    }

    private void writeShort(int value) throws IOException {
        this.out.write(value & 0xFF);
        this.out.write(value >> 8 & 0xFF);
    }

    private void writeStream() throws IOException {
        this.initEncoding();
        this.writeHeader();
        this.writeImage();
        this.writeTrailer();
    }

    private void writeTrailer() throws IOException {
        this.out.write(0);
        this.out.write(59);
    }
}

