/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.codecs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.sourceforge.jiu.codecs.CodecMode;
import net.sourceforge.jiu.codecs.ImageCodec;
import net.sourceforge.jiu.codecs.InvalidFileStructureException;
import net.sourceforge.jiu.codecs.UnsupportedTypeException;
import net.sourceforge.jiu.codecs.WrongFileFormatException;
import net.sourceforge.jiu.data.BilevelImage;
import net.sourceforge.jiu.data.ByteChannelImage;
import net.sourceforge.jiu.data.Gray8Image;
import net.sourceforge.jiu.data.MemoryBilevelImage;
import net.sourceforge.jiu.data.MemoryPaletted8Image;
import net.sourceforge.jiu.data.MemoryRGB24Image;
import net.sourceforge.jiu.data.Palette;
import net.sourceforge.jiu.data.Paletted8Image;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.data.RGB24Image;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.OperationFailedException;
import net.sourceforge.jiu.util.ArrayConverter;

public class BMPCodec
extends ImageCodec {
    private int colorDepth;
    private int compression;
    private int dataOffset;
    private int imageHeight;
    private int imageWidth;
    private DataInput in;
    private DataOutput out;
    private Palette palette;

    @Override
    public String[] getFileExtensions() {
        return new String[]{".bmp", ".rle"};
    }

    @Override
    public String getFormatName() {
        return "Windows BMP";
    }

    @Override
    public String[] getMimeTypes() {
        return new String[]{"image/bmp", "image/x-ms-bmp"};
    }

    @Override
    public boolean isLoadingSupported() {
        return true;
    }

    @Override
    public boolean isSavingSupported() {
        return true;
    }

    private void load() throws MissingParameterException, OperationFailedException, UnsupportedTypeException, WrongFileFormatException {
        this.in = this.getInputAsDataInput();
        if (this.in == null) {
            throw new MissingParameterException("Input stream / random access file parameter missing.");
        }
        try {
            this.loadHeader();
            this.loadStream();
        }
        catch (IOException ioe) {
            throw new OperationFailedException("I/O failure: " + ioe.toString());
        }
    }

    private void loadCompressedPaletted4Stream() throws IOException {
        Paletted8Image image = (Paletted8Image)this.getImage();
        int imageBytesPerRow = this.imageWidth;
        int bytesPerRow = imageBytesPerRow;
        int mod = bytesPerRow % 4;
        if (mod != 0) {
            bytesPerRow += 4 - mod;
        }
        int COLUMNS = this.getBoundsWidth();
        int ROWS = this.imageHeight - this.getBoundsY1();
        int X1 = this.getBoundsX1();
        int processedRows = 0;
        byte[] row = new byte[bytesPerRow];
        int x = 0;
        int y = this.imageHeight - 1;
        boolean endOfBitmap = false;
        boolean delta = false;
        int newX = 0;
        int newY = 0;
        while (processedRows < ROWS) {
            block18: {
                int v2;
                int v1;
                block17: {
                    v1 = this.in.readUnsignedByte();
                    v2 = this.in.readUnsignedByte();
                    if (v1 != 0) break block17;
                    switch (v2) {
                        case 0: {
                            if (x != 0) {
                                x = bytesPerRow;
                                break;
                            }
                            break block18;
                        }
                        case 1: {
                            x = bytesPerRow;
                            endOfBitmap = true;
                            break;
                        }
                        case 2: {
                            delta = true;
                            newX = x + this.in.readUnsignedByte();
                            newY = y - this.in.readUnsignedByte();
                            x = bytesPerRow;
                            break;
                        }
                        default: {
                            int packed;
                            boolean paddingByte = (v2 + 1) / 2 % 2 != 0;
                            while (v2 > 1) {
                                packed = this.in.readUnsignedByte();
                                int sample1 = packed >> 4 & 0xF;
                                int sample2 = packed & 0xF;
                                row[x++] = (byte)sample1;
                                row[x++] = (byte)sample2;
                                v2 -= 2;
                            }
                            if (v2 == 1) {
                                packed = this.in.readUnsignedByte();
                                int sample = packed >> 4 & 0xF;
                                row[x++] = (byte)sample;
                            }
                            if (paddingByte) {
                                v2 = this.in.readUnsignedByte();
                                break;
                            }
                            break block18;
                        }
                    }
                    break block18;
                }
                byte sample1 = (byte)(v2 >> 4 & 0xF);
                byte sample2 = (byte)(v2 & 0xF);
                while (v1 > 1) {
                    row[x++] = sample1;
                    row[x++] = sample2;
                    v1 -= 2;
                }
                if (v1 == 1) {
                    row[x++] = sample1;
                }
            }
            if (x != bytesPerRow) continue;
            if (y <= this.getBoundsY2()) {
                image.putByteSamples(0, 0, y - this.getBoundsY1(), COLUMNS, 1, row, X1);
            }
            if (delta) {
                x = newX;
                y = newY;
            } else {
                x = 0;
                --y;
            }
            if (endOfBitmap) {
                processedRows = ROWS - 1;
            }
            this.setProgress(processedRows, ROWS);
            ++processedRows;
            delta = false;
        }
    }

    private void loadCompressedPaletted8Stream() throws IOException {
        Paletted8Image image = (Paletted8Image)this.getImage();
        int imageBytesPerRow = this.imageWidth;
        int bytesPerRow = imageBytesPerRow;
        int mod = bytesPerRow % 4;
        if (mod != 0) {
            bytesPerRow += 4 - mod;
        }
        int COLUMNS = this.getBoundsWidth();
        int ROWS = this.imageHeight - this.getBoundsY1();
        int X1 = this.getBoundsX1();
        int processedRows = 0;
        byte[] row = new byte[bytesPerRow];
        int x = 0;
        int y = this.imageHeight - 1;
        boolean endOfBitmap = false;
        boolean delta = false;
        int newX = 0;
        int newY = 0;
        while (processedRows < ROWS) {
            block16: {
                int v2;
                int v1;
                block15: {
                    v1 = this.in.readUnsignedByte();
                    v2 = this.in.readUnsignedByte();
                    if (v1 != 0) break block15;
                    switch (v2) {
                        case 0: {
                            if (x != 0) {
                                x = bytesPerRow;
                                break;
                            }
                            break block16;
                        }
                        case 1: {
                            x = bytesPerRow;
                            endOfBitmap = true;
                            break;
                        }
                        case 2: {
                            delta = true;
                            newX = x + this.in.readUnsignedByte();
                            newY = y - this.in.readUnsignedByte();
                            x = bytesPerRow;
                            break;
                        }
                        default: {
                            boolean paddingByte = v2 % 2 != 0;
                            while (v2-- > 0) {
                                row[x++] = (byte)this.in.readUnsignedByte();
                            }
                            if (paddingByte) {
                                v2 = this.in.readUnsignedByte();
                                break;
                            }
                            break block16;
                        }
                    }
                    break block16;
                }
                byte value = (byte)v2;
                while (v1-- > 0) {
                    row[x++] = value;
                }
            }
            if (x != bytesPerRow) continue;
            if (y <= this.getBoundsY2()) {
                image.putByteSamples(0, 0, y - this.getBoundsY1(), COLUMNS, 1, row, X1);
            }
            if (delta) {
                x = newX;
                y = newY;
            } else {
                x = 0;
                --y;
            }
            if (endOfBitmap) {
                processedRows = ROWS - 1;
            }
            this.setProgress(processedRows, ROWS);
            ++processedRows;
            delta = false;
        }
    }

    private void loadHeader() throws IOException, MissingParameterException, OperationFailedException, UnsupportedTypeException, WrongFileFormatException {
        byte[] header = new byte[54];
        this.in.readFully(header);
        if (header[0] != 66 || header[1] != 77) {
            throw new WrongFileFormatException("Not a BMP file (first two bytes are not 0x42 0x4d).");
        }
        this.dataOffset = ArrayConverter.getIntLE(header, 10);
        if (this.dataOffset < 54) {
            throw new InvalidFileStructureException("BMP data expected to be 54dec or larger, got " + this.dataOffset);
        }
        this.imageWidth = ArrayConverter.getIntLE(header, 18);
        this.imageHeight = ArrayConverter.getIntLE(header, 22);
        if (this.imageWidth < 1 || this.imageHeight < 1) {
            throw new InvalidFileStructureException("BMP image width and height must be larger than 0, got " + this.imageWidth + " x " + this.imageHeight);
        }
        short planes = ArrayConverter.getShortLE(header, 26);
        if (planes != 1) {
            throw new InvalidFileStructureException("Can only handle BMP number of planes = 1, got " + planes);
        }
        this.colorDepth = ArrayConverter.getShortLE(header, 28);
        if (this.colorDepth != 1 && this.colorDepth != 4 && this.colorDepth != 8 && this.colorDepth != 24) {
            throw new InvalidFileStructureException("Unsupported BMP color depth: " + this.colorDepth);
        }
        this.compression = ArrayConverter.getIntLE(header, 30);
        if (!(this.compression == 0 || this.compression == 1 && this.colorDepth == 8 || this.compression == 2 && this.colorDepth == 4)) {
            throw new InvalidFileStructureException("Unsupported BMP compression type / color depth combination: " + this.compression + " / " + this.colorDepth);
        }
        float dpiXValue = (float)ArrayConverter.getIntLE(header, 38) / 39.37008f;
        float dpiYValue = (float)ArrayConverter.getIntLE(header, 42) / 39.37008f;
        this.setDpi((int)dpiXValue, (int)dpiYValue);
    }

    private void loadStream() throws IOException, MissingParameterException, OperationFailedException, UnsupportedTypeException {
        int bytesToSkip;
        this.setBoundsIfNecessary(this.imageWidth, this.imageHeight);
        this.checkBounds(this.imageWidth, this.imageHeight);
        if (this.colorDepth <= 8) {
            int headerSpaceLeft = this.dataOffset - 54;
            int numPaletteEntries = 1 << this.colorDepth;
            int expectedPaletteSize = 4 * numPaletteEntries;
            bytesToSkip = headerSpaceLeft - expectedPaletteSize;
            if (bytesToSkip < 0) {
                throw new InvalidFileStructureException("Not enough space in header for palette with " + numPaletteEntries + "entries.");
            }
            this.palette = new Palette(numPaletteEntries);
            int index = 0;
            while (index < numPaletteEntries) {
                int blue = this.in.readUnsignedByte();
                int green = this.in.readUnsignedByte();
                int red = this.in.readUnsignedByte();
                this.in.readUnsignedByte();
                this.palette.put(index, red, green, blue);
                ++index;
            }
        } else {
            bytesToSkip = this.dataOffset - 54;
        }
        while (bytesToSkip > 0) {
            int skipped = this.in.skipBytes(bytesToSkip);
            if (skipped <= 0) continue;
            bytesToSkip -= skipped;
        }
        PixelImage image = this.getImage();
        if (image == null) {
            switch (this.colorDepth) {
                case 1: {
                    this.setImage(new MemoryBilevelImage(this.getBoundsWidth(), this.getBoundsHeight()));
                    break;
                }
                case 4: 
                case 8: {
                    this.setImage(new MemoryPaletted8Image(this.getBoundsWidth(), this.getBoundsHeight(), this.palette));
                    break;
                }
                case 24: {
                    this.setImage(new MemoryRGB24Image(this.getBoundsWidth(), this.getBoundsHeight()));
                }
            }
        }
        if (this.compression == 0) {
            this.loadUncompressedStream();
        } else if (this.compression == 1) {
            this.loadCompressedPaletted8Stream();
        } else if (this.compression == 2) {
            this.loadCompressedPaletted4Stream();
        }
    }

    private void loadUncompressedBilevelStream() throws IOException, OperationFailedException {
        if (this.getBoundsX1() % 8 != 0) {
            throw new OperationFailedException("When loading bilevel images, horizontal X1 bounds must be a multiple of 8; got " + this.getBoundsX1());
        }
        BilevelImage image = (BilevelImage)this.getImage();
        int imageBytesPerRow = (this.imageWidth + 7) / 8;
        int bytesPerRow = imageBytesPerRow;
        int mod = bytesPerRow % 4;
        if (mod != 0) {
            bytesPerRow += 4 - mod;
        }
        int bottomRowsToSkip = this.imageHeight - 1 - this.getBoundsY2();
        int bytesToSkip = bottomRowsToSkip * bytesPerRow;
        while (bytesToSkip > 0) {
            int skipped = this.in.skipBytes(bytesToSkip);
            if (skipped <= 0) continue;
            bytesToSkip -= skipped;
        }
        int COLUMNS = this.getBoundsWidth();
        int ROWS = this.getBoundsHeight();
        int SRC_OFFSET = this.getBoundsX1() / 8;
        int SRC_BIT_OFFSET = this.getBoundsX1() % 8;
        int y = image.getHeight() - 1;
        int processedRows = 0;
        byte[] row = new byte[bytesPerRow];
        while (processedRows < ROWS) {
            this.in.readFully(row);
            image.putPackedBytes(0, y, COLUMNS, row, SRC_OFFSET, SRC_BIT_OFFSET);
            --y;
            this.setProgress(processedRows, ROWS);
            ++processedRows;
        }
    }

    private void loadUncompressedPaletted4Stream() throws IOException {
        Paletted8Image image = (Paletted8Image)this.getImage();
        int imageBytesPerRow = (this.imageWidth + 1) / 2;
        int bytesPerRow = imageBytesPerRow;
        int mod = bytesPerRow % 4;
        if (mod != 0) {
            bytesPerRow += 4 - mod;
        }
        int bottomRowsToSkip = this.imageHeight - 1 - this.getBoundsY2();
        int bytesToSkip = bottomRowsToSkip * bytesPerRow;
        while (bytesToSkip > 0) {
            int skipped = this.in.skipBytes(bytesToSkip);
            if (skipped <= 0) continue;
            bytesToSkip -= skipped;
        }
        int COLUMNS = this.getBoundsWidth();
        int ROWS = this.getBoundsHeight();
        int X1 = this.getBoundsX1();
        int y = image.getHeight() - 1;
        int processedRows = 0;
        byte[] row = new byte[bytesPerRow];
        byte[] samples = new byte[bytesPerRow * 2];
        while (processedRows < ROWS) {
            this.in.readFully(row);
            ArrayConverter.decodePacked4Bit(row, 0, samples, 0, row.length);
            image.putByteSamples(0, 0, y, COLUMNS, 1, samples, X1);
            --y;
            this.setProgress(processedRows, ROWS);
            ++processedRows;
        }
    }

    private void loadUncompressedPaletted8Stream() throws IOException {
        Paletted8Image image = (Paletted8Image)this.getImage();
        int imageBytesPerRow = this.imageWidth;
        int bytesPerRow = imageBytesPerRow;
        int mod = bytesPerRow % 4;
        if (mod != 0) {
            bytesPerRow += 4 - mod;
        }
        int bottomRowsToSkip = this.imageHeight - 1 - this.getBoundsY2();
        int bytesToSkip = bottomRowsToSkip * bytesPerRow;
        while (bytesToSkip > 0) {
            int skipped = this.in.skipBytes(bytesToSkip);
            if (skipped <= 0) continue;
            bytesToSkip -= skipped;
        }
        int COLUMNS = this.getBoundsWidth();
        int ROWS = this.getBoundsHeight();
        int X1 = this.getBoundsX1();
        int y = image.getHeight() - 1;
        int processedRows = 0;
        byte[] row = new byte[bytesPerRow];
        while (processedRows < ROWS) {
            this.in.readFully(row);
            image.putByteSamples(0, 0, y, COLUMNS, 1, row, X1);
            --y;
            this.setProgress(processedRows, ROWS);
            ++processedRows;
        }
    }

    private void loadUncompressedRgb24Stream() throws IOException {
        RGB24Image image = (RGB24Image)this.getImage();
        int imageBytesPerRow = this.imageWidth * 3;
        int bytesPerRow = imageBytesPerRow;
        int mod = bytesPerRow % 4;
        if (mod != 0) {
            bytesPerRow += 4 - mod;
        }
        int bottomRowsToSkip = this.imageHeight - 1 - this.getBoundsY2();
        int bytesToSkip = bottomRowsToSkip * bytesPerRow;
        while (bytesToSkip > 0) {
            int skipped = this.in.skipBytes(bytesToSkip);
            if (skipped <= 0) continue;
            bytesToSkip -= skipped;
        }
        int COLUMNS = this.getBoundsWidth();
        int ROWS = this.getBoundsHeight();
        int X1 = this.getBoundsX1();
        int y = image.getHeight() - 1;
        int processedRows = 0;
        byte[] row = new byte[bytesPerRow];
        byte[] samples = new byte[COLUMNS];
        while (processedRows < ROWS) {
            this.in.readFully(row);
            int x = X1 * 3 + 2;
            int i = 0;
            while (i < COLUMNS) {
                samples[i] = row[x];
                x += 3;
                ++i;
            }
            image.putByteSamples(0, 0, y, COLUMNS, 1, samples, 0);
            x = X1 * 3 + 1;
            i = 0;
            while (i < COLUMNS) {
                samples[i] = row[x];
                x += 3;
                ++i;
            }
            image.putByteSamples(1, 0, y, COLUMNS, 1, samples, 0);
            x = X1 * 3;
            i = 0;
            while (i < COLUMNS) {
                samples[i] = row[x];
                x += 3;
                ++i;
            }
            image.putByteSamples(2, 0, y, COLUMNS, 1, samples, 0);
            --y;
            this.setProgress(processedRows, ROWS);
            ++processedRows;
        }
    }

    private void loadUncompressedStream() throws IOException, OperationFailedException {
        switch (this.colorDepth) {
            case 1: {
                this.loadUncompressedBilevelStream();
                break;
            }
            case 4: {
                this.loadUncompressedPaletted4Stream();
                break;
            }
            case 8: {
                this.loadUncompressedPaletted8Stream();
                break;
            }
            case 24: {
                this.loadUncompressedRgb24Stream();
            }
        }
    }

    @Override
    public void process() throws MissingParameterException, OperationFailedException {
        this.initModeFromIOObjects();
        if (this.getMode() == CodecMode.LOAD) {
            this.load();
        } else {
            this.save();
        }
    }

    private void save() throws MissingParameterException, OperationFailedException, UnsupportedTypeException {
        PixelImage image = this.getImage();
        if (image == null) {
            throw new MissingParameterException("No image available.");
        }
        if (!(image instanceof Paletted8Image || image instanceof Gray8Image || image instanceof BilevelImage || image instanceof RGB24Image)) {
            throw new UnsupportedTypeException("Unsupported image type: " + image.getClass().getName());
        }
        this.out = this.getOutputAsDataOutput();
        if (this.out == null) {
            throw new MissingParameterException("Output stream / random access file parameter missing.");
        }
        try {
            this.writeStream();
        }
        catch (IOException ioe) {
            throw new OperationFailedException("I/O failure: " + ioe.toString());
        }
    }

    @Override
    public String suggestFileExtension(PixelImage image) {
        return ".bmp";
    }

    private void writeHeader(PixelImage image, int filesize, int offset, int numBits) throws IOException {
        this.out.write(66);
        this.out.write(77);
        this.writeInt(filesize);
        this.writeShort(0);
        this.writeShort(0);
        this.writeInt(offset);
        this.writeInt(40);
        this.writeInt(this.getBoundsWidth());
        this.writeInt(this.getBoundsHeight());
        this.writeShort(1);
        this.writeShort(numBits);
        this.writeInt(0);
        this.writeInt(filesize - offset);
        this.writeInt((int)((float)this.getDpiX() * 39.37008f));
        this.writeInt((int)((float)this.getDpiY() * 39.37008f));
        this.writeInt(0);
        this.writeInt(0);
    }

    private void writeInt(int value) throws IOException {
        this.out.write(value & 0xFF);
        this.out.write(value >> 8 & 0xFF);
        this.out.write(value >> 16 & 0xFF);
        this.out.write(value >> 24 & 0xFF);
    }

    private void writePalette() throws IOException {
        PixelImage pi = this.getImage();
        if (pi == null) {
            return;
        }
        if (pi instanceof Paletted8Image) {
            Palette palette = ((Paletted8Image)pi).getPalette();
            int i = 0;
            while (i < 256) {
                if (i < palette.getNumEntries()) {
                    this.out.write(palette.getSample(2, i));
                    this.out.write(palette.getSample(1, i));
                    this.out.write(palette.getSample(0, i));
                    this.out.write(0);
                } else {
                    this.out.writeInt(0);
                }
                ++i;
            }
        }
        if (pi instanceof Gray8Image) {
            int i = 0;
            while (i < 256) {
                this.out.write(i);
                this.out.write(i);
                this.out.write(i);
                this.out.write(0);
                ++i;
            }
        }
        if (pi instanceof BilevelImage) {
            int i = 0;
            while (i < 2) {
                this.out.write(i * 255);
                this.out.write(i * 255);
                this.out.write(i * 255);
                this.out.write(0);
                ++i;
            }
        }
    }

    private void writeShort(int value) throws IOException {
        this.out.write(value & 0xFF);
        this.out.write(value >> 8 & 0xFF);
    }

    private void writeStream() throws IOException {
        PixelImage image = this.getImage();
        this.setBoundsIfNecessary(image.getWidth(), image.getHeight());
        int width = this.getBoundsWidth();
        int height = this.getBoundsHeight();
        ByteChannelImage bcimg = null;
        BilevelImage bilevelImage = null;
        RGB24Image rgbimg = null;
        int bytesPerRow = 0;
        int offset = 54;
        int numBits = 0;
        int numPackedBytes = 0;
        if (image instanceof Paletted8Image || image instanceof Gray8Image) {
            bcimg = (ByteChannelImage)image;
            bytesPerRow = width;
            offset += 1024;
            numBits = 8;
        } else if (image instanceof BilevelImage) {
            bilevelImage = (BilevelImage)image;
            bytesPerRow = numPackedBytes = (width + 7) / 8;
            offset += 8;
            numBits = 1;
        } else if (image instanceof RGB24Image) {
            rgbimg = (RGB24Image)image;
            bytesPerRow = width * 3;
            numBits = 24;
        }
        if (bytesPerRow % 4 != 0) {
            bytesPerRow = (bytesPerRow + 3) / 4 * 4;
        }
        int filesize = offset + bytesPerRow * height;
        this.writeHeader(image, filesize, offset, numBits);
        this.writePalette();
        byte[] row = new byte[bytesPerRow];
        int X1 = this.getBoundsX1();
        int y = this.getBoundsY2();
        int processed = 0;
        while (processed < height) {
            if (bilevelImage != null) {
                bilevelImage.getPackedBytes(X1, y, width, row, 0, 0);
            } else if (bcimg != null) {
                bcimg.getByteSamples(0, 0, y, width, 1, row, 0);
            } else if (rgbimg != null) {
                int offs = 0;
                int x = X1;
                while (x < X1 + width) {
                    row[offs++] = rgbimg.getByteSample(2, x, y);
                    row[offs++] = rgbimg.getByteSample(1, x, y);
                    row[offs++] = rgbimg.getByteSample(0, x, y);
                    ++x;
                }
            }
            this.out.write(row);
            this.setProgress(processed, height);
            if (this.getAbort()) break;
            --y;
            ++processed;
        }
        this.close();
    }
}

