/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.apps;

import java.io.File;
import net.sourceforge.jiu.codecs.ImageLoader;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.gui.awt.ToolkitLoader;
import net.sourceforge.jiu.ops.BatchProcessorOperation;

public class ImageLoadTester
extends BatchProcessorOperation {
    private boolean useToolkit;
    private int numFailed;
    private int numSuccess;

    public static void main(String[] args) throws Exception {
        ImageLoadTester tester = new ImageLoadTester();
        boolean useToolkit = true;
        int i = 0;
        while (i < args.length) {
            String name = args[i];
            if ("--notoolkit".equals(name)) {
                useToolkit = false;
            } else {
                File file = new File(name);
                if (file.isFile()) {
                    tester.addInputFileName(name);
                } else if (file.isDirectory()) {
                    tester.addDirectoryTree(name);
                }
            }
            ++i;
        }
        tester.setUseToolkit(useToolkit);
        tester.process();
        int total = tester.numFailed + tester.numSuccess;
        System.out.println("OK:     " + tester.numSuccess + " (" + (double)tester.numSuccess * 100.0 / (double)total + " %)");
        System.out.println("Failed: " + tester.numFailed + " (" + (double)tester.numFailed * 100.0 / (double)total + " %)");
        System.out.println("Total:  " + total + " (100.0 %)");
    }

    @Override
    public void processFile(String inputDirectory, String inputFileName, String outputDirectory) {
        PixelImage image;
        File file = new File(inputDirectory, inputFileName);
        String name = file.getAbsolutePath();
        System.out.print(name);
        try {
            image = this.useToolkit ? ToolkitLoader.loadViaToolkitOrCodecs(name, true, null) : ImageLoader.load(name);
        }
        catch (Exception e) {
            image = null;
        }
        if (image == null) {
            ++this.numFailed;
            System.out.println(" Failed.");
        } else {
            ++this.numSuccess;
            System.out.println(" OK. Width=" + image.getWidth() + ", height=" + image.getHeight() + " pixels.");
        }
    }

    public void setUseToolkit(boolean newValue) {
        this.useToolkit = newValue;
    }
}

