/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.apps;

import java.text.NumberFormat;
import java.util.Locale;
import net.sourceforge.jiu.apps.Strings;
import net.sourceforge.jiu.data.BilevelImage;
import net.sourceforge.jiu.data.GrayImage;
import net.sourceforge.jiu.data.PalettedImage;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.data.RGBImage;

public class ImageDescriptionCreator {
    private ImageDescriptionCreator() {
    }

    private static String formatNumber(long value, Locale locale) {
        if (locale == null) {
            return Long.toString(value);
        }
        return NumberFormat.getInstance(locale).format(value);
    }

    public static String getDescription(PixelImage image, Locale locale, Strings strings) {
        StringBuffer result = new StringBuffer();
        result.append(strings.get(225));
        result.append(": ");
        result.append(strings.get(ImageDescriptionCreator.getImageType(image)));
        result.append(", ");
        result.append(strings.get(227));
        result.append(": ");
        int width = image.getWidth();
        int height = image.getHeight();
        result.append(ImageDescriptionCreator.formatNumber(width, locale));
        result.append(" x ");
        result.append(ImageDescriptionCreator.formatNumber(height, locale));
        result.append(" (");
        result.append(ImageDescriptionCreator.formatNumber(width * height, locale));
        result.append("), ");
        result.append(strings.get(220));
        result.append(": ");
        result.append(ImageDescriptionCreator.formatNumber(image.getBitsPerPixel(), locale));
        return result.toString();
    }

    private static int getImageType(PixelImage image) {
        int stringIndex = 224;
        if (image instanceof BilevelImage) {
            stringIndex = 221;
            return 221;
        }
        if (image instanceof GrayImage) {
            stringIndex = 222;
            return 222;
        }
        if (image instanceof PalettedImage) {
            stringIndex = 226;
            return 226;
        }
        if (image instanceof RGBImage) {
            stringIndex = 223;
            return 223;
        }
        return stringIndex;
    }
}

