/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.apps;

import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import net.sourceforge.jiu.color.adjustment.Contrast;
import net.sourceforge.jiu.color.promotion.PromotionRGB24;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.data.RGB24Image;
import net.sourceforge.jiu.geometry.Resample;
import net.sourceforge.jiu.gui.awt.ToolkitLoader;
import net.sourceforge.jiu.ops.BatchProcessorOperation;
import net.sourceforge.jiu.ops.OperationFailedException;

public class ColorIndexer
extends BatchProcessorOperation {
    private int maxLength = 256;
    private int contrastChange = 100;
    private NumberFormat formatter = new DecimalFormat("#.##");
    public static final int BLACK = 0;
    public static final int RED = 4;
    public static final int GREEN = 2;
    public static final int BLUE = 1;
    public static final int YELLOW = 6;
    public static final int MAGENTA = 5;
    public static final int CYAN = 3;
    public static final int WHITE = 7;
    public static final String[] COLOR_NAMES = new String[]{"black", "blue", "green", "cyan", "red", "magenta", "yellow", "white"};

    public static void main(String[] args) {
        ColorIndexer indexer = new ColorIndexer();
        int i = 0;
        while (i < args.length) {
            String name = args[i];
            File file = new File(name);
            if (file.isFile()) {
                indexer.addInputFileName(name);
            } else if (file.isDirectory()) {
                indexer.addDirectoryTree(name);
            }
            ++i;
        }
        indexer.process();
        System.out.println("Done.");
    }

    private PixelImage convertToRgb24(PixelImage in) {
        if (in == null) {
            return null;
        }
        if (in instanceof RGB24Image) {
            return in;
        }
        try {
            PromotionRGB24 pr = new PromotionRGB24();
            pr.setInputImage(in);
            pr.process();
            return pr.getOutputImage();
        }
        catch (OperationFailedException ofe) {
            return null;
        }
    }

    private PixelImage adjustColor(PixelImage img) {
        if (img == null || this.contrastChange == 0) {
            return img;
        }
        try {
            Contrast con = new Contrast();
            con.setInputImage(img);
            con.setContrast(this.contrastChange);
            con.process();
            return con.getOutputImage();
        }
        catch (OperationFailedException ofe) {
            return null;
        }
    }

    private PixelImage scale(PixelImage in) {
        if (in == null) {
            return null;
        }
        if (in.getWidth() <= this.maxLength && in.getHeight() <= this.maxLength) {
            return in;
        }
        try {
            Resample res = new Resample();
            res.setFilter(5);
            res.setInputImage(in);
            float thumbRatio = 1.0f;
            float imageRatio = (float)in.getWidth() / (float)in.getHeight();
            int width = this.maxLength;
            int height = this.maxLength;
            if (thumbRatio < imageRatio) {
                height = (int)((float)this.maxLength / imageRatio);
            } else {
                width = (int)((float)this.maxLength * imageRatio);
            }
            res.setSize(width, height);
            res.process();
            return res.getOutputImage();
        }
        catch (OperationFailedException ofe) {
            return null;
        }
    }

    private int[] count(PixelImage image) {
        if (image == null) {
            return null;
        }
        RGB24Image in = (RGB24Image)image;
        int[] result = new int[8];
        int y = 0;
        while (y < image.getHeight()) {
            int x = 0;
            while (x < image.getWidth()) {
                int index;
                int red = in.getSample(0, x, y) >> 7;
                int green = in.getSample(1, x, y) >> 7;
                int blue = in.getSample(2, x, y) >> 7;
                int n = index = red << 2 | green << 1 | blue;
                result[n] = result[n] + 1;
                ++x;
            }
            ++y;
        }
        return result;
    }

    private void store(String name, int[] occ) {
        if (name == null || occ == null) {
            return;
        }
        int sum = 0;
        int i = 0;
        while (i < occ.length) {
            sum += occ[i];
            ++i;
        }
        System.out.print(name);
        System.out.print(';');
        i = 0;
        while (i < occ.length) {
            float rel = (float)occ[i] / (float)sum;
            if (!(rel < 0.01f)) {
                System.out.print(String.valueOf(COLOR_NAMES[i]) + " = " + this.formatter.format(rel) + ";");
            }
            ++i;
        }
        System.out.println();
    }

    @Override
    public void processFile(String inputDirectory, String inputFileName, String outputDirectory) {
        File dir = new File(inputDirectory);
        File file = new File(dir, inputFileName);
        String name = file.getAbsolutePath();
        PixelImage image = ToolkitLoader.loadViaToolkitOrCodecs(name);
        image = this.convertToRgb24(image);
        image = this.scale(image);
        image = this.adjustColor(image);
        int[] occur = this.count(image);
        this.store(name, occur);
    }
}

