/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.tablerecognizer.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLManager {
    private static Logger logger = Logger.getLogger(XMLManager.class.getName());
    private Document document = null;

    public XMLManager() {
    }

    public XMLManager(String param, boolean parse) {
        this.document = parse ? this.parse(param) : this.createDocument(param);
    }

    public Document parse(String xmlfile) {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            this.document = docBuilder.parse(new File(xmlfile));
        }
        catch (FileNotFoundException fe) {
            logger.severe("XML File not found");
            logger.severe(fe.fillInStackTrace().getMessage());
        }
        catch (SAXParseException err) {
            logger.severe("** Parsing error, line " + err.getLineNumber() + ", uri " + err.getSystemId());
            logger.severe(err.getMessage());
        }
        catch (SAXException e) {
            logger.severe(e.getLocalizedMessage());
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, t.getMessage());
        }
        return this.document;
    }

    public NodeList getElementsByTagName(Document document, String tagname) {
        return document.getElementsByTagName(tagname);
    }

    public Document createDocument(String root_tag) {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            DOMImplementation impl = docBuilder.getDOMImplementation();
            this.document = impl.createDocument(null, root_tag, null);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, t.getMessage());
        }
        return this.document;
    }

    public String getTextContent(Node node) {
        return node.getTextContent();
    }

    public NamedNodeMap getAttributes(Node node) {
        NamedNodeMap nm = node.getAttributes();
        return nm;
    }

    public Node addTextNode(Element element, String text) {
        element.setTextContent(text);
        return element;
    }

    public Node addAttribue(Element element, String attribute, String value) {
        element.setAttribute(attribute, value);
        return element;
    }

    public Node createElement(Document document, String tag_name) {
        Element element = document.createElement(tag_name);
        return element;
    }

    public Node appendNode(Node child, Node parent) {
        return parent.appendChild(child);
    }

    public static void serializeXmlDom(Document document, PrintWriter out) throws Exception {
        if (document == null || out == null) {
            return;
        }
        DOMSource domSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(out);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer serializer = tf.newTransformer();
        serializer.setOutputProperty("encoding", "UTF-8");
        serializer.setOutputProperty("indent", "yes");
        serializer.transform(domSource, streamResult);
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }
}

