/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.tablerecognizer.block;

import de.dfki.tablerecognizer.block.Block;
import de.dfki.tablerecognizer.block.BoundingBox;
import de.dfki.tablerecognizer.block.Line;
import de.dfki.tablerecognizer.block.WordList;
import de.dfki.tablerecognizer.block.WordStatus;
import de.dfki.tablerecognizer.parameters.TableRecognizerParameters;
import java.util.logging.Logger;

public class Word
extends BoundingBox
implements Comparable {
    private String contents = null;
    private int id = 0;
    private WordStatus status = WordStatus.NOT_EXPANDED;
    private Word previous = null;
    private Word next = null;
    private WordList overlapAbove = null;
    private WordList overlapBelow = null;
    private Block block = null;
    private int spaceLeft = -1;
    private int spaceRight = -1;
    private int spacelength = 0;
    private int numbOverlappingWordsUp = 0;
    private int numbOverlappingWordsDown = 0;
    private Word bestOverlappingDown = null;
    private Word bestOverlappingUp = null;
    private Word firstOverlappingAbove = null;
    private Word lastOverlappingAbove = null;
    private Word firstOverlappingDown = null;
    private Word lastOverlappingDown = null;
    private Word nextOverlapping = null;
    private int overlapValue = 0;
    private Word previousInLine = null;
    private Word nextInLine = null;
    private Word nextInBlock = null;
    private Word previousInBlock = null;
    private Word nextindoc = null;
    private Line line = null;

    private static Logger log() {
        return Logger.getLogger(Word.class.getName());
    }

    public Word() {
    }

    public Word(int x0, int y0, int x1, int y1, String content) {
        super(x0, y0, x1, y1);
        this.contents = content;
    }

    public static int evalAlignment(Word a, Word b) {
        int alignment = 0;
        int spacelength = Math.max(a.getSpacelength(), b.getSpacelength());
        if ((float)Math.abs(a.getX0() - b.getX0()) <= (float)spacelength * TableRecognizerParameters.horizontal_align_eps) {
            alignment |= TableRecognizerParameters.overlapvalue_left_align;
        }
        if ((float)Math.abs(a.getX1() - b.getX1()) <= (float)spacelength * TableRecognizerParameters.horizontal_align_eps) {
            alignment |= TableRecognizerParameters.overlapvalue_right_align;
        }
        Word.log().finest("Alignment between word a(ID,Content)|( " + a.getId() + "," + a.getContent() + ") and word b(ID,Content)| (" + b.getId() + "," + b.getContent() + ") is : " + alignment);
        return alignment;
    }

    public void evalOverlapValue() {
        int ovlval = 0;
        int alignment = 0;
        if (this.getPreviousInLine() == null && this.getNextInLine() == null || (this.getPreviousInLine() == null || this.getPreviousInLine().getBlock() != this.getBlock()) && (this.getNextInLine() == null || this.getNextInLine().getBlock() != this.getBlock())) {
            this.setOverlapValue(ovlval);
            return;
        }
        if (this.getNumbOverlappingWordsUp() == 1 && this.getFirstOverlappingAbove().getNumbOverlappingWordsDown() == 1) {
            this.setBestOverlappingUp(this.getFirstOverlappingAbove());
            this.getBestOverlappingUp().setBestOverlappingDown(this);
            ovlval |= TableRecognizerParameters.overlapvalue_one_to_one;
            alignment = Word.evalAlignment(this, this.getBestOverlappingUp());
            ovlval |= alignment;
        }
        Word.log().finest("Overlap Value for the word(ID,Content): (" + this.getId() + "," + this.getContent() + ")" + ", is " + ovlval);
        this.setOverlapValue(ovlval);
    }

    @Override
    public String toString() {
        return "(" + this.getX0() + "," + this.getY0() + "," + this.getX1() + "," + this.getY1() + "," + this.getContent() + ", Id: " + this.getId() + ")";
    }

    @Override
    public String getContent() {
        return this.contents;
    }

    public int compareTo(Object obj) {
        return super.compare(this, (BoundingBox)obj);
    }

    public Word getPrevious() {
        return this.previous;
    }

    public void setPrevious(Word previous) {
        this.previous = previous;
    }

    public Word getNext() {
        return this.next;
    }

    public void setNext(Word next) {
        this.next = next;
    }

    public Line getLine() {
        return this.line;
    }

    public void setLine(Line line) {
        this.setStatus(WordStatus.ASSOCIATED_TO_LINE);
        this.line = line;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public WordStatus getStatus() {
        return this.status;
    }

    public void setStatus(WordStatus status) {
        this.status = status;
    }

    public Word getFirstOverlappingAbove() {
        return this.firstOverlappingAbove;
    }

    public void setFirstOverlappingAbove(Word firstOverlappingAbove) {
        this.firstOverlappingAbove = firstOverlappingAbove;
    }

    public Word getLastOverlappingAbove() {
        return this.lastOverlappingAbove;
    }

    public void setLastOverlappingAbove(Word lastOverlappingAbove) {
        this.lastOverlappingAbove = lastOverlappingAbove;
    }

    public Word getNextOverlapping() {
        return this.nextOverlapping;
    }

    public void setNextOverlapping(Word nextOverlapping) {
        this.nextOverlapping = nextOverlapping;
    }

    public Block getBlock() {
        return this.block;
    }

    public void setBlock(Block block) {
        this.block = block;
    }

    public Word getFirstOverlappingDown() {
        return this.firstOverlappingDown;
    }

    public void setFirstOverlappingDown(Word firstOverlappingDown) {
        this.firstOverlappingDown = firstOverlappingDown;
    }

    public Word getLastOverlappingDown() {
        return this.lastOverlappingDown;
    }

    public void setLastOverlappingDown(Word lastOverlappingDown) {
        this.lastOverlappingDown = lastOverlappingDown;
    }

    public int getNumbOverlappingWordsUp() {
        return this.numbOverlappingWordsUp;
    }

    public void setNumbOverlappingWordsUp(int numbOverlappingWordsUp) {
        this.numbOverlappingWordsUp = numbOverlappingWordsUp;
    }

    public int getNumbOverlappingWordsDown() {
        return this.numbOverlappingWordsDown;
    }

    public void setNumbOverlappingWordsDown(int numbOverlappingWordsDown) {
        this.numbOverlappingWordsDown = numbOverlappingWordsDown;
    }

    public Word getNextInBlock() {
        return this.nextInBlock;
    }

    public void setNextInBlock(Word nextInBlock) {
        this.nextInBlock = nextInBlock;
    }

    public Word getPreviousInBlock() {
        return this.previousInBlock;
    }

    public void setPreviousInBlock(Word previousInBlock) {
        this.previousInBlock = previousInBlock;
    }

    public int getSpaceLeft() {
        return this.spaceLeft;
    }

    public void setSpaceLeft(int spc_left) {
        this.spaceLeft = spc_left;
    }

    public int getSpaceRight() {
        return this.spaceRight;
    }

    public void setSpaceRight(int spc_right) {
        this.spaceRight = spc_right;
    }

    public int getSpacelength() {
        return this.spacelength;
    }

    public void setSpacelength(int spacelength) {
        this.spacelength = spacelength;
    }

    public Word getPreviousInLine() {
        return this.previousInLine;
    }

    public void setPreviousInLine(Word previousInLine) {
        this.previousInLine = previousInLine;
    }

    public Word getNextInLine() {
        return this.nextInLine;
    }

    public void setNextInLine(Word nextInLine) {
        this.nextInLine = nextInLine;
    }

    public String getContents() {
        return this.contents;
    }

    public void setContents(String contents) {
        this.contents = contents;
    }

    public int getOverlapValue() {
        return this.overlapValue;
    }

    public void setOverlapValue(int overlapValue) {
        this.overlapValue = overlapValue;
    }

    public Word getBestoverlapping() {
        return this.bestOverlappingDown;
    }

    public void setBestoverlapping(Word bestoverlapping) {
        this.bestOverlappingDown = bestoverlapping;
    }

    public Word getBestOverlappingDown() {
        return this.bestOverlappingDown;
    }

    public void setBestOverlappingDown(Word bestOverlappingDown) {
        this.bestOverlappingDown = bestOverlappingDown;
    }

    public Word getBestOverlappingUp() {
        return this.bestOverlappingUp;
    }

    public void setBestOverlappingUp(Word bestOverlappingUp) {
        this.bestOverlappingUp = bestOverlappingUp;
    }
}

