/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.tablerecognizer.block;

import de.dfki.tablerecognizer.parameters.TableRecognizerParameters;
import java.util.Comparator;

public class BoundingBox
implements Comparator<BoundingBox> {
    private int x0 = Integer.MAX_VALUE;
    private int y0 = Integer.MAX_VALUE;
    private int x1 = Integer.MIN_VALUE;
    private int y1 = Integer.MIN_VALUE;

    public BoundingBox() {
    }

    public static double calculateOverlapAreaRatio(BoundingBox a, BoundingBox b) {
        double overlapArea = (Math.min(a.getX1(), b.getX1()) - Math.max(a.getX0(), b.getX0())) * (Math.max(a.getY0(), b.getY0()) - Math.min(a.getY1(), b.getY1()));
        double aArea = a.getWidth() * a.getHeight();
        return overlapArea / aArea;
    }

    public static int yBoxDistance(BoundingBox a, BoundingBox b) {
        return Math.min(Math.abs(b.getY0() - a.getY1()), Math.abs(a.getY0() - b.getY1()));
    }

    public static int xBoxDistance(BoundingBox a, BoundingBox b) {
        return Math.min(Math.abs(a.getX0() - b.getX1()), Math.abs(b.getX0() - a.getX1()));
    }

    public BoundingBox(int x0, int y0, int x1, int y1) {
        this.setX0(x0);
        this.setY0(y0);
        this.setX1(x1);
        this.setY1(y1);
    }

    @Override
    public int compare(BoundingBox b1, BoundingBox b2) {
        int returnval = -1234;
        if (this.isAbove(b1, b2) || this.isRightNeighbor(b1, b2)) {
            returnval = 1;
        } else if (this.isBelow(b1, b2) || this.isLeftNeighbor(b1, b2)) {
            returnval = -1;
        } else if (b1.equals(b2)) {
            returnval = 0;
        }
        return returnval;
    }

    public String toString() {
        return "(" + this.x0 + "," + this.y0 + "," + this.x1 + "," + this.y1 + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof BoundingBox) {
            BoundingBox b = (BoundingBox)o;
            return this.getX0() == b.getX0() && this.getX1() == b.getX1() && this.getY0() == b.getY0() && this.getY1() == b.getY1();
        }
        throw new ClassCastException();
    }

    public static boolean overlapsVertically(BoundingBox b1, BoundingBox b2) {
        return b1.getY0() < b2.getY1() && b2.getY0() < b1.getY1();
    }

    public static boolean overlapsHorizontally(BoundingBox b1, BoundingBox b2) {
        return b1.getX0() < b2.getX1() && b2.getX0() < b1.getX1();
    }

    protected boolean isAbove(BoundingBox b1, BoundingBox b2) {
        if (!this.overlapsAlongXAxis(b1, b2)) {
            return BoundingBox.center(b1.getY0(), b1.getY1()) > BoundingBox.center(b2.getY0(), b2.getY1());
        }
        return false;
    }

    protected boolean isBelow(BoundingBox b1, BoundingBox b2) {
        return !this.isAbove(b1, b2);
    }

    protected boolean isLeftNeighbor(BoundingBox b1, BoundingBox b2) {
        return !this.isRightNeighbor(b1, b2);
    }

    protected boolean isRightNeighbor(BoundingBox b1, BoundingBox b2) {
        return this.overlapsAlongXAxis(b1, b2) && b1.getX0() >= b2.getX1();
    }

    public boolean overlapsAlongXAxis(BoundingBox b1, BoundingBox b2) {
        return (double)b1.getY0() + (double)b1.getHeight() * 0.1 < (double)b2.getY1() - (double)b2.getHeight() * 0.1 && (double)b1.getY1() - (double)b1.getHeight() * 0.1 > (double)b2.getY0() + (double)b2.getHeight() * 0.1;
    }

    public int getWidth() {
        return Math.abs(this.getX1() - this.getX0());
    }

    public int getHeight() {
        return Math.abs(this.getY1() - this.getY0());
    }

    public static int center(int x0, int x1) {
        return (x0 + x1) / 2;
    }

    public int getX0() {
        return this.x0;
    }

    public void setX0(int x0) {
        this.x0 = x0;
    }

    public int getY0() {
        return this.y0;
    }

    public void setY0(int y0) {
        this.y0 = y0;
    }

    public int getX1() {
        return this.x1;
    }

    public void setX1(int x1) {
        this.x1 = x1;
    }

    public void updateBoundingBox(BoundingBox box) {
        if (this.getX0() > box.getX0()) {
            this.setX0(box.getX0());
        }
        if (this.getY0() > box.getY0()) {
            this.setY0(box.getY0());
        }
        if (this.getX1() < box.getX1()) {
            this.setX1(box.getX1());
        }
        if (this.getY1() < box.getY1()) {
            this.setY1(box.getY1());
        }
    }

    public String getContent() {
        return "";
    }

    public int getY1() {
        return this.y1;
    }

    public static int yDistance(BoundingBox b1, BoundingBox b2) {
        return b2.getY0() - b1.getY1();
    }

    public static boolean overlaps(BoundingBox block1, BoundingBox block2) {
        BoundingBox b1 = block1;
        BoundingBox b2 = block2;
        if (b1.getWidth() < b2.getWidth()) {
            BoundingBox tmp = b2;
            b2 = b1;
            b1 = tmp;
        }
        float x0Min = (float)b1.getX0() - TableRecognizerParameters.blockHeight * TableRecognizerParameters.xTolerance_M;
        float x1Max = (float)b1.getX1() + TableRecognizerParameters.blockHeight * TableRecognizerParameters.xTolerance_M;
        float y0Min = (float)b1.getY0() - TableRecognizerParameters.blockHeight * TableRecognizerParameters.yTolerance_M;
        float y1Max = (float)b1.getY1() + TableRecognizerParameters.blockHeight * TableRecognizerParameters.yTolerance_M;
        return ((float)b2.getX0() >= x0Min && (float)b2.getX0() <= x1Max || (float)b2.getX1() >= x0Min && (float)b2.getX1() <= x1Max) && ((float)b2.getY0() >= y0Min && (float)b2.getY0() <= y1Max || (float)b2.getY1() >= y0Min && (float)b2.getY1() <= y1Max);
    }

    public void setY1(int y1) {
        this.y1 = y1;
    }
}

