#ifndef OCRWIN_HH
# define OCRWIN_HH

#include <QtGui>
#include "ui_ocrwin.h"

class ocrwin : public QDialog, private Ui::OcrWin
{
  Q_OBJECT;

public:
  ocrwin(const QImage& orig,
	 const QImage& reg,
	 const std::string& newline,
	 const unsigned& id);

  const char *text() const;
  bool edit_output() const;

  void showEvent(QShowEvent * event);

  QRect orig_select() const;
  QRect reg_select() const;

public slots:
  void new_orig_select(const QRectF& rect);
  void new_reg_select(const QRectF& rect);

private:
  QRectF orig_domain_;
  QRectF orig_select_;
  QRectF reg_domain_;
  QRectF reg_select_;
};

#endif // ! OCRWIN_HH
