#include "ocrwin.hh"

ocrwin::ocrwin(const QImage& orig,
	       const QImage& reg,
	       const std::string& newline,
	       const unsigned& line_id)
{
  setupUi(this);

  connect(origpix->scene(), SIGNAL(new_selection(const QRectF&)),
	  this, SLOT(new_orig_select(const QRectF&)));
  origpix->update_image(orig);
  origpix->scene()->setSelectionTracking(true);
  orig_domain_ = orig.rect();
  orig_select_ = orig.rect();
  origpix->expand_to_content();

  connect(regpix->scene(), SIGNAL(new_selection(const QRectF&)),
	  this, SLOT(new_reg_select(const QRectF&)));
  regpix->update_image(reg);
  regpix->scene()->setSelectionTracking(true);
  reg_domain_ = reg.rect();
  reg_select_ = reg.rect();
  regpix->expand_to_content();

  ocrgt->setText(QString::fromUtf8(newline.c_str()));

  origpix->setMinimumSize(QSize(orig_domain_.width() + 50, orig_domain_.height() + 100));
  regpix->setMinimumSize(QSize(reg_domain_.width() + 50, reg_domain_.height() + 100));

  ocrgt->setFocus(Qt::MouseFocusReason);

  setWindowTitle(QString("Editing line %1").arg(line_id));
}


const char *
ocrwin::text() const
{
  return ocrgt->toPlainText().toUtf8().data();
}

bool
ocrwin::edit_output() const
{
  return cBox->isChecked();
}

void
ocrwin::new_orig_select(const QRectF& rect)
{
  orig_select_ = orig_domain_.intersected(rect.toRect());
  qDebug() << orig_select_;
}

void
ocrwin::new_reg_select(const QRectF& rect)
{
  reg_select_ = reg_domain_.intersected(rect.toRect());
  qDebug() << reg_select_;
}

void
ocrwin::showEvent(QShowEvent * event)
{
  event->accept();
  regpix->on_zoomOriginal_clicked();
  origpix->on_zoomOriginal_clicked();
}

QRect ocrwin::orig_select() const
{
  return orig_select_.toRect();
}

QRect ocrwin::reg_select() const
{
  return reg_select_.toRect();
}
