#include <iostream>
#include <QApplication>
#include <QTimer>
#include <match.hh>
#include <extract.hh>

void erreur(const char *txt)
{
  std::cerr << txt << std::endl;
  exit(-1);
}

int main(int argc, char *argv[])
{
  QApplication app(argc, argv, true);

  if (argc == 5 && argv[1] == std::string("--match"))
  {
    // Task parented to the application so that it
    // will be deleted by the application.
    match *t = new match(argc, ++argv, &app);

    // This will cause the application to exit when
    // the match signals finished.
    QObject::connect(t, SIGNAL(finished()), &app, SLOT(quit()));

    // This will run the task from the application event loop.
    QTimer::singleShot(0, t, SLOT(run()));
  }
  else if (argc == 5 && argv[1] == std::string("--extract"))
  {
    // Task parented to the application so that it
    // will be deleted by the application.
    extract *t = new extract(argc, ++argv, &app);

    // This will cause the application to exit when
    // the task signals finished.
    QObject::connect(t, SIGNAL(finished()), &app, SLOT(quit()));

    // This will run the task from the application event loop.
    QTimer::singleShot(0, t, SLOT(run()));
  }
  else
    erreur("usage : [ --match img_scanned.png orig.png ocr_gt.txt | --extract <bindir> <bboxdir> <outdir> ]");

  return app.exec();
}
