#ifndef LOWOVERLAP_HH
# define LOWOVERLAP_HH

#include <QtGui>
#include <ui_lowoverlap.h>
#include <scribo/core/line_info.hh>

class lowoverlap : public QDialog, private Ui::LowOverlapWin
{
  Q_OBJECT;

public:
  lowoverlap(QWidget * parent = 0, Qt::WindowFlags f = 0);

  lowoverlap(const QString& title,
	     const std::vector<std::pair<scribo::line_id_t, const char *> >& ids,
	     const QImage& ima);

  lowoverlap(const QString& title, const QImage& ima);

  const scribo::line_id_t& selected() const;

private slots:
  void set_selected(QAbstractButton *btn);


private:
  scribo::line_id_t selected_;
  std::vector<std::pair<scribo::line_id_t, const char *> > ids_;
};


#endif // ! LOWOVERLAP_HH
