#include "lowoverlap.hh"
#include <scribo/core/line_info.hh>

lowoverlap::lowoverlap(QWidget * parent, Qt::WindowFlags f)
  : QDialog(parent, f)

{
  setupUi(this);
}

lowoverlap::lowoverlap(const QString& title,
		       const std::vector<std::pair<scribo::line_id_t, const char *> >& ids,
		       const QImage& ima)
  : selected_(0), ids_(ids)
{
  setupUi(this);
  setWindowTitle(title);
  label->setText(title);

  for (size_t i = 0; i < ids.size(); ++i)
  {
    buttonBox->addButton(QString("%1").arg(ids[i].second), QDialogButtonBox::AcceptRole);
    connect(buttonBox, SIGNAL(clicked(QAbstractButton *)),
	    this, SLOT(set_selected(QAbstractButton *)));
  }

  imagelbl->setPixmap(QPixmap::fromImage(ima));
}

lowoverlap::lowoverlap(const QString& title,
		       const QImage& ima)
 : selected_(0)
{
  setupUi(this);
  setWindowTitle(title);
  label->setText(title);
  imagelbl->setPixmap(QPixmap::fromImage(ima));
}



const scribo::line_id_t&
lowoverlap::selected() const
{
  return selected_;
}


void
lowoverlap::set_selected(QAbstractButton *btn)
{
  for (size_t i = 0; i < ids_.size(); ++i)
    if (ids_[i].second == btn->text())
      selected_ = ids_[i].first;
}
